

* PROCESS for SAS version 5.0;
* Written by Andrew F. Hayes;
* www.afhayes.com;
* www.processmacro.org;
* Copyright 2013-2025 by Andrew F. Hayes;
* PROCESS is documented in http://www.guilford.com/p/hayes3 and supplements;
* PROCESS workshop schedule at http://haskayne.ucalgary.ca/CCRAM;

* THIS CODE SHOULD BE DISTRIBUTED ONLY THROUGH PROCESSMACRO.ORG;
* AND NOT POSTED OR STORED ON ANY WEB PAGE OR SERVE WITHOUT PERMISSION;
* THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND;
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF;
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT;
* IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, ;
*  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT;
* OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE ;
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE ;
* USE OF THIS SOFTWARE IMPLIES AGREEMENT WITH THESE TERMS ;


%macro hcest3 (x2=,resid2=,hc=,mse2=);
  n1=nrow(&x2);
  invXtX=inv((&x2)`*&x2);varb=&mse2*invXtX;k3 = ncol(&x2);xhc=0;
  *cluster robust varb;
  if (&hc = 6) then;do;
    xcrub=clusdat[,3]||&x2||&resid2;
    temp=xcrub;
    temp[rank(xcrub[,1]),]=xcrub;
    xcrub=temp;
    free temp;
    crres=xcrub[,ncol(xcrub)];
    xcrub=xcrub[,2:(ncol(xcrub)-1)];
    meat=j(ncol(xcrub),ncol(xcrub),0);
    do clbt=1 to nclus;
      xmeat=xcrub[current[clbt,3]:current[clbt,4],];
      meate=crres[current[clbt,3]:current[clbt,4],1];
      meat=meat+(xmeat`*meate*meate`*xmeat);
    end;
    varb=(invXtX*meat*invXtX)*((nclus/(nclus-1))*((n1-1))/(n1-ncol(xcrub)));
    free xcrub;free crres;
  end;
  
  if (&hc < 5) then;do;
    xhc=&x2;hat = xhc[,1];
    do i3=1 to nrow(xhc);hat[i3,1]= xhc[i3,]*invXtX*(xhc[i3,])`;end;
    if ((&hc = 0) | (&hc =1)) then;do;
      do i3 = 1 to k3;xhc[,i3]=xhc[,i3]#&resid2;end;
    end;
    if ((&hc =3) | (&hc=2)) then;do;
      do i3=1 to k3;xhc[,i3] = (&resid2/(1-hat)##(1/(4-&hc)))#xhc[,i3];
      end;
    end;
    if (&hc = 4) then;do;
      hcmn=j(n1,2,4);hcmn[,2]=(n1*hat)/k3;
	  rminhcmn=hcmn[,><];
      do i3= 1 to k3;
        xhc[,i3] = (&resid2/(1-hat)##(rminhcmn/2))#xhc[,i3];
      end;
    end;
    varb=invXtX*xhc`*xhc*invXtX;
    if (&hc=1) then;do;
      varb=(n1/(n1-ncol(&x2)))#varb;
    end;
  end;
  hclab="se(HC0)"||"se(HC1)"||"se(HC2)"||"se(HC3)"||"se(HC4)"||"se"||"se(CR)";
  hclab=hclab[1,(&hc+1)];
  hcflab="F(HC0)"||"F(HC1)"||"F(HC2)"||"F(HC3)"||"F(HC4)"||"F"||"F(CR)";
  hcflab=hcflab[1,(&hc+1)];
  free xhc;
%mend hcest3;

%macro longchk (variab=);
  save4sv="CASENUM"||"PRED"||"RESID"||"D_RESID"||"STRESID"||"TRESID"||"H"||"MAHAL"||"COOK"||"DMSREG"||"DRSQ"||"DSKEW"||dfbetasC`||dfindsC`;
  if (savediag=1) then;do;
    sv4chk2=&variab;
    do sv4chk=1 to ncol(save4sv);
	  do sv4chk3=1 to ncol(sv4chk2);
	    if (upcase(sv4chk2[1,sv4chk3])=save4sv[1,sv4chk]) then;do;
           if (sv4match=0) then;do;
             sv4match=1;notecode[notes,1]=39;notes=notes+1; 
           end;
	    end;
	  end;
    end;
  end;
%mend longchk;

%macro modeles3 (y=,x=,type=,full=);
  eiverr=0;
  if (&type=1) then;do;
	n1=nrow(&x);n=n1;
    invtxx=inv((&x)`*&x);
	hatmat=invtxx*&x`;
	if (eivdo=0) then;do;b=hatmat*&y;end;
	if (eivdo=1) then;do;
	  relcorv=1;
	  if (eiv > 9) then;do;
	    relcorv=(1-(ncol(&x)/nrow(&x)));
	  end;
      varx = ((n1*&x[##,])-(&x[+,]##2))/((n1-1)*n1);
      varx=varx*(n1-1)/n1;     
      varxr=n1*(1-releiv)#varx;
      aiev=(t(&x)*&x)-relcorv*diag(varxr);
	  itsh=inv(aiev);
      hatval2=j(n1,1,0);
	  xhc=&x;
      *if (eiv=1) then;*do;
	  *  do i3=1 to nrow(xhc);*hatval2[i3,1]= &x[i3,]*itsh*(&x[i3,])`;*end;
	  *end;
	  if ((eiv=2) | (eiv=3) | (eiv=12) | (eiv=13)) then;do;
	    do i3=1 to nrow(xhc);hatval2[i3,1]= &x[i3,]*invtxx*(&x[i3,])`;end;
	  end;
      b=itsh*(&x)`*&y;    
      yeiv=&y; 
      if (&full=0) then;do;
        mseb=((&y`*&y)-(b`*aiev*b))/(n1-ncol(&x));
        sstotalb = (&y-(&y[+,]/n1))`*(&y-(&y[+,]/n1));
        r2b=1-((mseb*(n1-ncol(&x)))/sstotalb);
		if ((r2b < 0) | (mseb < 0)) then;do;
		  eiverr=1;
		end;
      end;
	end;
	modres=b;
    if (&full=1) then;do;
      if (eivdo=1) then;do;
        mse=((&y`*&y)-(b`*aiev*b))/(n1-ncol(&x));
        sstotal = (&y-(&y[+,]/n1))`*(&y-(&y[+,]/n1));
        r2=1-((mse*(n1-ncol(&x)))/sstotal);
		if ((r2 < 0) | (mse < 0)) then;do;
		  eiverr=1;
		  errcode[errs,1]=85;errs=errs+1;criterr=1;
		end;
		if (((eiv=5) | (eiv=15)) & (eiverr=0)) then;do;
          varb=mse*inv(aiev)*&x`*&x*inv(aiev);
        end;
        if (((eiv=4) | (eiv=14)) & (eiverr=0)) then;do;
            varxr2=diag(varxr);
            eivtmp=(b`*varxr2)#(b`*varxr2);
            eivtmp=diag(eivtmp);
            varb=((mse)*inv(aiev))+((inv(aiev)/nrow(&x))*((varxr2*mse)+(varxr2*b*b`*varxr2)+2*eivtmp)*inv(aiev));
        end;
        if (((eiv=0) | (eiv=1) | (eiv=2) | (eiv=3) | (eiv=10) | (eiv=11) | (eiv=12) | (eiv=13)) & (eiverr=0)) then;do;
          resideiv=yeiv-&x*b;
          hb1eiv=&x;
          hb2eiv=&x;
          do ieiv = 1 to ncol(&x);
		    if ((eiv=3) | (eiv=0) | (eiv=1) | (eiv=13) | (eiv=10)) then;do;
              hb1eiv[,ieiv]=hb1eiv[,ieiv]#(resideiv/(1-hatval2));
			end;
			if ((eiv=2) | (eiv=12)) then;do;
              hb1eiv[,ieiv]=hb1eiv[,ieiv]#(resideiv/sqrt(1-hatval2));
			end;
			cstmp1=x[,ieiv];
            xmeaneiv=cstmp1[+,]/n1;
            xmeaneiv=j(n1,1,xmeaneiv);
            hb2eiv[,ieiv]=(hb2eiv[,ieiv]-xmeaneiv)##2;
          end;
          hbeiv=(1-releiv)#b`;
          hbeiv=diag(hbeiv);
          hb3eiv=j(n1,ncol(&x),1);
          hb3eiv=hb3eiv*hbeiv;
          Heiv=hb1eiv+(hb2eiv#hb3eiv);
          varb=inv(aiev)*Heiv`*Heiv*inv(aiev);
		  if ((eiv=1) | (eiv=11)) then;do;
		    varb=varb*(n1/(n1-ncol(&x)));
		  end;
		  if ((eiv < 4) & (eivhcnt=0)) then;do;
		    notecode[notes,1]=4;notes=notes+1;eivhcnt=1;
		  end;
		  free hb1eiv;free hb2eiv;free hb3eiv;free cstmp1;
        end;
        *hclab="se";*hcflab="F";
        adjr2=0;
        hclab="se(HC0)"||"se(HC1)"||"se(HC2)"||"se(HC3)"||"se"||"se";
        hclab=hclab[1,(eiv+1)];
        hcflab="F(HC0)"||"F(HC1)"||"F(HC2)"||"F(HC3)"||"F"||"F";
        hcflab=hcflab[1,(eiv+1)];
        dfres=(n1-(ncol(&x)))*(1-robustse)+((nclus-1)*robustse);     
      end;


      * start eiv1;
    if (eivdo=0) then;do;  
	  ypredv=&x*b;
	  resid=&y-ypredv;
	  hatval=j(n1,1,0);
	  do i3 = 1 to n1;
	    hatval[i3,1]=&x[i3,]*invtxx*(&x[i3,])`;
	  end;
	  yh=((x*b)-hatval#y)/(1-hatval);
	  ex=resid/(1-hatval);
	  modresdf=j(n1,ncol(&x),0);
	  do i3 = 1 to ncol(&x);
	    modresdf[,i3]=((hatmat[i3,])#(ex)`)`;
	  end;
      dfres=(n1-(ncol(&x)))*(1-robustse)+((nclus-1)*robustse);
      sstotal = (&y-(&y[+,]/n1))`*(&y-(&y[+,]/n1));
      ssresid = resid`*resid;
      * start snip here from below;
      mse=ssresid/(n1-ncol(&x));
	  * end snip;
      cbres=(resid##3);cbres=cbres[+,];
      qbres=(resid##4);qbres=qbres[+,];
	  skewres=(n1*cbres)/((n1-2)*ssresid*sqrt(ssresid/(n1-1)));
      kurtres=(((n1+1)*n1*(n1-1))/((n1-2)*(n1-3)))*(qbres/(ssresid*ssresid));
      kurtres=kurtres-(3*((n1-1)*(n1-1))/((n1-2)*(n1-3)));
	  skewse=sqrt(((6*n1)*(n1-1))/((n1-2)*(n1+1)*(n1+3)));
      kurtse=sqrt((24*n1*(n1-1)*(n1-1))/((n1-3)*(n1-2)*(n1+3)*(n1+5)));
      skewres=(skewres||kurtres)//(skewse||kurtse);
      ssreg=sstotal-ssresid;
      sumtable=(ssreg||(ncol(&x)-1)||(ssreg/(ncol(&x)-1)))//(ssresid||(n1-ncol(&x))||(ssresid/(n1-ncol(&x))))//(sstotal||(n1-1)||(sstotal/(n1-1))); 
      r2=(sstotal-ssresid)/sstotal;
	  if (r2 < 0) then;do;r2=0;end;
      adjr2 = 1-((1-r2)*(n1-1)/(n1-ncol(&x)));	        
	  mndevy=(&y-(&y[+,]/n1));
      msresch=((ex#resid)-mse)/(n1-ncol(&x)-1);
	  *new here;
	  skewwo=j(n1,1,9999);
	  *scresnoi=j(n1,1,0);
	  *do wadf2=1 to nrow(modresdf);
      *  cresnoi=(&y-(&x*(b-t(modresdf[wadf2,]))))##3;
      *  scresnoi[wadf2,1]=(n1-1)*(cresnoi[+,]-cresnoi[wadf2,1]);   
	  *end;
	  *denomsk=(n1-3)*(ssresid-(ex#resid))#sqrt((ssresid-(ex#resid))/(n1-2));     
      *skewwo=skewres[1,1]-(scresnoi/denomsk);
	  *end new here;
      rchngwo=r2-(1-((ssresid-(ex#resid))/(sstotal-((n1*(mndevy#mndevy))/(n1-1)))));
      stri=resid/sqrt((1-hatval)*mse);
	  tri=stri#sqrt(((n1-ncol(&x))-1)/((n1-ncol(&x))-(stri#stri)));
	  mahal=(n1*hatval-1)*((n1-1)/n1);
	  cook=(stri#stri)#(hatval/((1-hatval)*(ncol(x))));
	  regdiag=rownum||x[,2:ncol(x)]||y||ypredv||resid||ex||stri||tri||hatval||mahal||cook||msresch||rchngwo||skewwo||modresdf;
	  if ((diagnose=1) | (savediag=1)) then;do;
	  *find the most extreme dfbeta values; 
        wadf=j(ncol(modresdf),2,0);
        do wadf1=1 to ncol(modresdf);
          do wadf2=1 to nrow(modresdf);
            if ((abs(modresdf[wadf2,wadf1])) > abs(wadf[wadf1,2])) then;do;
              wadf[wadf1,2]=modresdf[wadf2,wadf1];
              wadf[wadf1,1]=rownum[wadf2,1];
            end;                     
          end;
        end;
	    alldfbs=alldfbs||modresdf;
        ptri=2*(1-probt(abs(tri),(n1-ncol(&x))-1));
        bp=n*ptri;
        bpm=bp-1;
        bp=bp-(bpm#(bp > 1));
	    bp=abs(tri)||bp||rownum;
	    temp=bp;
        temp[rank(bp[,1]),]=bp;
	    bp=temp;
	    bp=bp[n1,];
	    sqruncr=ssresid/n1;   
        qprime=((resid#resid)-sqruncr)/sqruncr;
        bptest=0.5*(qprime`*x*hatmat*qprime);
        bprobust=bptest*(2/((qprime`*qprime)/n1));
        bpresult=bptest||(ncol(x)-1)||(1-probchi(bptest,(ncol(x)-1)));
        bpresul2=bprobust||(ncol(x)-1)||(1-probchi(bprobust,(ncol(x)-1)));
	    bpresult=bpresult//bpresul2;
	  end;
	  *msreg=ssreg/ncol(&x);
      %hcest3 (x2=x,resid2=resid,hc=hc,mse2=mse);
    end;
	* end no eiv1;
      if (eiverr=0) then;do;
        seb=sqrt(vecdiag(varb));
        trat = b/seb;
        p = 2*(1-probt(abs(trat),(dfres)));
        *tval=sqrt(dfres*(exp((dfres-(5/6))*((xp2/(dfres-(2/3)+(.11/dfres)))*(xp2/(dfres-(2/3)+(.11/dfres)))))-1));
	    tval=-quantile('t',alpha2,dfres);
        modres=modres||seb||trat||p;
        modres=modres||(b-tval#seb)||(b+tval#seb);
        modresl=" coeff"||hclab||"t"||"p"||"LLCI"||"ULCI";
        lmat=I(ncol(&x));
        lmat=lmat[,2:ncol(lmat)];
	    modsum=sqrt(r2)||r2||adjr2||99999||99999||sqrt(mse);
	    modsuml="R"||"R-sq"||"Adj R-sq"||hcflab||"p"||"SEest";
	    rankofvb=round(trace(ginv(varb)*varb));
	    if ((ncol(lmat) > rankofvb) | (ncol(lmat) > (nclus-1))) then;do;intncd=1;end;
	    if ((ncol(lmat) <= rankofvb) & (ncol(lmat) <= (nclus-1))) then;do;
          fratio = ((lmat`*b)`*inv(lmat`*varb*lmat)*((lmat`*b)))/(ncol(&x)-1);
	      pfr=1-probf(fratio,(ncol(&x)-1),dfres);
          modsum=sqrt(r2)||r2||adjr2||fratio||pfr||sqrt(mse);
	    end;
	  end;
    
	* start no eiv2;
    if (eivdo=0) then;do;

	  sehomo=sqrt(vecdiag(mse*invtxx));
      srrat=b/sehomo;
      sign=b/abs(b);
      semir=srrat*sqrt((1-r2)/(n1-ncol(&x))); 
      partialr=sqrt((srrat#srrat)/((srrat#srrat)+(n1-ncol(&x))))#sign;
      browne=0;iv5=&y||yh;
      sigmatal=((iv5-J(n1,1)*iv5[:,])`*(iv5-J(n1,1)*iv5[:,]))/(n1-1);
      sdvec=sqrt(diag(sigmatal));
      sdall=diag(1/vecdiag(sdvec));
      sdvec=vecdiag(sdvec); 
      corall=sdall*sigmatal*sdall`;
	  lvout1=corall[2,1];
	  if (adjr2 >= 0) then;do;
	    rho4=(adjr2*adjr2)-((2*(ncol(&x)-1)*(1-adjr2)*(1-adjr2))/((n1-1)*(n1-(ncol(&x)-1)+1)));
        if (rho4 >= 0) then;do;
	      browne=sqrt(((n1-(ncol(&x)-1)-3)*rho4+adjr2)/((n1-2*(ncol(&x)-1)-2)*adjr2+(ncol(&x)-1)));
	    end;
	  end;
	  my=&y[+,]/n1;
	  newsse=(ssresid#(n1-(ncol(&x)-1)-2))/((tri#tri)+n1-(ncol(&x)-1)-2);
	  dleave=(my-&y)/(n1-1);
	  yd=&y-my;
      newtss=sstotal+n1#(dleave#dleave)-((&y-my-dleave)#(&y-my-dleave));
      newvhaty=(newtss/n1)#(1-newsse/newtss);
	  zh=(yh-dleave-my)/sqrt(newvhaty);
      temptxd=y||x[,2:ncol(x)]||yh||zh;      
      sigmatal=((temptxd-J(n1,1)*temptxd[:,])`*(temptxd-J(n1,1)*temptxd[:,]))/(n1-1);
      sdvec=sqrt(diag(sigmatal));
      sdall=diag(1/vecdiag(sdvec));
      sdvec=vecdiag(sdvec); 
      corall=sdall*sigmatal*sdall`;
      corbxx=corall[2:ncol(x),2:ncol(x)];
      tolstat=j((ncol(x)-1),1,9999);
      do tolcom=1 to (ncol(x)-1);
        riichoose=I(ncol(x)-1);
        riichoose[tolcom,tolcom]=0;
        riix=riichoose*corbxx*riichoose`;
        riix[tolcom,tolcom]=1;
        riiy=corbxx[,tolcom]#vecdiag(riichoose);
        tolstat[tolcom,1]=1-(riiy`*inv(riix)*riiy);
      end;
	  sdvec=sdvec[1:(nrow(sdvec)-2),1];
      tildeb=(modres[,1]#sdvec)/sdvec[1,1];
	  tildebY=modres[,1]/sdvec[1,1];
	  tildebx=modres[,1]#sdvec;
	  crossr=browne||corall[(nrow(corall)-1),1]||corall[nrow(corall),1];
      zppout=corall[2:(nrow(corall)-2),1]||semir[2:nrow(semir),1]||partialr[2:nrow(partialr),1];
      zppout=zppout||tildeb[2:nrow(tildeb),1]||tildebY[2:nrow(tildebY),1]||tildebX[2:nrow(tildebX),1];
      zppout2=zppout[,2]##2||zppout[,3]##2||(zppout[,2]##2)/(1-r2); 

	end;
	  *end no eiv2;

      if ((ssquares=0) & (eiverr=0)) then;do;
        modsum=sqrt(r2)||r2||mse||99999||99999||99999||99999;
        modsuml="R"||"R-sq"||"MSE"||hcflab||"df1"||"df2"||"p";
        if ((ncol(lmat) <= rankofvb) & (ncol(lmat) <= (nclus-1))) then;do;
          modsum=sqrt(r2)||r2||mse||fratio||(ncol(&x)-1)||dfres||pfr;
		  if (eivdo=1) then;do;modsuml=modsuml[1,2:ncol(modsuml)];modsum=modsum[1,2:ncol(modsum)];end;
        end;
      end;
	  if (diagnose=1) then;do;
        maxnmin=j(3,2,0); 
        maxnmin[1,1]=min(ypredv);maxnmin[1,2]=max(ypredv);
        maxnmin[2,1]=min(resid);maxnmin[2,2]=max(resid);
        maxnmin[3,1]=min(tri);maxnmin[3,2]=max(tri);
        trmin=min(tri);
	    if ((bp[1,1]=abs(trmin)) & (trmin < 0)) then;do;
          bp[1,1]=-bp[1,1];
	    end;
	  end;
    end;
  end;
  if ((&type=2) | (&type=3)) then;do;
    xlp=&x;ylp=&y;
	meanylp=ylp[+,]/nrow(ylp);
	pt2=j(nrow(ylp),1,meanylp);
	if (&type=2) then;do;LL3 = ylp#log(pt2)+(1-ylp)#log(1-pt2);end;
	LL3 = -2*LL3[+,];
	bt1=j(ncol(xlp),1,0);
	LL1=0;
	LL2=LL3;
	pt1=j(nrow(ylp),1,0.5);
    pt1lp=pt1;
	do jjj= 1 to iterate UNTIL (abs(LL1-LL2) < converge);
	  LL1=LL2;
	  xlptmp=xlp`;
	  vecprb=pt1lp#(1-pt1lp);
	  do kkk=1 to ncol(xlp);xlptmp[kkk,]=xlptmp[kkk,]#vecprb`;end;
	  b=bt1+inv(xlptmp*xlp)*xlp`*(ylp-pt1lp);
	  if (&type=2) then;do;
	    xlpb=xlp*b;xlpbt=(xlpb > -709.7);xlpb709=(1-xlpbt)*(-709.7);
        xlpb=(xlpb#xlpbt)+xlpb709;
	    pt1lp = 1/(1+exp(-(xlpb)));
	  end;
      temp1=((pt1lp < .00000001) | (pt1lp > .9999999));
	  itprob=temp1[+,];
      if (itprob > 0) then;do;
        do kkk=1 to nrow(pt1lp);
		  if (pt1lp[kkk,1] > .99999999) then;do;pt1lp[kkk,1]=.99999999;end;
          if (pt1lp[kkk,1] < .00000001) then;do;pt1lp[kkk,1]=.00000001;end;
	    end;
        itprob=0;
	  end;
	  if (itprob = 0) then;do;
	    LL=ylp#log(pt1lp)+(1-ylp)#log(1-pt1lp);
		LL2=-2*LL[+,];
	  end;
      bt1=b;
	end;
    if (abs(LL1-LL2) < converge) then;do;
	  if (&full=1) then;do;
	    xlptmp=xlp`;vecprb=pt1lp#(1-pt1lp);
		do kkk=1 to ncol(xlp);xlptmp[kkk,]=xlptmp[kkk,]#vecprb`;end;
	    varb=inv(xlptmp*xlp);
	    seb=sqrt(vecdiag(varb));
	  end;
	end;
	modres=b;
    if (jjj > iterate) then;do;itprob=2;
      if (booting=0) then;do;iterrmod=1;end;
      if (booting=1) then;do;bootiter=1;end;
	  if (itprobtg=0) then;do;itprobtg=1;errcode[errs,1]=47;errs=errs+1;
        if ((boot=0) & (&full=1)) then;do;
	      vt1=diag(pt1lp#(1-pt1lp));
	      varb=inv(xlp`*vt1*xlp);
	      seb=sqrt(vecdiag(varb)); 
        end;
	  end;
    end;
    if (&full=1) then;do;
      trat=b/seb;dfres=nrow(xlp);
      p=2*(1-probnorm(abs(trat)));
      modres=modres||seb||trat||p;
	  modres=modres||(b-xp2#seb)||(b+xp2#seb);
      pvchi=1-probchi((LL3-LL2),(nrow(modres)-1));
      LLdiff=LL3-LL2;
	  mcF = LLdiff/LL3;
	  cox=1-exp(-LLdiff/n);
	  nagel=cox/(1-exp(-(LL3)/n));
	  modsum=LL2||LLdiff||(nrow(modres)-1)||pvchi||mcF||cox||nagel;
      modsuml="-2LL"||"ModelLL"||"df"||"p"||"McFadden"||"CoxSnell"||"Nagelkrk";
      modresl=" coeff"||"se"||"Z"||"p"||"LLCI"||"ULCI";
	end;
  end;
%mend modeles3;

%macro outform3 (outtodo=,outbig=);
  resultm2=j(nrow(&outtodo),&outbig,99999);
  if (ncol(&outtodo) <= &outbig) then;do;        
    resultm2[1:nrow(&outtodo),1:ncol(&outtodo)]=&outtodo;
    resultm=resultm//resultm2;
  end;
  if (ncol(&outtodo) > &outbig) then;do;        
    resultmt=j(nrow(resultm),ncol(&outtodo),99999);
    resultmt[1:nrow(resultm),1:ncol(resultm)]=resultm;
    resultm=resultmt;
    resultm2=j(nrow(&outtodo),ncol(resultm),99999);
    resultm2[1:nrow(&outtodo),1:ncol(&outtodo)]=&outtodo;
    resultm=resultm//resultm2;
    maxresm=ncol(resultm);
  end;    
%mend outform3;

%macro bcboot3 (databcbt=,estmte=9999);
temp=&databcbt;
temp[rank(temp)]=&databcbt;
badlo = 0;badhi = 0;
if (&estmte ^= 9999) then;do;
  temptemp=(temp < &estmte);
  pv=temptemp[+,]/nrow(temp);
  ppv = pv; 
  if (pv > .5) then;do;ppv = 1-pv;end;
  *y5=sqrt(-2*log(ppv));
  *xp=y5+((((y5*p4+p3)*y5+p2)*y5+p1)*y5+p0)/((((y5*q4+q3)*y5+q2)*y5+q1)*y5+q0);
  xp=-quantile('normal',ppv);
  if (pv <= .5) then;do;xp = -xp;end;
  cilow=round(nrow(temp)*(probnorm(2*xp-xp2)));
  cihigh=int(nrow(temp)*(probnorm(2*xp+xp2)))+1;
  if (cilow < 1) then;do;cilow=1;booterr=1;badlo=1;end;
  if (cihigh > nrow(temp)) then;do;cihigh = boot;booterr=1;badhi = 1;end;
  llcit=temp[cilow,1];
  ulcit=temp[cihigh,1];
  if ((badlo=1) & (llcit ^= priorlo)) then;do;
	badend=badend||llcit;
	priorlo=llcit;
  end;
  if ((badhi=1) & (ulcit ^= priorhi)) then;do;
    badend=badend||ulcit;
	priorhi=ulcit;
  end;
end;
if (&estmte = 9999) then;do;
   llcit=temp[cilow,1];
   ulcit=temp[cihigh,1];
end;
tmptmp=temp##2;tmptmp=tmptmp[+,];
bootse=((tmptmp-((temp[+,]##2)/nrow(temp)))/(nrow(temp)-1));
if (bootse < 0) then;do;bootse=0;end;
bootse=sqrt(bootse)`;
%mend bcboot3;

%macro llrtest3 (lm=);
  btemphld=b;
  llrdat=j(nrow(x),(nrow(&lm)-&lm[+,]),-999);
  llrdf=ncol(x)-ncol(llrdat);
  llrcnt=0;
  do llri=1 to nrow(&lm);
    if (&lm[llri,1]=0) then;do;
      llrcnt=llrcnt+1;
	  llrdat[,llrcnt]=x[,llri];
	end;
  end;
  %modeles3 (y=y,x=llrdat,type=2,full=0);
  b=btemphld;
  fresult=(LL2-basemod)||llrdf||(1-probchi((LL2-basemod),llrdf));
%mend;

%macro ftest3 (lm=,bcoef=,cv=0,chr=0,brsq=0,skip=0);
lmat2=&lm;
if (&skip=0) then;do;
  lmat2 = diag(&lm);
  lmat3=j(nrow(lmat2),1,0);
  do flp=1 to ncol(lmat2);
    lmatsumt=lmat2[,flp];
    if (lmatsumt[+,]=1) then;do;
      lmat3=lmat3||lmat2[,flp];
    end;
  end;
  lmat2=lmat3[,2:ncol(lmat3)];
end;
fresult=99999||99999||99999||99999;
rankofcv=round(trace(ginv(&cv)*&cv));
if ((ncol(lmat2) > rankofcv) | (ncol(lmat2) > (nclus-1))) then;do;intncd=1;end;
if ((ncol(lmat2) <= rankofcv) & (ncol(lmat2) <= (nclus-1))) then;do;
  fratio = ((lmat2`*&bcoef)`*inv(lmat2`*&cv*lmat2)*((lmat2`*&bcoef)))/ncol(lmat2);
  pfr = 1-probf(fratio,ncol(lmat2),dfres);
  fresult=fratio||ncol(lmat2)||(dfres)||pfr;
end;
if ((i =(nms+nys)) & (ydich=1)) then;do;
  fratio=fratio*ncol(lmat2);pfr=1-probchi(fratio,ncol(lmat2));fresult=fratio||ncol(lmat2)||pfr;
end;
if (&chr=1) then;do;
  lmat3=1-lmat2[,+];
  xfm=j(n,lmat3[+,],0);
  flpc=1;
  do flp=1 to nrow(lmat3);
    if (lmat3[flp,1]=1) then;do;xfm[,flpc]=x[,flp];flpc=flpc+1;end;
  end;
  bfm=inv(xfm`*xfm)*xfm`*y;
  residy=y-(xfm*bfm);
  sstotal=(y-(y[+,]/n));
  sstotal=sstotal`*sstotal;
  ssresid=residy`*residy;
  rsqch=&brsq-((sstotal-ssresid)/sstotal);
  fresult=rsqch||fresult;
end;
%mend ftest3;

%macro describ3 (descdatf=,type=0);
desctmp=j(8,ncol(&descdatf),-999);
modvals=-999;
*desctmp=j((8-(4*&type)),ncol(&descdatf),-999);
do jd=1 to ncol(&descdatf);
  descdat=&descdatf[,jd];
  desctmp[1,jd]=descdat[+,]/nrow(descdat);
  desctmp[2,jd]=(nrow(descdat)*descdat`*descdat)-((descdat[+,])`*descdat[+,]);
  desctmp[2,jd]=sqrt(desctmp[2,jd]/(nrow(descdat)*(nrow(descdat)-1)));
  desctmp[3,jd]=min(descdat);
  desctmp[4,jd]=max(descdat);
  if ((desctmp[3,jd]=desctmp[4,jd]) & (novar=0)) then;do;errcode[errs,1]=15;
    errs=errs+1;criterr=1;novar=1;
  end;
  tmp=((descdat[,1]=desctmp[3,jd])+(descdat[,1]=desctmp[4,jd]));
  desctmp[8,jd]=(tmp[+,]=nrow(tmp));
  if (desctmp[8,jd]=1) then;do;modvals=desctmp[3,jd]//desctmp[4,jd];mnotev=0;minwarn=0;maxwarn=0;end;
  if (&type=0) then;do;minwarn=0;maxwarn=0;
    if ((quantile=1) & (desctmp[8,jd] ^= 1)) then;do;
      tmp=descdat;tmp[rank(descdat),]=descdat;descdat=tmp;
      decval={.16,.5,.84};
      do kd=1 to 3;
        low=floor(decval[kd,1]*(nrow(descdat)+1));
	    lowdec=decval[kd,1]*(nrow(descdat)+1)-low;
	    value=descdat[low,1]+(descdat[(low+1),1]-descdat[low,1])*lowdec;
	    desctmp[(4+kd),jd]=value;
      end;
      mnotev=1;modvals=desctmp[5:7,];
	end;
    if ((quantile^=1) & (desctmp[8,jd] ^= 1)) then;do;
      desctmp[5,jd]=desctmp[1,jd]-desctmp[2,jd];
	  desctmp[6,jd]=desctmp[1,jd];
	  desctmp[7,jd]=desctmp[1,jd]+desctmp[2,jd];
	  modvals=desctmp[5:7,];mnotev=2;
	  if (modvals[1,jd] < desctmp[3,jd]) then;do;modvals[1,jd]=desctmp[3,jd];minwarn=1;end;
	  if (modvals[3,jd] > desctmp[4,jd]) then;do;modvals[3,jd]=desctmp[4,jd];maxwarn=1;end;
    end;
  end;
end;
%mend describ3;

%macro makdummy (dd=,method=,custcodv=0);
  dd=&dd;temp=dd;
  temp[rank(dd[,2]),]=dd;dd=temp;
  dummy=design(dd[,2]);nvls=ncol(dummy);nnvls=dummy[+,];mnvls=min(nnvls`);conmat=1;
  if (mnvls < 2) then;do;errcode[errs,1]=5;errs=errs+1;criterr=1;end;
  if (nvls > 9) then;do;errcode[errs,1]=4;errs=errs+1;criterr=1;end;
  if (criterr=0) then;do;
    dumok=1;nnvls=j(nvls,1,0);nnvls[1,1]=dd[1,2];temp=2;
	do i = 2 to n;
	  if (dd[i,2] ^= nnvls[(temp-1),1]) then;do;nnvls[temp,1]=dd[i,2];temp=temp+1;end;
	end;
	if (&method > 0) then;do;
      x=dummy[,2:ncol(dummy)];nx=ncol(x);minus1=j(1,ncol(x),-1);
	  xdes=j((nx+1),3,0);xdes[1,1]=dd[1,2];xdes[1,2]=1;temp=2;
	  do k = 2 to n;
	    if (dd[k,2] ^= dd[(k-1),2]) then;do;
          xdes[temp,2]=k;xdes[temp,1]=dd[k,2];xdes[(temp-1),3]=k-1;temp=temp+1;
		end;
	  end;
	  xdes[(temp-1),3]=n;
	  xdes=xdes||(xdes[,3]-xdes[,2]+1);
	  if (&method = 4) then;do;
	    do k = 1 to n;
		  rstmp=x[k,];rstmp=rstmp[,+];
          if (rstmp=0) then;do;x[k,]=minus1;end;
		end;
	  end;
	  if ((&method = 2) | (&method=3) | (&method=5)) then;do;
	    do k = 1 to n;
          rstmp=x[k,];rstmp=rstmp[,+];
		  if (rstmp > 0) then;do;
		    do i = 1 to ncol(x) while (x[k,i]=0);
		      if (x[k,i]=0) then;do;x[k,i]=1;end;
	        end;
		  end;
		end;
        if (&method=3) then;do;
          conmat1={-8 1 1 1 1 1 1 1 1,
                   0 -7 1 1 1 1 1 1 1,
                   0 0 -6 1 1 1 1 1 1,
                   0 0 0 -5 1 1 1 1 1,
                   0 0 0 0 -4 1 1 1 1,
                   0 0 0 0 0 -3 1 1 1,
                   0 0 0 0 0 0 -2 1 1,
                   0 0 0 0 0 0 0 -1 1};
		  do i = 1 to 8;conmat1[i,]=conmat1[i,]/(10-i);end;
		  conmat1=conmat1[(10-nvls):8,(10-nvls):9]`;
		  do k = 1 to n;
		    rsmcnt=x[k,];rsmcnt=rsmcnt[,+];x[k,]=conmat1[(rsmcnt+1),];
		  end;
        end;
	    if (&method = 5) then;do;
          if (&custcodv=2) then;do;custcode=wcatcode;end;
		  if (&custcodv=3) then;do;custcode=zcatcode;end;
		  if (&custcodv=1) then;do;custcode=xcatcode;end;
		  if (ncol(custcode) ^= (nvls*(nvls-1))) then;do;errcode[errs,1]=(37+&custcodv);errs=errs+1;criterr=1;end;
          if (ncol(custcode) = (nvls*(nvls-1))) then;do;
            conmat1=j(nvls,(nvls-1),0);cnt=1;
			do i = 1 to nvls;do k = 1 to (nvls-1);conmat1[i,k]=custcode[1,cnt];cnt=cnt+1;end;end;
		    do k = 1 to n;rsmcnt=x[k,];rsmcnt=rsmcnt[,+];x[k,]=conmat1[(rsmcnt+1),];end;
		  end;
        end;	
	  end;
      xskip=1;dummat=j((nx+1),nx,0);
	  dummat[(2:nrow(dummat)),]=I(nx);
	  if (&method = 4) then;do;dummat[1,]=minus1;end;
	  if (&method = 2) then;do;
	    do i = 2 to nrow(dummat);
		  do j = 1 to (i-1);
		    dummat[i,j]=1;
		  end;
		end;
	  end;
	  if (&method = 3) then;do;dummat=conmat1;end;
	  if ((&method = 5) & (criterr=0)) then;do;dummat=conmat1;end;
	  dummat=nnvls||dummat;
	  x=dd[,1]||x;
	  temp=x;temp[rank(x[,1]),]=x;x=temp;
    end;
  end;
%mend makdummy;



%macro process (data=,vars=xxxxx,y=xxxxx,m=xxxxx,x=xxxxx,w=xxxxx,z=xxxxx,v=xxxxx,q=xxxxx,cov=xxxxx,total=0,varorder=0,mcw=0,mcz=0,mcx=0,
  normal=0,quantile=999,hc=5,hc3=0,moments=0,vmodval=999,qmodval=999,cluster=xxxxx,conf=95,boot=98765,percent=0,
  seed=0,bmatrix=-999,jn=0,cmatrix=-999,wmatrix=-999,zmatrix=-999,wzmatrix=-999,model=999,ssquares=9,subsets=0,dominate=0,
  iterate=100,converge=.00001,stand=0,bc=0,activate=0,outscreen=1,listmiss=0,coval=-999,exclude=0,settest=0,zpp=0,
  decimals=10.4,matrices=0,covmy=0,center=0,ws=0,contrast=999,effsize=0,mc=0,mdichok=0,save=0,bootfile=bootfile,
  outputf=outputf,maxboot=0,covcoeff=9,wmodval=999,intprobe=0.1,zmodval=999,plot=0,modelbt=0,xcatcode=-999,crossv=0,
  wcatcode=-999,zcatcode=-999,xmtest=0,modelres=0,describe=0,linsum=999,xmint=0,xrefval=999,cdeval=-999,spline=-999,diagnose=0,
  diagfile=diagfile,robustse=0,clusboot=0,eiv=3,relx=-999,relm=-999,relcov=-999);
options pagesize=32767;
proc iml;
reset printadv=1;
reset nocenter;
maxwwarn=0;minwwarn=0;maxzwarn=0;minzwarn=0;toomany=0;wdich=0;zdich=0;wnotev=0;znotev=0;mcerpt=0;
nxpval=1;nwpval=1;nzpval=1;errs=1;notes=1;criterr=0;novar=0;adjust=0;ncs=0;serial=0;sobelok=0;
sv4match=0;
nclsv=0;
hasw=0;hasz=0;printw=0;printz=0;
relx={&relx};relm={&relm};relcov={&relcov};
eiv=floor(&eiv);yrelx=0;yrelm=0;yrelcov=0;relxphm=0;
if (relx[1,1] ^=-999) then;do;yrelx=1;end;
if (relx[1,1]=-999) then;do;relx=1;end;
if (relm[1,1] ^=-999) then;do;yrelm=1;end;
if (relm[1,1]=-999) then;do;relm=1;end;
if (relcov[1,1] ^=-999) then;do;yrelcov=1;end;
if (relcov[1,1]=-999) then;do;relcov=1;end;
eivbad=0;eivdo=0;fulldatr=0;
xmint=0;mcxok=0;mcwok=0;mczok=0;xprod=0;zprod=0;wprod=0;modcok=0;
nws=0;nzs=0;nms=0;nys=0;nxs=0;goodboot=0;wmodcust=0;zmodcust=0;booting=0;bootiter=0;iterrmod=0;ydich=0;
varorder=(&varorder ^= 0);jn=(&jn=1);effsize=(&effsize=1);normal=(&normal=1);stand=(&stand=1);pstog=0;
mdichok=(&mdichok=1);v2tag=0;xmtest=(&xmtest=1);modelres=(&modelres=1);bc=(&bc=1);activate=(&activate=1);
outscreen=(&outscreen=1);describe=(&describe=1);listmiss=(&listmiss=1);alttotal=0;xmint=(&xmint=1);
xrefvals={&xrefval};xcontcf=0;xscaling=1;crossv=(&crossv=1);
robustse=(&robustse=1);clusboot=floor(&clusboot);badboot=0;eiverrc=0;eiverc=0;eivhcnt=0;
nclus=999999999999999;
spl={&spline};nspl=ncol(spl);diagnose=(&diagnose=1);
savlabsc=1;savlabs=j(200,3,"12345678901234567890123456789012");
if (spl[1,1]=-999) then;do;nspl=0;end;
settest=(&settest=1);zpp=(&zpp=1);setxcat=0;subsets=(&subsets=1);dominate=(&dominate=1);
badend=0;priorlo=-9999999;priorhi=9999999;booterr=0;
hc3=floor(&hc3);errcode=j(100,1,0);notecode=j(100,1,0);model=floor(&model);iterate=abs(floor(&iterate));
converge=abs(&converge);itprobtg=0;wnames="xxxxx";znames="xxxxx";wiscov=0;ziscov=0;
w="&w";z="&z";v="&v";q="&q";m="&m";y="&y";x="&x";cov="&cov";cluster="&cluster";oldvars="&vars";
if ((cluster="xxxxx") & ((robustse ^= 0) | (clusboot ^= 0))) then;do;
  errcode[errs,1]=79;errs=errs+1;criterr=1;
end;
if ((eiv < 0) | (eiv > 5) | (eiv=4)) then;do;
  errcode[errs,1]=88;errs=errs+1;criterr=1;
end;
dfilenum={"1","2","3","4","5","6","7","8","9","10","11","12"};
contrast={&contrast};
center=floor(&center);
ncontr=ncol(contrast);ncontrow=nrow(contrast);
intprobe=&intprobe;
if (stand=1) then;do;effsize=1;end;
cdeval={&cdeval};cuscoval=0;
bmatrix={&bmatrix};
if ((x ^= "xxxxx") & (y ^= "xxxxx") & (m ^= "xxxxx") & (z = "xxxxx") & (w = "xxxxx") & (model=999) & (bmatrix[1,1]=-999)) then;do;
  model=4;
end;
if (model=74) then;do;errcode[errs,1]=7;errs=errs+1;criterr=1;end;
if ((xmint=1) & (model ^=4)) then;do;errcode[errs,1]=63;errs=errs+1;criterr=1;end;
if ((xmint=1) & (model=4)) then;do;
  w=x;model=74;intprobe=1;notecode[notes,1]=32;notes=notes+1;
  if ((effsize=1) | (stand=1)) then;do;notecode[notes,1]=34;notes=notes+1;stand=0;effsize=0;end;
  if (center ^= 0) then;do;center=0;errcode[errs,1]=71;errs=errs+1;criterr=1;end;
end;
linsum={&linsum};nlinsum=ncol(linsum);
if (linsum[1,1]=999) then;do;nlinsum=0;end;
deleteme={&exclude};
if (contrast[1,1]=999) then;do;ncontr=1;contrast=0;end;
if (ncontr=1) then;do;contrast=floor(contrast);
  if (contrast > 2 | contrast < 0) then;do;ncontr=1;contrast=0;end;
end;
if (ncontr > 1) then;do;
  contvec=contrast;contrast=3;
  if ((model = 2) | (model = 3)) then;do;
    if (ncontr=4) then;do;
	  wcontval=j(2,1,0);zcontval=j(2,1,0);
      wcontval[1,1]=contvec[1,1];wcontval[2,1]=contvec[1,3];
      zcontval[1,1]=contvec[1,2];zcontval[2,1]=contvec[1,4];
	  contvect=j(2,2,0);
	  contvect[1,1]=contvec[1,1];contvect[1,2]=contvec[1,2];contvect[2,1]=contvec[1,3];contvect[2,2]=contvec[1,4];
	  contvec=contvect;
	  contrast=0;modcok=1;
	end;
    if (ncontr ^= 4) then;do;notecode[notes,1]=19;notes=notes+1;contrast=0;modcok=0;end;
  end;
end;
if (xmint=1) & (contrast[1,1] ^=0 ) then;do;
  contrast=0;notecode[notes,1]=37;notes=notes+1;
end;
if (varorder = 1) then;do;notecode[notes,1]=21;notes=notes+1;end;
if ((&vmodval ^= 999) | (&qmodval ^= 999)) then;do;notecode[notes,1]=22;notes=notes+1;end;
modelbt=(&modelbt=1);matrices=(&matrices=1);covcoeff=(&covcoeff=1);
covmy=floor(&covmy);
if ((covmy < 0) | (covmy > 2)) then;do;covmy=0;end;
boot=abs(floor(&boot));mc=abs(floor(&mc));hc=floor(&hc);
if ((intprobe < 0 ) | (intprobe > 1)) then;do;intprobe=0.10;end;
plot=floor(&plot);
if ((plot < 0) | (plot > 2)) then;do;plot=0;end;
total=(&total=1);dototal=0;
save=(&save=1);saveboot=((&save=1) | (&save=3));saveest=((&save=2) | (&save=3));
savediag=(&save=4);
if (saveest=1) then;do;intprobe=1;end;
if ((hc >= 0) & (hc < 5) & (robustse=0)) then;do;notecode[notes,1]=4;notes=notes+1;end;
if ((hc > 5) | (hc < 0)) then;do;hc=5;end;
mcw=floor(&mcw);mcz=floor(&mcz);mcx=floor(&mcx);
if ((mcx > 0) & (mcx < 3) & (model = 74)) then;do;mcw=mcx;xscaling=1;end;
if ((mcx > 2) & (model=74)) then;do;errcode[errs,1]=65;errs=errs+1;criterr=1;end;
if ((model=74) & (normal=1)) then;do;notecode[notes,1]=33;notes=notes+1;normal=0;end;
if ((mcx > 0) & (contrast > 0)) then;do;notecode[notes,1]=28;notes=notes+1;contrast=0;end;
nxvls=1;nmvls=1;nwvls=1;nzvls=1;paths=999;pathsw=999;pathsz=999;pathswz=999;pathsmod=999;pathtype=999;obscoeff=999;
pathsdv={" "};quantile=1;
if (&quantile ^= 999) then;do;notecode[notes,1]=23;notes=notes+1;end;
moments=(&moments=1);
if (moments=1) then;do;quantile=0;end;
wmatrix={&wmatrix};zmatrix={&zmatrix};wzmatrix={&wzmatrix};cmatrix={&cmatrix};
xcatcode={&xcatcode};wcatcode={&wcatcode};zcatcode={&zcatcode};
needed=0;conf=&conf;
ssquares=&ssquares;
if ((x ^= "xxxxx") & (y ^= "xxxxx") & (w = "xxxxx") & (z = "xxxxx") & (m = "xxxxx") & ((model=999) | (model=0))) then;do;
 model=0;total=0;dototal=0;
 if (ssquares=9) then;do;ssquares=1;end;
end;
intncd=0;
if ((x ^= "xxxxx") & (y ^= "xxxxx") & (w ^= "xxxxx") & (z = "xxxxx") & (m = "xxxxx") & (model=999)) then;do;
  model=1;
end;
ssquares=(ssquares=1);
if ((floor(&conf) >= 100) | (floor(&conf) <= 50)) then;do;conf=95;notecode[notes,1]=2;notes=notes+1;end;
if ((model >= 0) & (model < 4) & (boot = 98765) & (modelbt=1)) then;do;mc=0;boot=5000;end;
if ((model >= 0) & (model < 4) & ((boot = 98765) | (mc > 0))) then;do;boot=0;mc=0;bc=0;end;
if ((boot = 98765) & (mc = 0)) then;do;boot=5000;end;
if ((boot > 0) & (mc > 0)) then;do;boot=0;bc=0;clusboot=0;end;
if ((boot < 1000) & (boot > 0) & (mc = 0)) then;do;boot=5000;end;
if ((mc < 1000) & (mc > 0) & (boot = 0)) then;do;mc=5000;end;
alpha2=(1-(conf/100))/2;cilm=alpha2*2;
*y5=sqrt(-2*log(alpha2));
*xp2=(y5+((((y5*p4+p3)*y5+p2)*y5+p1)*y5+p0)/((((y5*q4+q3)*y5+q2)*y5+q1)*y5+q0));
xp2=-quantile('normal',alpha2);
medlb="     M1:"//"     M2:"//"     M3:"//"     M4:"//"     M5:"//"     M6:"//"     M7:"//"     M8:"//"     M9:"//"    M10:";
medlb2="(M1)"||"(M2)"||"(M3)"||"(M4)"||"(M5)"||"(M6)"||"(M7)"||"(M8)"||"(M9)"||"(M10)";
xlb="   X1:"//"   X2:"//"   X3:"//"   X4:"//"   X5:"//"   X6:"//"   X7:"//"   X8:"//"   X9:"//"  X10:";
highlbw="M1*W"//"M2*W"//"M3*W"//"M4*W"//"M5*W"//"M6*W"//"M7*W"//"M8*W"//"M9*W"//"M10*W";
if (xmint=1) then;do;
 highlbw="M1*X"//"M2*X"//"M3*X"//"M4*X"//"M5*X"//"M6*X"//"M7*X"//"M8*X"//"M9*X"//"M10*X";
end;
highlbz="M1*Z"//"M2*Z"//"M3*Z"//"M4*Z"//"M5*Z"//"M6*Z"//"M7*Z"//"M8*Z"//"M9*Z"//"M10*Z";
highlbwz="M1*W*Z"//"M2*W*Z"//"M3*W*Z"//"M4*W*Z"//"M5*W*Z"//"M6*W*Z"//"M7*W*Z"//"M8*W*Z"//"M9*W*Z"//"M10*W*Z";
highlbbt="BOTH(M1)"//"BOTH(M2)"//"BOTH(M3)"//"BOTH(M4)"//"BOTH(M5)"//"BOTH(M6)"//"BOTH(M7)"//"BOTH(M8)"//"BOTH(M9)"//"BOTH(M10)";
highlbx="M1*X"//"M2*X"//"M3*X"//"M4*X"//"M5*X"//"M6*X"//"M7*X"//"M8*X"//"M9*X"//"M10*X";
skipwz=0;
validm={1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0};
validm=validm||{1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1};
if (activate=1) then;do;errcode[errs,1]=60;errs=errs+1;criterr=1;end;
if (criterr=0) then;do;
  if ((&ws=1)=1) then;do;errcode[errs,1]=42;errs=errs+1;criterr=1;end;
  if ((model > 0) & (model < 93)) then;do;
    if (validm[1,model]=0) then;do;
      errcode[errs,1]=6;errs=errs+1;criterr=1;
    end;
  end;
  if (((model > 92) | (model < 0)) & (model ^= 999)) then;do;errcode[errs,1]=7;errs=errs+1;criterr=1;end;
  if ((model=999) & (bmatrix[1,1]=-999)) then;do;errcode[errs,1]=24;errs=errs+1;criterr=1;end;
  if ((model ^= 999) & (bmatrix[1,1] ^= -999)) then;do;errcode[errs,1]=25;errs=errs+1;criterr=1;end;
  if (((model = 74) | ((model > 0) & (model < 4))) & ((wmatrix[1,1]^=-999) | (zmatrix[1,1]^=-999) | (wzmatrix[1,1]^=-999))) then;do;
    errcode[errs,1]=41;errs=errs+1;criterr=1;
  end;
  if (hc3 ^= 0) then;do;notecode[notes,1]=5;notes=notes+1;
    if (hc3=1) then;do;hc=3;end;
  end;
  if (oldvars ^= "xxxxx") then;do;errcode[errs,1]=48;errs=errs+1;criterr=1;end;
  if ((v ^= "xxxxx") | (q ^= "xxxxx")) then;do;errcode[errs,1]=14;errs=errs+1;errcode[errs,1]=48;errs=errs+1;criterr=1;end;
  if (cluster ^= "xxxxx") then;do;
    *errcode[errs,1]=27;*errs=errs+1;*criterr=1;
  end;
  if ((x = "xxxxx") | (y = "xxxxx")) then;do;errcode[errs,1]=1;errs=errs+1;criterr=1;end;
  if ((m = "xxxxx") & (model > 3) & (model ^= 999)) then;do;errcode[errs,1]=8;errs=errs+1;criterr=1;end;
end;
if (criterr=0) then;do; *start a;
  use &data;
  read all var _num_ into bummy[colname=bummynm];
  *print bummynm;
  read all var{&y} into ytmp;ynames={&y};nys=ncol(ytmp);needed=nys;
  do i = 1 to nrow(ytmp);if ytmp[i,1]=. then;do;ytmp[i,1]=99999;end;end;
  n=nrow(ytmp);varnames=ynames;dat=ytmp;
  modelvar="&model"//(ynames`);
  if (&model=999) then;do;
    modelvar[1,1]="CUSTOM";
	if (model=0) then;do;
      modelvar[1,1]="0";
	end;
	if (model=1) then;do;
	  modelvar[1,1]="1";
	end;
    if ((model=4) | (model=74)) then;do;
	  modelvar[1,1]="4";
	end;
  end;
  use &data;
  read all var{&x} into xtmp;xnames={&x};nxs=ncol(xtmp);
  do i = 1 to nrow(xtmp);if xtmp[i,1]=. then;do;xtmp[i,1]=99999;end;end;
  if ((ncol(relx) ^= nxs) & (yrelx=1) & (eivbad=0)) then;do;
    errcode[errs,1]=83;errs=errs+1;criterr=1;eivbad=1;
  end;
  if ((yrelx=1) & (eivbad=0)) then;do;eivdo=1;end;
  n=nrow(xtmp);
  nxset=nxs;xtraxs=0;xnames2=xnames;xfakecov=0;
  xmodelbs="      X:";
  if ((nxs > 1) & (model=0)) then;do;
    xotmp=xtmp[,2:ncol(xtmp)];
    xfakecov=ncol(xotmp);
    ncs=xfakecov;
    xonames=xnames[1,2:ncol(xnames)];
    covnames=xonames;xnames=xnames[1,1];
	if (yrelx=0) then;do;relx=j(1,nxs,1);end;
    if (eivbad=0) then;do;
      relxph=relx[1,2:ncol(relx)];relxphm=1;relx=relx[1,1];
    end;
    nxs=1;
	xtralbs=j((ncol(xtmp)-1),1,"        ");
    xtmp=xtmp[,1];xtraxs=1;
	xmodelbs=xmodelbs//xtralbs;
  end;
  eivrel=relx;
  needed=needed+nxs;
  varnames=varnames||xnames;xcatlab=xnames`;dat=dat||xtmp;
  modelvar=modelvar//(xnames2`);
  modelvlb="  Model:"//"      Y:"//xmodelbs;
  if (m ^= "xxxxx") then;do;
    read all var{&m} into mtmp;mnames={&m};nms=ncol(mtmp);
   if ((ncol(relm) ^= nms) & (yrelm=1) & (eivbad=0)) then;do;
     errcode[errs,1]=83;errs=errs+1;criterr=1;eivbad=1;
   end;
   if (yrelm=0) then;do;relm=j(1,nms,1);end;
   if ((yrelm=1) & (eivbad=0)) then;do;eivdo=1;end;
   eivrel=eivrel||relm;
    needed=needed+nms;n=nrow(mtmp);
	mprod=j(1,nms,0);modelvar=modelvar//(mnames`);varnames=varnames||mnames;
	x2m=j(99,nms,0);m2y=j(99,nms,0);onem=j(nms,1,1);
    do i = 1 to nrow(mtmp);do j=1 to ncol(mtmp);if mtmp[i,j]=. then;do;mtmp[i,j]=99999;end;end;end;
	dat=dat||mtmp;
	if ((nms > 1) & (nms < 11)) then;do;modelvlb=modelvlb//medlb[1:nms,1];end;
	if (nms=1) then;do;modelvlb=modelvlb//"      M:";end;
	if ((nms > 0) & (model < 4)) then;do;
       errcode[errs,1]=9;errs=errs+1;
	   if (model ^= 0) then;do;
         errcode[errs,1]=48;errs=errs+1;
	   end;
       criterr=1;
    end;
  end;
  wlocatet=0;wlocate=0;
  if (w ^= "xxxxx") then;do;
    if (xmint=0) then;do;
      read all var{&w} into wtmp;wnames={&w};
	end;
	if (xmint=1) then;do;
      read all var{&x} into wtmp;wnames={&x};
	end;
	nws=ncol(wtmp);n=nrow(wtmp);
	varnames=varnames||wnames;wlocate=ncol(varnames);
	if (model=74) then;do;wlocatet=1;
	  if (xnames ^= wnames) then;do;errcode[errs,1]=45;errs=errs+1;criterr=1;end;
	end;
    do i = 1 to nrow(wtmp);if wtmp[i,1]=. then;do;wtmp[i,1]=99999;end;end;
	wcatlab=wnames`;dat=dat||wtmp;
	if (xmint ^= 1) then;do;
      modelvar=modelvar//wnames`;
	  modelvlb=modelvlb//"      W:";
	end;
  end;
  if (z ^= "xxxxx") then;do;
    read all var{&z} into ztmp;znames={&z};nzs=ncol(ztmp);n=nrow(ztmp);
	varnames=varnames||znames;
    do i = 1 to nrow(ztmp);if ztmp[i,1]=. then;do;ztmp[i,1]=99999;end;end;
	zcatlab=znames`;dat=dat||ztmp;modelvar=modelvar//znames`;
	modelvlb=modelvlb//"      Z:";
  end;
  if ((xtraxs=1) & (cov = "xxxxx")) then;do;
    dat=dat||xotmp;ctmp=xotmp;
	if (eivbad=0) then;do;relcov=relxph;eivrel=eivrel||relcov;end;
    varnames=varnames||xonames;
  end; 
  if (cov ^= "xxxxx") then;do;
    read all var{&cov} into ctmp;covnames={&cov};ncs=ncol(ctmp)+xfakecov;
    if ((ncol(relcov) ^= ncol(ctmp)) & (yrelcov=1) & (eivbad=0)) then;do;
      errcode[errs,1]=83;errs=errs+1;criterr=1;eivbad=1;
    end;
    if (yrelcov=0) then;do;
      relcov=j(1,ncs,1);
	  if (relxphm=1) then;do;relcov[1,1:ncol(relxph)]=relxph;end;
	  eivrel=eivrel||relcov;
	end;
	if ((yrelcov=1) & (eivbad=0)) then;do;
      if (relxphm=1) then;do;relcov=relxph||relcov;end;
      eivrel=eivrel||relcov;
	  eivdo=1;
	end;
    n=nrow(ctmp);
    if ((ncol(ctmp) > 0) & (model=0)) then;do;settest=1;end;
	if (xtraxs=1) then;do;
      ctmp=xotmp||ctmp;
	  covnames=xonames||covnames;
	end;
	varnames=varnames||covnames;
    do i = 1 to nrow(ctmp);do j = 1 to ncol(ctmp);if ctmp[i,j]=. then;do;ctmp[i,j]=99999;end;end;end;
	dat=dat||ctmp;
  end;

  clusok=0;
  if (cluster ^= "xxxxx") then;do;
    read all var{&cluster} into clusdat;clunames={&cluster};
	do i = 1 to nrow(clusdat);if clusdat[i,1]=. then;do;clusdat[i,1]=99999;end;end;
	dat=dat||clusdat;
    nclsv=ncol(clusdat);
	if (nclsv=1) then;do;
	  modelvar=modelvar//clunames;
	  modelvlb=modelvlb//"Cluster:";
	  clusok=1;
	  if (robustse=1) then;do;
	    hc=6;
		notecode[notes,1]=4;
        notes=notes+1;
	  end;
	  if ((robustse=0) & (clusboot=0)) then;do;
        errcode[errs,1]=78;errs=errs+1;criterr=1;
      end;
	end;
  end;



  if ((nws > 1) | (nzs > 1) | (nys > 1) | (nclsv > 1) | ((nxs > 1) & (xtraxs=0))) then;do;
    errcode[errs,1]=3;errs=errs+1;criterr=1;
  end;
  if (((model = 80) | (model = 81)) & ((nms < 3) | (nms > 6))) then;do;
    errcode[errs,1]=32;errs=errs+1;criterr=1;    
  end;
  if ((model = 82) & (nms ^= 4)) then;do;errcode[errs,1]=33;errs=errs+1;criterr=1;end;
  if (nms > 10) then;do;errcode[errs,1]=37;errs=errs+1;criterr=1;end;
  if (((model = 6) | ((model > 82) & (model < 999))) & ((nms < 2) | (nms > 6))) then;do;
    errcode[errs,1]=34;errs=errs+1;criterr=1;    
  end;
  match=0;match2=0;mcwzcov=0;
  do i = 1 to (ncol(varnames)-1);do j = (i+1) to ncol(varnames);
    if (varnames[1,i]=varnames[1,j]) then;do;
      * match=1;
      if (i < (nxs+nms+nys+1)) then;do;
        match2=match2+1;end;
      if (model=0) then;do;match2=match2+1;end;
	  if ((wlocatet=1) & (i=2) & (j = wlocate)) then;do;match2=match2-1;end;
	  if ((wnames=znames) & ((nws > 0) | (nzs > 0))) then;do;match2=match2+1;end;
      if ((i < (ncol(varnames)-ncs+1)) & (j > (ncol(varnames)-ncs))) then;do;
	    if ((varnames[1,j]=wnames) & (mcw=0)) then;do;match=0;wiscov=(j-(ncol(varnames)-ncs));end;
        if ((varnames[1,j]=wnames) & (mcw ^=0)) then;do;mcwzcov=1;end;
	    if ((varnames[1,j]=znames) & (mcz=0)) then;do;match=0;ziscov=(j-(ncol(varnames)-ncs));end;
        if ((varnames[1,j]=znames) & (mcz ^=0)) then;do;mcwzcov=1;end;
	  end;
	end;
  end;end;
  if ((match=1) | (match2=1)) then;do;errcode[errs,1]=2;errs=errs+1;criterr=1;end;
  if  (mcwzcov=1) then;do;errcode[errs,1]=50;errs=errs+1;criterr=1;end;
  ninit=nrow(dat);rownum=j(ninit,1,0);rownumd=j(ninit,1,0);
  do i = 1 to ninit;
    rownum[i,1]=i;
	do k = 1 to ncol(deleteme);
	  if (deleteme[1,k]=i) then;do;rownumd[i,1]=1;end;
	end;
  end;
  dat=rownum||dat;
  j=1;missrow=0;delrow=0;nmiss=0;delident=0;
  do i = 1 to ninit;
    delskip=0;
	if ((rownumd[i,1]=1) & (delskip=0)) then;do;
	  delskip=1;delident=1;
	end;
    tmprow=dat[i,2:ncol(dat)];tmprow=(tmprow=99999);tmprow=tmprow[,+];
	if ((tmprow > 0) & (delskip=0)) then;do;
      missrow=missrow//dat[i,1];
	  nmiss=nmiss+1;
	  delskip=1;
	end;
	if (delskip = 0) then;do;dat[j,]=dat[i,];j=j+1;end;
  end;
  if (j < 5) then;do;  
    errcode[errs,1]=62;errs=errs+1;criterr=1;
  end;
  if (delident=1) then;do;
    notecode[notes,1]=38;notes=notes+1;
  end;
  *new here;
  jjjj=j;
  *end new here;
  *startit;

  bcmat=j(needed,needed,0);wcmat=j(needed,needed,0);
  zcmat=j(needed,needed,0);wzcmat=j(needed,needed,0);
  wsum=0;zsum=0;wzsum=0;

  *define model matrices for canned models;
  if (criterr=0) & (model ^= 999) then;do;
  * X->MW, X->MZ, X->MWZ, M->YW, M->YZ, M->YWZ, X->YW, X->YZ, X->YWZ;
    modelmat=
    {1 0 0 0 0 0 0 1 0 0,2 0 0 0 0 0 0 1 1 0,3 0 0 0 0 0 0 1 1 1,4 0 0 0 0 0 0 0 0 0,
    5 0 0 0 0 0 0 1 0 0,6 0 0 0 0 0 0 0 0 0,7 1 0 0 0 0 0 0 0 0,8 1 0 0 0 0 0 1 0 0,
    9 1 1 0 0 0 0 0 0 0,10 1 1 0 0 0 0 1 1 0,11 1 1 1 0 0 0 0 0 0,12 1 1 1 0 0 0 1 1 1,
    13 1 1 1 0 0 0 1 0 0,14 0 0 0 1 0 0 0 0 0,15 0 0 0 1 0 0 1 0 0,16 0 0 0 1 1 0 0 0 0,
    17 0 0 0 1 1 0 1 1 0,18 0 0 0 1 1 1 0 0 0,19 0 0 0 1 1 1 1 1 1,20 0 0 0 1 1 1 1 0 0,
    21 1 0 0 0 1 0 0 0 0,22 1 0 0 0 1 0 1 0 0,23 0 0 0 0 0 0 0 0 0,24 0 0 0 0 0 0 0 0 0,
    25 0 0 0 0 0 0 0 0 0,26 0 0 0 0 0 0 0 0 0,27 0 0 0 0 0 0 0 0 0,28 1 0 0 0 1 0 0 1 0,
    29 1 0 0 0 1 0 1 1 0,30 0 0 0 0 0 0 0 0 0,31 0 0 0 0 0 0 0 0 0,32 0 0 0 0 0 0 0 0 0,
    33 0 0 0 0 0 0 0 0 0,34 0 0 0 0 0 0 0 0 0,35 0 0 0 0 0 0 0 0 0,36 0 0 0 0 0 0 0 0 0,
    37 0 0 0 0 0 0 0 0 0,38 0 0 0 0 0 0 0 0 0,39 0 0 0 0 0 0 0 0 0,40 0 0 0 0 0 0 0 0 0,
    41 0 0 0 0 0 0 0 0 0,42 0 0 0 0 0 0 0 0 0,43 0 0 0 0 0 0 0 0 0,44 0 0 0 0 0 0 0 0 0,
    45 0 0 0 0 0 0 0 0 0,46 0 0 0 0 0 0 0 0 0,47 0 0 0 0 0 0 0 0 0,48 0 0 0 0 0 0 0 0 0,
    49 0 0 0 0 0 0 0 0 0,50 0 0 0 0 0 0 0 0 0,51 0 0 0 0 0 0 0 0 0,52 0 0 0 0 0 0 0 0 0,
    53 0 0 0 0 0 0 0 0 0,54 0 0 0 0 0 0 0 0 0,55 0 0 0 0 0 0 0 0 0,56 0 0 0 0 0 0 0 0 0,
    57 0 0 0 0 0 0 0 0 0,58 1 0 0 1 0 0 0 0 0,59 1 0 0 1 0 0 1 0 0,60 1 1 0 1 0 0 0 0 0,
    61 1 1 0 1 0 0 1 0 0,62 1 1 0 1 0 0 0 1 0,63 1 1 0 1 0 0 1 1 0,64 1 0 0 1 1 0 0 0 0,
    65 1 0 0 1 1 0 1 0 0,66 1 0 0 1 1 0 0 1 0,67 1 0 0 1 1 0 1 1 0,68 1 1 1 1 0 0 0 0 0,
    69 1 1 1 1 0 0 1 1 1,70 1 0 0 1 1 1 0 0 0,71 1 0 0 1 1 1 1 1 1,72 1 1 1 1 1 1 0 0 0,
    73 1 1 1 1 1 1 1 1 1,74 0 0 0 1 0 0 0 0 0,75 1 1 0 1 1 0 0 0 0,76 1 1 0 1 1 0 1 1 0,
    77 0 0 0 0 0 0 0 0 0,78 0 0 0 0 0 0 0 0 0,79 0 0 0 0 0 0 0 0 0,80 0 0 0 0 0 0 0 0 0,
    81 0 0 0 0 0 0 0 0 0,82 0 0 0 0 0 0 0 0 0,83 1 0 0 0 0 0 0 0 0,84 1 0 0 0 0 0 0 0 0,
    85 1 0 0 0 0 0 1 0 0,86 1 0 0 0 0 0 1 0 0,87 0 0 0 1 0 0 0 0 0,88 0 0 0 1 0 0 0 0 0,
    89 0 0 0 1 0 0 1 0 0,90 0 0 0 1 0 0 1 0 0,91 0 0 0 0 0 0 0 0 0,92 1 0 0 1 0 0 1 0 0};
	if (model > 0) then;do;tmp=modelmat[model,2:ncol(modelmat)];end;
	if (model = 0) then;do;tmp=j(1,9,0);end;
    if (model < 4) then;do;bcmat[(nxs+1),1]=1;end;
    if ((model > 3) & (model ^= 6)) then;do;
      bcmat[(nxs+1):(nxs+nms),1]=onem;
      bcmat[nrow(bcmat),(nxs+1):(nxs+nms)]=onem`;
      bcmat[nrow(bcmat),1]=1;
    end;
    if ((model = 6) | ((model > 82) & (model < 93))) then;do;
      do j = 2 to nrow(bcmat);do i = 1 to (j-1);bcmat[j,i]=1;end;end;
    end;
    if (model = 80) then;do;do i = 1 to nms;bcmat[(nrow(bcmat)-1),i]=1;end;end;
    if (model = 81) then;do;do j = 3 to nrow(bcmat);bcmat[j,2]=1;end;end;
    if (model = 82) then;do;bcmat[3,2]=1;bcmat[5,4]=1;end;
    if (tmp[1,1]=1) then;do;
      wcmat[(nxs+1):(nxs+nms),1]=onem;wprod=1;xprod=1;
      if ((model = 83) | (model = 86)) then;do;
        onemsx=onem;
        do i = 1 to (nms-1);onemsx[(i+1),1]=0;end;
        wcmat[(nxs+1):(nxs+nms),1]=onemsx;
      end;
    end;
    if (tmp[1,4]=1) then;do;
      wcmat[nrow(wcmat),(nxs+1):(nxs+nms)]=onem`;wprod=1;
      if ((model = 87) | (model = 90)) then;do;
        onemsx=onem;
        do i = 1 to (nms-1);onemsx[i,1]=0;end;
        wcmat[nrow(wcmat),(nxs+1):(nxs+nms)]=onemsx`;
      end;
    end;
    if (tmp[1,7]=1) then;do;wcmat[nrow(wcmat),1]=1;wprod=1;xprod=1;end;
    if (tmp[1,2]=1) then;do;zcmat[(nxs+1):(nxs+nms),1]=onem;zprod=1;xprod=1;end;
    if (tmp[1,5]=1) then;do;zcmat[nrow(zcmat),(nxs+1):(nxs+nms)]=onem`;zprod=1;end;
    if (tmp[1,8]=1) then;do;zcmat[nrow(zcmat),1]=1;zprod=1;xprod=1;end;
    if (tmp[1,3]=1) then;do;wzcmat[(nxs+1):(nxs+nms),1]=onem;xprod=1;wprod=1;zprod=1;end;
    if (tmp[1,6]=1) then;do;wzcmat[nrow(wzcmat),(nxs+1):(nxs+nms)]=onem`;zprod=1;wprod=1;end;
    if (tmp[1,9]=1) then;do;wzcmat[nrow(wzcmat),1]=1;xprod=1;wprod=1;zprod=1;end;
    if ((model = 91) | (model = 92)) then;do;
      do j = 1 to (nms-1);do i = 1 to j;wcmat[(nxs+1+j),(nxs+i)]=1;end;end;
    end;
    if (nms < 0) then;do;
      do i = 1 to nms;
	    wcmatctp=wcmat[,(1+i)];wcmatctp=wcmatctp[+,];
        zcmatctp=zcmat[,(1+i)];zcmatctp=zcmatctp[+,];
        wzcmatct=zcmat[,(1+i)];wzcmatct=wzcmatct[+,];
        tmp=wcmatctp+zcmatctp+wzcmatct;
        mprod[1,i]=(tmp > 0);
      end;
    end;  
  end;

  * DEFINE MATRICES FOR CUSTOM MODELS AND DO SOME ERROR CHECKING;
  if (criterr=0) then;do; 
    needed=needed*(needed-1)/2;nopath=0;
    if (bmatrix[1,1] ^= -999) then;do;tmp=1;
	  rsumccm=bmatrix[,+];
      if ((ncol(bmatrix) ^= needed) | (rsumccm[+,]=0)) then;do;
        errcode[errs,1]=16;errs=errs+1;criterr=1;
      end;
      if ((ncol(bmatrix) = needed) & (rsumccm[+,]^=0)) then;do;
        do i = 2 to nrow(bcmat);do j = 1 to (i-1);bcmat[i,j]=1-(bmatrix[1,tmp] = 0);tmp=tmp+1;end;end;
      end;
      * check to make sure X affects something;
	  rsumccm=bcmat[,1];
      if ((rsumccm[+,]=0) & (criterr=0)) then;do;errcode[errs,1]=22;errs=errs+1;criterr=1;end;
      * check to make sure Y is affected by something;
	  rsumccm=bcmat[nrow(bcmat),];
      if ((rsumccm[,+]=0) & (criterr=0)) then;do;errcode[errs,1]=23;errs=errs+1;criterr=1;end;
      * check for dangling mediators;
      dm=0;
      if (nms > 0) then;do;
        do i = 1 to nms;
		  rsumccm=bcmat[(nxs+i),];csumccm=bcmat[,(nxs+i)];
          if (((rsumccm[,+] = 0) | (csumccm[+,] = 0)) & (dm=0) & (criterr=0)) then;do;
            errcode[errs,1]=26;errs=errs+1;criterr=1;dm=1;
          end;
        end;
      end;
    end;
  end;

  if (criterr=0) then;do; 
    if (wmatrix[1,1] ^= -999) then;do;tmp=1;
      if (ncol(wmatrix) ^= needed) then;do;errcode[errs,1]=17;errs=errs+1;criterr=1;end;
      if (ncol(wmatrix) = needed) then;do;
        modelvar[1,1]="CUSTOM";
        do i = 2 to nrow(wcmat);
          do j = 1 to (i-1);
            wcmat[i,j]=1-(wmatrix[1,tmp] = 0);
            * dont allow to specify moderation of a path that doesnt exist;
            if ((wcmat[i,j]=1) & (bcmat[i,j]=0) & (nopath=0)) then;do;
              errcode[errs,1]=20;errs=errs+1;criterr=1;nopath=1;
            end;
            tmp=tmp+1;
          end;
        end;
      end;
    end;
    if (zmatrix[1,1] ^= -999) then;do;tmp=1;
      if (ncol(zmatrix) ^= needed) then;do;errcode[errs,1]=18;errs=errs+1;criterr=1;end;
      if (ncol(zmatrix) = needed) then;do;
        modelvar[1,1]="CUSTOM";
        * dont allow for a ZMODEL without W being used somewhere in the model;
		csumwcm=wcmat[,+];
        if ((csumwcm[+,]=0) & (model=999)) then;do;
          errcode[errs,1]=21;errs=errs+1;criterr=1;          
        end;
        do i = 2 to nrow(zcmat);
          do j = 1 to (i-1);
            zcmat[i,j]=1-(zmatrix[1,tmp] = 0);
            * dont allow to specify moderation of a path that doesnt exist;
            if ((zcmat[i,j]=1) & (bcmat[i,j]=0) & (nopath=0)) then;do;
              errcode[errs,1]=20;errs=errs+1;criterr=1;nopath=1;
            end;
            tmp=tmp+1;
          end;
        end;
      end;
    end;
    tmp=1;
    if (wzmatrix[1,1] ^= -999) then;do;
      if (ncol(wzmatrix) ^= needed) then;do;errcode[errs,1]=19;errs=errs+1;criterr=1;end;
      modelvar[1,1]="CUSTOM";
    end;
    if (criterr=0) then;do;
      do i = 2 to nrow(wzcmat);
        do j = 1 to (i-1);
          * set corresponding elements in W and Z for three way interaction;
          if (wzmatrix[1,1] ^= -999) then;do;wzcmat[i,j]=1-(wzmatrix[1,tmp] = 0);end;
          if (wzcmat[i,j]=1) then;do;wcmat[i,j]=1;zcmat[i,j]=1;end;
          * dont allow to specify moderation of a path that doesnt exist;
          if ((wzcmat[i,j]=1) & (bcmat[i,j]=0) & (nopath=0)) then;do;
            errcode[errs,1]=20;errs=errs+1;criterr=1;nopath=1;
          end;
          tmp=tmp+1;
        end;
      end;
    end;
  end;

  if (criterr=0) then;do;
    tmwcmat=wcmat[,1];tmzcmat=zcmat[,1];tmwzcmat=wzcmat[,1];
    xprod=tmwcmat[+,]+tmzcmat[+,]+tmwzcmat[+,];
    xprod=(xprod > 0);wsum=wcmat[+,+];wprod=(wsum > 0);
	zsum=zcmat[+,+];zprod=(zsum > 0);
    if (nms > 0) then;do;
      do i = 1 to nms;
	    tmwcmat=wcmat[,(1+i)];tmzcmat=zcmat[,(1+i)];tmwzcmat=wzcmat[,(1+i)];
        tmp=tmwcmat[+,]+tmzcmat[+,]+tmwzcmat[+,];
        mprod[1,i]=(tmp > 0);
      end;
    end;
    if ((wsum > 0) & (w = "xxxxx")) then;do;errcode[errs,1]=11;errs=errs+1;criterr=1;end;
    if ((wsum = 0) & (w ^= "xxxxx")) then;do;errcode[errs,1]=10;errs=errs+1;criterr=1;end;
    if ((zsum > 0) & (z = "xxxxx")) then;do;errcode[errs,1]=13;errs=errs+1;criterr=1;end;
    if ((zsum = 0) & (z ^= "xxxxx")) then;do;errcode[errs,1]=12;errs=errs+1;criterr=1;end;
    if ((zsum > 0) & (wsum = 0)) then;do;errcode[errs,1]=35;errs=errs+1;criterr=1;end;
  end;

  if (criterr=0) then;do;
    *new here;
    j=jjjj;
	*end new here;
    rownum=dat[1:(j-1),1];
    if (nrow(missrow) > 1) then;do;
      notecode[notes,1]=29;notes=notes+1;
      missrow=(missrow[2:nrow(missrow),1])`;
    end;
	dat=dat[1:(j-1),2:ncol(dat)];
    n=nrow(dat);
    if (clusok=1) then;do;
      clusdat=dat[,ncol(dat)];
      clusdat=rownum||clusdat||clusdat;
      temp=clusdat;
      temp[rank(clusdat[,2]),]=clusdat;
      clusdat=temp;
      do i = 1 to nrow(clusdat);clusdat[i,3]=i;end;
      current=clusdat[1,2]||1||1||1;
      currentc=1;
      do i = 2 to nrow(clusdat);
        if (clusdat[i,2]=current[currentc,1]) then;do;
          current[currentc,2]=current[currentc,2]+1;
          current[currentc,4]=i;
		end;
        if (clusdat[i,2] ^= current[currentc,1]) then;do;
		  current2=clusdat[i,2]||1||i||i;
          current=current//current2;
          currentc=currentc+1;
        end;        
      end;
      nclus=nrow(current);
      clusinfo=nrow(current)//((current[+,2])/nclus)//(current[><,2])//(current[<>,2]);	   
      temp[rank(clusdat[,1]),]=clusdat;
      clusdat=temp;
      free temp;
	  dat=dat[,1:(ncol(dat)-clusok)];
    end;
  ytmp=dat[,1:nys];
  %describ3 (descdatf=ytmp,type=1);
  ysd=desctmp[2,];
  ovsd=ysd;
  ydich=0;
  if (desctmp[8,1]=1) then;do;
    ydich=1;
	if (robustse=1) then;do;
      robustse=0;errcode[errs,1]=81;errs=errs+1;criterr=1;
	end;
	if ((ydich=1) & (eivdo=1)) then;do;
      eivdo=0;errcode[errs,1]=86;errs=errs+1;criterr=1;
	end;
	if (total=1) then;do;total=0;notecode[notes,1]=24;notes=notes+1;end;
	if (effsize=1) then;do;effsize=0;notecode[notes,1]=25;notes=notes+1;end;
	if (model=74) then;do;errcode[errs,1]=72;errs=errs+1;criterr=1;end;
    omx = max(ytmp[,1]);
    omn = min(ytmp[,1]);
    ytmp[,1]=(ytmp[,1]=omx);
    dat[,1:nys]=(dat[,1:nys]=omx);
    rcd = (omn||0)//(omx||1);
  end;
  xtmp=dat[,(nys+1):(nys+nxs)];
  %describ3 (descdatf=xtmp,type=(1-xprod));
  xsd=desctmp[2,];xmodvals=modvals;
  xdich=desctmp[8,1];
  xmx=max(xtmp[,1]);
  xmn=min(xtmp[,1]);
  if ((mcx > 0) & (xrefvals[1,1] ^= 999) & (xmint=1) & (model= 74)) then;do;
    notecode[notes,1] = 36;notes=notes+1;
  end;
  if (mcx=0) then;do;
    if ((ncol(xrefvals)>2) & (model=74) & (xmint=1)) then;do;
      errcode[errs,1]=67;errs=errs+1;criterr=1;
    end;
    if ((model=74) & (xmint=1)) then;do;
      if ((xrefvals[1,1]=999) & (nxvls=1) & (xdich=0)) then;do;
        errcode[errs,1]=66;errs=errs+1;criterr=1;
      end;
      if ((xrefvals[1,1]=999) & (xdich=1)) then;do;
        xrefvals=xmn||xmx;
        xscaling=xrefvals[1,2]-xrefvals[1,1];
      end;
      if ((ncol(xrefvals)=1) & (xrefvals[1,1] ^= 999)) then;do;
        if (xdich=0) then;do;
          xrefvals=xrefvals||(xrefvals[1,1]+1);
          xscaling=xrefvals[1,2]-xrefvals[1,1];
        end;
        if (xdich=1) then;do;
          if ((xrefvals[1,1] ^= xmx)  & (xrefvals[1,1] ^= xmn)) then;do;
            errcode[errs,1]=70;errs=errs+1;criterr=1;
          end;
          if (xrefvals[1,1] = xmx) then;do;
             xrefvals=xrefvals||xmn;
             xscaling=xrefvals[1,2]-xrefvals[1,1];
          end;
          if (xrefvals[1,1] = xmn) then;do;
             xrefvals=xrefvals||xmx;
             xscaling=xrefvals[1,2]-xrefvals[1,1];
          end;
        end;
      end;
      if (ncol(xrefvals)=2) then;do;
        xscaling=xrefvals[1,2]-xrefvals[1,1];
        if (xdich=1) then;do;
           xreferr=1;
           if (((xrefvals[1,1] = xmx) & (xrefvals[1,2]=xmn)) | ((xrefvals[1,1] = xmn) & (xrefvals[1,2]=xmx))) then;do;
             xreferr=0;
           end;
           if (xreferr=1) then;do;
             errcode[errs,1]=70;errs=errs+1;criterr=1;
           end;         
        end;
      end;
    end;
  end;

  if ((xmint=1) & (model=74) & (mcx=0)) then;do;
    xmodvals=xrefvals`;xcontcf=1;
  end;
  nxpval=nrow(xmodvals);xprobval=xmodvals;
  if ((xdich=1) & (mcx > 0)) then;do;
    mcx=0;errcode[errs,1]=52;errs=errs+1;criterr=1;
  end;
  *if ((model=74) & (xdich=1)) then;*do;*xmint=1;*end;
  if (nms > 0) then;do;
    mtmp=dat[,(nys+nxs+1):(nys+nxs+nms)];
	%describ3 (descdatf=mtmp);
	ovsd=desctmp[2,]||ysd;
	medmeans=cdeval;
	if ((cdeval[1,1] ^= -999) & (ncol(medmeans) ^= nms) & (model=74)) then;do;
	  errcode[errs,1]=64;errs=errs+1;criterr=1;
	end;
	if ((cdeval[1,1]=-999) & (model=74)) then;do;medmeans=desctmp[1,];end;
	if ((cdeval[1,1] ^= -999) & (criterr=0) & (model=74)) then;do;
	  notecode[notes,1]=31;notes=notes+1;
	end;
    dichchk=desctmp[8,];dichchk=dichchk[,+];
	if ((dichchk > 0) & (mdichok ^= 1)) then;do;errcode[errs,1]=43;errs=errs+1;criterr=1;end;
  end;
  mmodvals=modvals;
  mprobval=mmodvals;
  if (nws > 0) then;do;
    wtmp=dat[,(nys+nxs+nms+1):(nys+nxs+nms+nws)];
	%describ3 (descdatf=wtmp,type=(1-wprod));
	wmodvals=modvals;wdich=desctmp[8,1];wmin=desctmp[3,1];wmax=desctmp[4,1];
     if ((wdich=1) & (mcw > 0)) then;do;
       mcw=0;errcode[errs,1]=52;errs=errs+1;criterr=1;
     end;
	minwwarn=minwarn;maxwwarn=maxwarn;wnotev=mnotev;
	wmodval={&wmodval};
    if ((xmint=1) & (model=74) & (mcx=0)) then;do;wmodval=xrefvals;end;
    nwcontr=ncol(wmodval);
	if (wmodval[1,1] ^= 999) then;do;
      wmodvals=wmodval[1,1];wmodcust=1;
	  if (nwcontr > 1) then;do;wmodvals=wmodval`;end;
	  minwwarn=0;maxwwarn=0;wnotev=0;
	end;
	wprobval=wmodvals;
	nwpval=nrow(wmodvals);
  end;
  if (nzs > 0) then;do;
    ztmp=dat[,(nys+nxs+nms+nws+1):(nys+nxs+nms+nws+nzs)];
	%describ3 (descdatf=ztmp,type=(1-zprod));
	zmodvals=modvals;zdich=desctmp[8,1];
     if ((zdich=1) & (mcz > 0)) then;do;
       mcz=0;errcode[errs,1]=52;errs=errs+1;criterr=1;
     end;

    zmin=desctmp[3,1];zmax=desctmp[4,1];
	minzwarn=minwarn;maxzwarn=maxwarn;znotev=mnotev;
	zmodval={&zmodval};nzcontr=ncol(zmodval);
	if (zmodval[1,1] ^= 999) then;do;
      zmodvals=zmodval[1,1];zmodcust=1;
	  if (nzcontr > 1) then;do;zmodvals=zmodval`;end;
	  minzwarn=0;maxzwarn=0;znotev=0;
	end;
	zprobval=zmodvals;
	nzpval=nrow(zmodvals);
  end;
  if (ncs > 0) then;do;
    ctmp=dat[,(nys+nxs+nms+nws+nzs+1):(nys+nxs+nms+nws+nzs+ncs)];
    %describ3 (descdatf=ctmp,type=1);
	covmeans=desctmp[1,];
    coval={&coval};
	if ((coval[1,1] ^= -999) & (ncol(coval) ^= ncs) & (model=74)) then;do;
      errcode[errs,1]=69;errs=errs+1;criterr=1;
	end;
	if ((coval[1,1] ^= -999) & (criterr=0) & (model=74)) then;do;
      notecode[notes,1]=35;notes=notes+1;cuscoval=1;
	end;
  end;
  n=nrow(ytmp);
  ones=j(n,1,1);
  modresid=ones;
  if ((nws > 0) & (mcw > 0)) then;do;
    tmp=rownum||wtmp[,1];
	%makdummy (dd=tmp,method=mcw,custcodv=2);
	wmodvals=nnvls;nwpval=nrow(wmodvals);
    if (criterr=0) then;do;
      minwwarn=0;maxwwarn=0;wnotev=0;wtmp=x[,2:ncol(x)];
	  wcatlab="W1"//"W2"//"W3"//"W4"//"W5"//"W6"//"W7"//"W8"//"W9";
	  if (xmint=1) then;do;
	    wcatlab="X1"//"X2"//"X3"//"X4"//"X5"//"X6"//"X7"//"X8"//"X9";	  
      end;
	  nwvls=nvls-1;mcwok=1;dummatw=dummat;
	  wprobval=dummatw[,2:ncol(dummatw)];
	  if (modcok=1) then;do;
        wcontval=j(2,ncol(wprobval),-999);temp=0;
        do i = 1 to 2;
          do j = 1 to nrow(dummatw);
            if (contvec[i,1]=dummatw[j,1]) then;do;
              wcontval[i,]=wprobval[j,];
              temp=temp+1;
            end;
          end;
        end;
        if (temp < 2) then;do;
          notecode[notes,1] = 20;notes = notes + 1;modcok=0;
        end;
      end;
	  if ((wmodval[1,1] ^= 999) & (xmint ^= 1)) then;do;notecode[notes,1]=9;notes=notes+1;end;
	end;
  end;
  if ((nzs > 0) & (mcz > 0)) then;do;
    tmp=rownum||ztmp[,1];
	%makdummy (dd=tmp,method=mcz,custcodv=3);
	zmodvals=nnvls;nzpval=nrow(zmodvals);
    if (criterr=0) then;do;
      minzwarn=0;maxzwarn=0;znotev=0;ztmp=x[,2:ncol(x)];
	  zcatlab="Z1"//"Z2"//"Z3"//"Z4"//"Z5"//"Z6"//"Z7"//"Z8"//"Z9";
	  nzvls=nvls-1;mczok=1;dummatz=dummat;
	  zprobval=dummatz[,2:ncol(dummatz)];
      if (modcok=1) then;do;
        zcontval=j(2,ncol(zprobval),-999);temp=0;
        do i = 1 to 2;
          do j = 1 to nrow(dummatz);
            if (contvec[i,2]=dummatz[j,1]) then;do;
              zcontval[i,]=zprobval[j,];
              temp=temp+1;
            end;
          end;
        end;
        if (temp < 2) then;do;
          notecode[notes,1] = 20;notes = notes + 1;modcok=0;
        end;
      end;
	  if (zmodval[1,1] ^= 999) then;do;notecode[notes,1]=10;notes=notes+1;end;
	end;
  end;
  if ((nxs > 0) & (mcx > 0)) then;do;
    tmp=rownum||xtmp[,1];
	%makdummy (dd=tmp,method=mcx,custcodv=1);
    if (criterr=0) then;do;
      xtmp=x[,2:ncol(x)];
	  xcatlab="X1"//"X2"//"X3"//"X4"//"X5"//"X6"//"X7"//"X8"//"X9";
	  nxvls=nvls-1;xdich=(nvls=2);
	  setxcat=nxvls-1;
      mcxok=1;dummatx=dummat;
	  xmodvals=dummatx[,1];
	  nxpval=nrow(xmodvals);
	end;
  end;
  if (nspl > 0) then;do;
    spld3=j(n,nspl,0);
    spld2=j(n,nspl,0);
    xsplmin=min(xtmp); 
    mcheck=0;ocheck=0;
    do i = 1 to nspl;
      spld3[,i]=(xtmp > spl[1,i]); 
  	  spld2[,i]=xtmp - spl[1,i];
  	  spld=spld3#spld2;
	  mcheck=mcheck+(spl[1,i]=xsplmin);
	  if (i > 1) then;do;
        if (spl[1,i] <= spl[1,(i-1)]) then;do;ocheck=1;end;
	  end;
    end;
    spld4=spld[+,];
    fff=((spld3[+,] < 2) > 0);fff=fff[+,];
    if (ocheck=0) then;do;
      do i = 1 to nspl;
	    if (i > 1) then;do;
		  * should this be spld4?;
		  * this checks to make sure that there are at least two cases;
          if (spld[1,i] >= ((spld4[1,(i-1)])-1)) then;do;fff=1;end;
	    end;
	  end;
    end;
    if (fff > 0) then;do;
      errs=errs+1;errsm[errs,1]=76;criterr=1;
    end;
    if (mcheck > 0) then;do;
      errs=errs+1;errsm[errs,1]=75;criterr=1;
    end;
    if (ocheck > 0) then;do;
      errs=errs+1;errsm[errs,1]=74;criterr=1;
    end;
    if (nspl > 8) then;do;
      errs=errs+1;errsm[errs,1]=73;criterr=1;
    end;
    xtmp=xtmp||spld;
    if (nspl < 9) then;do;
      jlab="Joint1"//"Joint2"//"Joint3"//"Joint4"//"Joint5"//"Joint6"//"Joint7"//"Joint8"; 
	  jlab=jlab[1:nspl,1];
	  xcatlab=xnames//jlab;
	  nmspl=jlab;
      xnmspl=xnames;
      nxvls=nspl+1;
	  setxcat=nxvls-1;
    end;
  end;
  dfbetas=j(201,1,"9999999");
  dfbetasC=j(201,1,"9999999");
  intlab=j(200,1,"9999999");
  dfinds=j(200,1,"9999999");
  dfindsC=j(200,1,"9999999");
  do i = 0 to 200;dfbetas[(i+1),1]=CAT("dfb_",i);dfbetasC[(i+1),1]=CAT("DFB_",i);end;
  do i = 1 to 200;intlab[i,1]=CAT("int_",i);dfinds[i,1]=CAT("dfie_",i);dfindsC[i,1]=CAT("DFIE_",i);end;
  *colslab="col1"//"col2"//"col3"//"col4"//"col5"//"col6"//"col7"//"col8"//"col9"//"col10";
  *colslab=colslab//"col11"//"col12"//"col13"//"col14"//"col15"//"col16"//"col17"//"col18"//"col19"//"col20";
  *colslab=colslab//"col21"//"col22"//"col23"//"col24"//"col25"//"col26"//"col27"//"col28"//"col29"//"col30";
  *colslab=colslab//"col31"//"col32"//"col33"//"col34"//"col35"//"col36"//"col37"//"col38"//"col39"//"col40";
  *colslab=colslab//"col41"//"col42"//"col43"//"col44"//"col45"//"col46"//"col47"//"col48"//"col49"//"col50";
  *colslab=colslab//"col51"//"col52"//"col53"//"col54"//"col55"//"col56"//"col57"//"col58"//"col59"//"col60";
  *colslab=colslab//"col61"//"col62"//"col63"//"col64"//"col65"//"col66"//"col67"//"col68"//"col69"//"col70";
  *colslab=colslab//"col71"//"col72"//"col73"//"col74"//"col75"//"col76"//"col77"//"col78"//"col79"//"col80";
  *colslab=colslab//"col81"//"col82"//"col83"//"col84"//"col85"//"col86"//"col87"//"col88"//"col89"//"col90";
  *colslab=colslab//"col91"//"col92"//"col93"//"col94"//"col95"//"col96"//"col97"//"col98"//"col99"//"col100";
  *colslab=colslab//"col101"//"col102"//"col103"//"col104"//"col105"//"col106"//"col107"//"col108"//"col109"//"col110";
  *colslab=colslab//"col111"//"col112"//"col113"//"col114"//"col115"//"col116"//"col117"//"col18"//"col119"//"col120";
  *colslab=colslab//"col121"//"col122"//"col123"//"col124"//"col125"//"col126"//"col127"//"col128"//"col129"//"col130";
  *colslab=colslab//"col131"//"col132"//"col133"//"col134"//"col135"//"col136"//"col137"//"col138"//"col139"//"col140";
  *colslab=colslab//"col141"//"col142"//"col143"//"col144"//"col145"//"col146"//"col147"//"col148"//"col149"//"col150";

  * new here;
    varname9=varnames||clunames;
    %longchk (variab=varname9);
  * end new here;
  end;
  *endit;



  
  /* DEFINE AND CHECK COVARIATES MATRIX */;
  if (ncs > 0) then;do;   
    ccmat=j((nms+nys),ncs,1);ccmatoff=ccmat;
    if (covmy=1) then;do;ccmat[nrow(ccmat),]=j(1,ncs,0);end;
    if (covmy=2) then;do;ccmat[1:nms,]=j(nms,ncs,0);end;
    if (cmatrix[1,1] ^= -999) then;do;
      if (ncol(cmatrix) ^= ((nms+nys)*ncs)) then;do;errcode[errs,1]=29;errs=errs+1;criterr=1;end;
      if (criterr = 0) then;do;tmp=1;
        do i = 1 to (nms+nys);do j = 1 to ncs;ccmat[i,j]=1-(cmatrix[1,tmp] = 0);tmp=tmp+1;end;end;
		rsumccm=ccmat[+,];rsumccm=(rsumccm=0);rsumccm=rsumccm[,+];
        if (rsumccm ^= 0) then;do;errcode[errs,1]=30;errs=errs+1;criterr=1;end;
      end;
      if (covmy ^= 0) then;do;
        notecode[notes,1]=1;notes=notes+1;end;
    end;
  end;
 
  if (criterr=0) then;do;
    anymod2=wcmat[,1]+zcmat[,1]+wzcmat[,1];anymod2=anymod2[+,];anymod2=anymod2[,+];
	anymod3=wcmat+zcmat+wzcmat;anymod3=anymod3[+,+];
	if (((anymod3 > 0) | (nspl > 0)) & ((yrelx=1) | (yrelm=1) | (yrelcov=1))) then;do;
      eivbad=1;errcode[errs,1]=82;errs=errs+1;criterr=1;
	end;
    if ((anymod2 > 0) & (nspl > 0)) then;do;errcode[errs,1]=77;errs=errs+1;criterr=1;end;
	if (((savediag=1) & (ydich=1)) | ((diagnose=1) & (ydich=1))) then;do;
     notecode[notes,1]=27;
     notes=notes+1;
	 savediag=0;diagnose=0;
    end;
  end;  
  
  if ((criterr=0) & (nms > 1)) then;do;
    serchk=bcmat[2:(nrow(bcmat)-1),2:ncol(bcmat)];
    if (serchk[+,+] > 0) then;do;
      serial=1;
      if (nms > 6) then;do;errcode[errs,1]=36;errs=errs+1;criterr=1;end;
    end;
  end;
  * mean center if needed;
  if ((center > 0) & (criterr=0)) then;do;  
    centvar={" "};
    if (criterr=0) then;do;
	  if ((center=1) | ((center=2) & (wdich=0))) then;do;
        if ((wprod=1) & (mcwok=0) & (nwpval > 1)) then;do;
          do i = 1 to nws;
		    csumwtmp=wtmp[,i];
            wtmp[,i]=wtmp[,i]-(csumwtmp[+,]/n);
            centvar=centvar||wnames[1,i];
          end;
          %describ3 (descdatf=wtmp,type=wmodcust);
          wmin=desctmp[3,1];wmax=desctmp[4,1];
          if (wmodcust=0) then;do;wmodvals=modvals;wprobval=wmodvals;end;
        end;
	  end;
      if ((center=1) | ((center=2) & (zdich=0))) then;do;
        if ((zprod=1) & (mczok=0) & (nzpval > 1)) then;do;
          do i = 1 to nzs;
		    csumztmp=ztmp[,i];
            ztmp[,i]=ztmp[,i]-(csumztmp[+,]/n);
            centvar=centvar||znames[1,i];
          end;
          %describ3 (descdatf=ztmp,type=zmodcust);
          zmin=desctmp[3,1];zmax=desctmp[4,1];
          if (zmodcust=0) then;do;zmodvals=modvals;zprobval=zmodvals;end;
        end;
	  end;
	  if ((center=1) | ((center=2) & (xdich=0))) then;do;
        if ((xprod=1) & (mcxok=0)) then;do;
          do i = 1 to nxs;
	  	    csumxtmp=xtmp[,i];
            xtmp[,i]=xtmp[,i]-(csumxtmp[+,]/n);
            centvar=centvar||xnames[1,i];
          end;
          %describ3 (descdatf=xtmp);
          xmodvals=modvals;xprobval=xmodvals;
        end;
	  end;
      if (nms > 0) then;do;
        do i = 1 to nms;
          if (mprod[1,i]=1) then;do;
		    csummtmp=mtmp[,i];
            mtmp[,i]=mtmp[,i]-(csummtmp[+,]/n);
            centvar=centvar||mnames[1,i];
          end;
        end;
        %describ3 (descdatf=mtmp);
		if ((cdeval[1,1]=-999) & (model=74)) then;do;medmeans=desctmp[1,];end;
        mmodvals=modvals;mprobval=mmodvals;
      end;
    end;
    if (ncol(centvar) > 1) then;do;notecode[notes,1]=3;notes=notes+1;end;
  end;
end;  *end a;

* start D;
* CONSTRUCT THE DATA MATRICES FOR EACH OF THE MODELS;
if (criterr=0) then;do;
  * The i loop is the dependent variable in the model matrices;
  * The j loop is the predictor variables in the model matrices;
  wsum=wcmat[+,+];zsum=zcmat[+,+];wzsum=wzcmat[+,+];
  nump=j(1,(nys+nms),-999);numint=j(1,(nys+nms),0);
  * DV;
  datcount=1;xtmpuse=0;wtmpuse=0;ztmpuse=0;xwtmpus=0;xztmpus=0;wztmpus=0;xwztmpu=0;
  xtmploc=-999;wtmploc=-999;xwtmplo=-999;ztmploc=-999;xztmplo=-999;wztmplo=-999;xwztmplo=-999;
  vlabs={" "};
  if (ncs > 0) then;do;ctmpuse=j(1,ncs,0);end;
  if (nms > 0) then;do;
    mtmpuse=j(1,nms,0);mwtmpus=j(1,nms,0);mztmpus=j(1,nms,0);
    mwztmpu=j(1,nms,0);mtmploc=j(1,nms,0);mwtmplo=j(nwvls,nms,-999);
    mztmplo=j(nzvls,nms,-999);mwztmplo=j((nwvls*nzvls),nms,-999);
  end;
  if (ncs > 0) then;do;ctmploc=j(1,ncs,0);end;
  fulldat=j(n,1,1);
  datindx=j(1000,(nms+nys),-999);
  wherew=j(2,(nms+nys),-999);wherex=j(2,(nms+nys),-999);wherez=j(2,(nms+nys),-999);wherexw=j(2,(nms+nys),-999);
  wherexz=j(2,(nms+nys),-999);wherewz=j(2,(nms+nys),-999);wherexwz=j(2,(nms+nys),-999);
  if (nms > 0) then;do;
    wherem=j(nms,(nms+nys),-999);wheremw=j(nms*2,(nms+nys),-999);
    wheremz=j(nms*2,(nms+nys),-999);wheremwz=j(nms*2,(nms+nys),-999);
	intbrdmw=j(nwvls,nms,"xxxxxxxx");
	intbrdmz=j(nzvls,nms,"xxxxxxxx");
	intbdmwz=j((nwvls*nzvls),nms,"xxxxxxxx");
  end;
  wzhigh=j(1000,(((nms+1)*(nms+2))/2),0);whigh=j(1000,(((nms+1)*(nms+2))/2),0);
  zhigh=j(1000,(((nms+1)*(nms+2))/2),0);fochigh=j(1000,(((nms+1)*(nms+2))/2),0);
  xcoefloc=1//2//3//4//5//6//7//8//9;
  intkey = " "||" "||" "||" "||" "||" "||" ";
  wzhighct=0;whighct=0;zhighct=0;foccnt=0;
  cntmp2=1;
  do i = 2 to nrow(bcmat); 
    wdid=0;zdid=0;wzdid=0;cntmp=1;start=1;cntmp=1;
    if (i < nrow(bcmat)) then;do;
      outv=mtmp[,(i-1)];modlabel=mnames[1,(i-1)]//"CONSTANT";
    end;
    if (i = nrow(bcmat)) then;do;outv=ytmp;modlabel=ynames//"CONSTANT";end;
    * The j loop is the mediator;
    * MED;
    * if (nms > 0);
    do j = 1 to (i-1);
      foccnt=foccnt+1;
      if ((j = 1) & (bcmat[i,j]=1)) then;do;
        outv=outv||xtmp;
        modlabel=modlabel//xcatlab[1:nxvls,1];
        if (xtmpuse=0) then;do;
          fulldat=fulldat||xtmp;xtmpuse=1;
		  relxmc=j(1,nxvls,relx);
          fulldatr=fulldatr||relxmc;
          do k4=datcount to (datcount+(nxvls-1));xtmploc=xtmploc//k4;end;
          xtmploc=xtmploc[2:nrow(xtmploc),1];datcount=datcount+nxvls;
        end;
        datindx[start:(start+nrow(xtmploc)-1),(i-1)]=xtmploc;
        wherex[1,(i-1)]=start+1;
        wherex[2,(i-1)]=start+nrow(xtmploc)-1+1;
        onebl=j(nrow(xtmploc),1,1);
        fochigh[(start+1):(start+nrow(xtmploc)),foccnt]=onebl;
        start=start+nrow(xtmploc);
      end;
      if ((j > 1) & (bcmat[i,j]=1)) then;do;
        outv=outv||mtmp[,(j-1)];
        modlabel=modlabel//mnames[1,(j-1)];
        if (mtmpuse[1,(j-1)]=0) then;do;
          fulldat=fulldat||mtmp[,(j-1)];fulldatr=fulldatr||relm[1,(j-1)];
          mtmpuse[1,(j-1)]=1;mtmploc[1,(j-1)]=datcount;datcount=datcount+1;
        end;
        datindx[start:(start+nrow(mtmploc)-1),(i-1)]=mtmploc[1,(j-1)];
        wherem[(j-1),(i-1)]=start+1;onebl=j(nrow(mtmploc[1,j-1]),1,1);
        ttt=nrow(mtmploc[1,(j-1)])+start-1;fochigh[(start+1):(start+nrow(mtmploc[1,(j-1)])),foccnt]=onebl;
        start=start+nrow(mtmploc[1,(j-1)]);
      end;
    end;    
    * END MED;
    * This starts the W loop;
    * W;
    if (wsum > 0) then;do;
      do j = 1 to (i-1);
        whighct=whighct+1;
        if ((j = 1) & (wcmat[i,j]=1)) then;do;
          if (wdid=0) then;do;
            outv=outv||wtmp;
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            modlabel=modlabel//wcatlab[1:nwvls,1];wdid=1;
            if (wtmpuse=0) then;do;
              fulldat=fulldat||wtmp;
                if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
              wtmpuse=1;
              do k4=datcount to (datcount+(nwvls-1));
                wtmploc=wtmploc//k4;
              end;
              wtmploc=wtmploc[2:nrow(wtmploc),1];
              datcount=datcount+nwvls;
            end;
          end;
          datindx[start:(start+nrow(wtmploc)-1),(i-1)]=wtmploc;
          wherew[1,(i-1)]=start+1;
          wherew[2,(i-1)]=start+nrow(wtmploc)-1+1;
          start=start+nrow(wtmploc);
		  cntmp1=1;intlbrd="xxx";
          do k1=1 to nxvls;
            do k2 = 1 to nwvls;
              outv=outv||(xtmp[,k1]#wtmp[,k2]);
			  if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
			  if (xwtmpus=0) then;do;
                modlabel=modlabel//intlab[cntmp2,1];
			    intkeytp=intlab[cntmp2,1]||":"||xcatlab[k1,1]||"x"||wcatlab[k2,1]||" "||" ";
                intkey=intkey//intkeytp;
				intlbrd=intlbrd||intlab[cntmp2,1];
                cntmp=cntmp+1;
				cntmp2=cntmp2+1;
			  end;
			  if (xwtmpus=1) then;do;
                modlabel=modlabel//intbrdxw[cntmp1,1];
			    intkeytp=intbrdxw[cntmp1,1]||":"||xcatlab[k1,1]||"x"||wcatlab[k2,1]||" "||" ";
                intkey=intkey//intkeytp;
                cntmp=cntmp+1;
				cntmp1=cntmp1+1;
			  end;
            end;
          end;
          if (xwtmpus=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-(nxvls*nwvls)+1):ncol(outv)];xwtmpus=1;
            intbrdxw=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            do k4=datcount to (datcount+((nwvls*nxvls)-1));
              xwtmplo=xwtmplo//k4;
            end;
            xwtmplo=xwtmplo[2:nrow(xwtmplo),1];datcount=datcount+(nxvls*nwvls);
          end;
          datindx[start:(start+nrow(xwtmplo)-1),(i-1)]=xwtmplo;
          wherexw[1,(i-1)]=start+1;
          wherexw[2,(i-1)]=start+nrow(xwtmplo)-1+1;
          onebl=j(nrow(xwtmplo),1,1);
          whigh[(start+1):(start+nrow(xwtmplo)),whighct]=onebl;
          start=start+nrow(xwtmplo);
        end;
        if ((j > 1) & (wcmat[i,j]=1)) then;do;
          if ((wdid=0) & (model ^= 74)) then;do;
            outv=outv||wtmp;
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            modlabel=modlabel//wcatlab[1:nwvls,1];wdid=1;
            if (wtmpuse=0) then;do;
              fulldat=fulldat||wtmp;wtmpuse=1;
			  if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
              do k4=datcount to (datcount+(nwvls-1));
                wtmploc=wtmploc//k4;
              end;
              wtmploc=wtmploc[2:nrow(wtmploc),1];datcount=datcount+nwvls;
            end;
            datindx[start:(start+nrow(wtmploc)-1),(i-1)]=wtmploc;
            wherew[1,(i-1)]=start+1;wherew[2,(i-1)]=start+nrow(wtmploc)-1+1;
            start=start+nrow(wtmploc);
          end;        
          intlbrd="xxx";cntmp1=1; 
          do k2 = 1 to nwvls;
            outv=outv||(mtmp[,(j-1)]#wtmp[,k2]);
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
			if (mwtmpus[1,(j-1)]=0) then;do;
              modlabel=modlabel//intlab[cntmp2,1];
			  intlabtm=intlab[cntmp2,1]||":"||mnames[1,(j-1)]||"x"||wcatlab[k2,1]||" "||" ";
              intkey=intkey//intlabtm;
			  intlbrd=intlbrd||intlab[cntmp2,1];
              cntmp=cntmp+1;cntmp2=cntmp2+1;
			end;
			if (mwtmpus[1,(j-1)]=1) then;do;
              modlabel=modlabel//intbrdmw[cntmp1,(j-1)];
			  intlabtm=intbrdmw[cntmp1,(j-1)]||":"||mnames[1,(j-1)]||"x"||wcatlab[k2,1]||" "||" ";
              intkey=intkey//intlabtm;
              cntmp=cntmp+1;cntmp1=cntmp1+1;
			end;
          end;
          if (mwtmpus[1,(j-1)]=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-nwvls+1):ncol(outv)];
			intbrdmw[1:(ncol(intlbrd)-1),(j-1)]=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            mwtmpus[1,(j-1)]=1;mw22=-999;
            do k4=datcount to (datcount+(nwvls-1));mw22=mw22//k4;end;
            mwtmplo[,(j-1)]=mw22[2:nrow(mw22),1];datcount=datcount+nwvls;
          end;
          datindx[start:(start+nrow(mwtmplo)-1),(i-1)]=mwtmplo[,(j-1)];
          wheremw[((2*j)-3),(i-1)]=start+1;
          wheremw[((2*j)-2),(i-1)]=start+nrow(mwtmplo)-1+1;
          onebl=j(nrow(mwtmplo),1,1);
          whigh[(start+1):(start+nrow(mwtmplo)),whighct]=onebl;
          start=start+nrow(mwtmplo);
        end;
      end;
    end;
    * END W;
    * This starts the Z loop;
    * Z;
    if (zsum > 0) then;do;
      do j = 1 to (i-1);
        zhighct=zhighct+1;
        if ((j = 1) & (zcmat[i,j]=1)) then;do;
          if (zdid=0) then;do;
            outv=outv||ztmp;
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
            modlabel=modlabel//zcatlab[1:nzvls,1];zdid=1;
            if (ztmpuse=0) then;do;
              fulldat=fulldat||ztmp;ztmpuse=1;
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
              do k4=datcount to (datcount+(nzvls-1));
                ztmploc=ztmploc//k4;
              end;
              ztmploc=ztmploc[2:nrow(ztmploc),1];datcount=datcount+nzvls;
            end;
          end;
          datindx[start:(start+nrow(ztmploc)-1),(i-1)]=ztmploc;
          wherez[1,(i-1)]=start+1;wherez[2,(i-1)]=start+nrow(ztmploc)-1+1;
          start=start+nrow(ztmploc);
		  intlbrd="xxx";cntmp1=1;
          do k1=1 to nxvls;
            do k2 = 1 to nzvls;
              outv=outv||(xtmp[,k1]#ztmp[,k2]);
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			  if (xztmpus=0) then;do;
                modlabel=modlabel//intlab[cntmp2,1];
			    intkeytm=intlab[cntmp2,1]||":"||xcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                intkey=intkey//intkeytm;
				intlbrd=intlbrd||intlab[cntmp2,1];
                cntmp=cntmp+1;cntmp2=cntmp2+1;
			  end;
			  if (xztmpus=1) then;do;
                modlabel=modlabel//intbrdxz[cntmp1,1];
			    intkeytm=intbrdxz[cntmp1,1]||":"||xcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                intkey=intkey//intkeytm;
                cntmp=cntmp+1;cntmp1=cntmp1+1;
			  end;
            end;
          end;
          if (xztmpus=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-(nxvls*nzvls)+1):ncol(outv)];
            intbrdxz=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
            xztmpus=1;
            do k4=datcount to (datcount+((nzvls*nxvls)-1));
              xztmplo=xztmplo//k4;
            end;
            xztmplo=xztmplo[2:nrow(xztmplo),1];
            datcount=datcount+(nxvls*nzvls);
          end;
          datindx[start:(start+nrow(xztmplo)-1),(i-1)]=xztmplo;
          wherexz[1,(i-1)]=start+1;
          wherexz[2,(i-1)]=start+nrow(xztmplo)-1+1;
          onebl=j(nrow(xztmplo),1,1);
          zhigh[(start+1):(start+nrow(xztmplo)),zhighct]=onebl;
          start=start+nrow(xztmplo);
        end;
        if ((j > 1) & (zcmat[i,j]=1)) then;do;
          if (zdid=0) then;do;
            outv=outv||ztmp;
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
            modlabel=modlabel//zcatlab[1:nzvls,1];
            zdid=1;
            if (ztmpuse=0) then;do;
              fulldat=fulldat||ztmp;ztmpuse=1;
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
              do k4=datcount to (datcount+(nzvls-1));
                ztmploc=ztmploc//k4;
              end;
              ztmploc=ztmploc[2:nrow(ztmploc),1];datcount=datcount+nzvls;
            end;
            datindx[start:(start+nrow(ztmploc)-1),(i-1)]=ztmploc;
            wherez[1,(i-1)]=start+1;wherez[2,(i-1)]=start+nrow(ztmploc)-1+1;
            start=start+nrow(ztmploc);
          end;    
		  intlbrd="xxx";cntmp1=1;
          do k2 = 1 to nzvls;
            outv=outv||(mtmp[,(j-1)]#ztmp[,k2]);
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			if (mztmpus[1,(j-1)]=0) then;do;
              modlabel=modlabel//intlab[cntmp2,1];
              intlabtm=intlab[cntmp2,1]||":"||mnames[1,(j-1)]||"x"||zcatlab[k2,1]||" "||" ";
              intkey=intkey//intlabtm;
			  intlbrd=intlbrd||intlab[cntmp2,1];
              cntmp=cntmp+1;cntmp2=cntmp2+1;
			end;
			if (mztmpus[1,(j-1)]=1) then;do;
              modlabel=modlabel//intbrdmz[cntmp1,(j-1)];
              intlabtm=intbrdmz[cntmp1,(j-1)]||":"||mnames[1,(j-1)]||"x"||zcatlab[k2,1]||" "||" ";
              intkey=intkey//intlabtm;
              cntmp=cntmp+1;cntmp1=cntmp1+1;
			end;
          end;
          if (mztmpus[1,(j-1)]=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-nzvls+1):ncol(outv)];
            intbrdmz[1:(ncol(intlbrd)-1),(j-1)]=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
            mztmpus[1,(j-1)]=1;mz22=-999;
            do k4=datcount to (datcount+(nzvls-1));mz22=mz22//k4;end;
            mztmplo[,(j-1)]=mz22[2:nrow(mz22),1];datcount=datcount+nzvls;
          end;
          datindx[start:(start+nrow(mztmplo)-1),(i-1)]=mztmplo[,(j-1)];
          wheremz[((2*j)-3),(i-1)]=start+1;
          wheremz[((2*j)-2),(i-1)]=start+nrow(mztmplo)-1+1;
          onebl=j(nrow(mztmplo),1,1);
          zhigh[(start+1):(start+nrow(mztmplo)),zhighct]=onebl;
          start=start+nrow(mztmplo);
        end;
      end;
    end;
    * END Z;
    *This starts the WZ loop;
    * WZ;
    if (wzsum > 0) then;do;  
      do j = 1 to (i-1);
        wzhighct=wzhighct+1;
        if ((j = 1) & (wzcmat[i,j]=1)) then;do;
          if (wzdid=0) then;do;
		    intlbrd="xxx";cntmp1=1;
            do k1=1 to nwvls;
              do k2 = 1 to nzvls;
                outv=outv||(wtmp[,k1]#ztmp[,k2]); 
				if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
				if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
				if (wztmpus=0) then;do;
                  modlabel=modlabel//intlab[cntmp2,1];
				  intlabtm=intlab[cntmp2,1]||":"||wcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                  intkey=intkey//intlabtm;
                  intlbrd=intlbrd||intlab[cntmp2,1];
                  cntmp=cntmp+1;cntmp2=cntmp2+1;
				end;
				if (wztmpus=1) then;do;
                  modlabel=modlabel//intbrdwz[cntmp1,1];
				  intlabtm=intbrdwz[cntmp1,1]||":"||wcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                  intkey=intkey//intlabtm;
                  cntmp=cntmp+1;cntmp1=cntmp1+1;
				end;
              end;
            end;
            if (wztmpus=0) then;do;
              fulldat=fulldat||outv[,(ncol(outv)-(nwvls*nzvls)+1):ncol(outv)];
              intbrdwz=t(intlbrd[1,2:ncol(intlbrd)]);
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			  if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
              wztmpus=1;
              do k4=datcount to (datcount+((nwvls*nzvls)-1));wztmplo=wztmplo//k4;end;
              wztmplo=wztmplo[2:nrow(wztmplo),1];
              datcount=datcount+(nzvls*nwvls);
            end;
            wzdid=1;         
          end;
          datindx[start:(start+nrow(wztmplo)-1),(i-1)]=wztmplo;
          wherewz[1,(i-1)]=start+1;
          wherewz[2,(i-1)]=start+nrow(wztmplo)-1+1;
          start=start+nrow(wztmplo);
		  intlbrd="xxx";cntmp1=1;
          do k1=1 to nxvls;
            do k2=1 to nwvls;
              do k3=1 to nzvls;
                outv=outv||(xtmp[,k1]#wtmp[,k2]#ztmp[,k3]);   
				if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
				if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end; 
				if (xwztmpu=0) then;do;
                  modlabel=modlabel//intlab[cntmp2,1];
				  intlabtm=intlab[cntmp2,1]||":"||xcatlab[k1,1]||"x"||wcatlab[k2,1]||"x"||zcatlab[k3,1];
                  intkey=intkey//intlabtm;
				  intlbrd=intlbrd||intlab[cntmp2,1];
				  cntmp=cntmp+1;cntmp2=cntmp2+1;
				end;
				if (xwztmpu=1) then;do;
                  modlabel=modlabel//intbdxwz[cntmp1,1];
				  intlabtm=intbdxwz[cntmp1,1]||":"||xcatlab[k1,1]||"x"||wcatlab[k2,1]||"x"||zcatlab[k3,1];
                  intkey=intkey//intlabtm;
				  cntmp=cntmp+1;cntmp1=cntmp1+1;
				end;
              end;
            end;
          end;
          if (xwztmpu=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-(nxvls*nwvls*nzvls)+1):ncol(outv)];
            intbdxwz=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            xwztmpu=1;
            do k4=datcount to (datcount+((nzvls*nxvls*nwvls)-1));xwztmplo=xwztmplo//k4;end;
            xwztmplo=xwztmplo[2:nrow(xwztmplo),1];
            datcount=datcount+(nxvls*nzvls*nwvls);
          end;
          datindx[start:(start+nrow(xwztmplo)-1),(i-1)]=xwztmplo;
          wherexwz[1,(i-1)]=start+1;
          wherexwz[2,(i-1)]=start+nrow(xwztmplo)-1+1;
          onebl=j(nrow(xwztmplo),1,1);
          wzhigh[(start+1):(start+nrow(xwztmplo)),wzhighct]=onebl;
          start=start+nrow(xwztmplo);
        end;
        if ((j > 1) & (wzcmat[i,j]=1)) then;do;
          if (wzdid=0) then;do;
		    intlbrd="xxx";cntmp1=1;
            do k1=1 to nwvls;
              do k2 = 1 to nzvls;
                outv=outv||(wtmp[,k1]#ztmp[,k2]);
			    if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
				if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
				if (wztmpus=0) then;do;
                  modlabel=modlabel//intlab[cntmp2,1];
				  intlabtm=intlab[cntmp2,1]||":"||wcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                  intkey=intkey//intlabtm;
                  intlbrd=intlbrd||intlab[cntmp2,1];
                  cntmp=cntmp+1;cntmp2=cntmp2+1;
				end;
				if (wztmpus=1) then;do;
                  modlabel=modlabel//intbrdwz[cntmp1,1];
				  intlabtm=intbrdwz[cntmp1,1]||":"||wcatlab[k1,1]||"x"||zcatlab[k2,1]||" "||" ";
                  intkey=intkey//intlabtm;
                  cntmp=cntmp+1;cntmp1=cntmp1+1;
				end;
              end;
            end;
            if (wztmpus=0) then;do;
              fulldat=fulldat||outv[,(ncol(outv)-(nwvls*nzvls)+1):ncol(outv)];
              intbrdwz=t(intlbrd[2:ncol(intlbrd)]);
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			  if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
              wztmpus=1;
              do k4=datcount to (datcount+((nwvls*nzvls)-1));wztmplo=wztmplo//k4;end;
              wztmplo=wztmplo[2:nrow(wztmplo),1];
              datcount=datcount+(nzvls*nwvls);
            end;
            wzdid=1;
            datindx[start:(start+nrow(wztmplo)-1),(i-1)]=wztmplo;
            wherewz[1,(i-1)]=start+1;
            wherewz[2,(i-1)]=start+nrow(wztmplo)-1+1;
            start=start+nrow(wztmplo);
          end;
		  intlbrd="xxx";cntmp1=1;
          do k1 = 1 to nwvls;
            do k2 = 1 to nzvls;
              outv=outv||(mtmp[,(j-1)]#wtmp[,k1]#ztmp[,k2]);
			  if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			  if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
			  if (mwztmpu[1,(j-1)]=0) then;do;
                modlabel=modlabel//intlab[cntmp2,1];
			    intlabtm=intlab[cntmp2,1]||":"||mnames[1,(j-1)]||"x"||wcatlab[k1,1]||"x"||zcatlab[k2,1];
                intkey=intkey//intlabtm;
				intlbrd=intlbrd||intlab[cntmp2,1];
                cntmp=cntmp+1;cntmp2=cntmp2+1;
			  end;
			  if (mwztmpu[1,(j-1)]=1) then;do;
                modlabel=modlabel//intbdmwz[cntmp1,(j-1)];
			    intlabtm=intbdmwz[cntmp1,(j-1)]||":"||mnames[1,(j-1)]||"x"||wcatlab[k1,1]||"x"||zcatlab[k2,1];
                intkey=intkey//intlabtm;
                cntmp=cntmp+1;cntmp1=cntmp1+1;
			  end;
            end;
          end;
          if (mwztmpu[1,(j-1)]=0) then;do;
            fulldat=fulldat||outv[,(ncol(outv)-(nwvls*nzvls)+1):ncol(outv)];
            intbdmwz[1:(ncol(intlbrd)-1),(j-1)]=t(intlbrd[1,2:ncol(intlbrd)]);
			if ((ncs > 0) & (ziscov > 0)) then;do;ccmatoff[(i-1),ziscov]=0;end;
			if ((ncs > 0) & (wiscov > 0)) then;do;ccmatoff[(i-1),wiscov]=0;end;
            mwztmpu[1,(j-1)]=1;mz22=-999;
            do k4=datcount to (datcount+(nwvls*nzvls)-1);mz22=mz22//k4;end;
            mwztmplo[,(j-1)]=mz22[2:nrow(mz22),1];
            datcount=datcount+(nwvls*nzvls);
          end;
          datindx[start:(start+nrow(mwztmplo)-1),(i-1)]=mwztmplo[,(j-1)];
          wheremwz[((2*j)-3),(i-1)]=start+1;
          wheremwz[((2*j)-2),(i-1)]=start+nrow(mwztmplo)-1+1;
          onebl=j(nrow(mwztmplo),1,1);
          wzhigh[(start+1):(start+nrow(mwztmplo)),wzhighct]=onebl;
          start=start+nrow(mwztmplo);
        end;
      end;
    end;
    * END WZ;
    * COV;
    if (ncs > 0) then;do;
	  ccmat=ccmat#ccmatoff;
      do j = 1 to ncs;
        if (ccmat[(i-1),j])=1 then;do;	
		   if (j=wiscov) then;do;ctmp[,j]=wtmp;end;  
           if (j=ziscov) then;do;ctmp[,j]=ztmp;end; 
           outv=outv||ctmp[,j];    
           modlabel=modlabel//covnames[1,j];
           if (ctmpuse[1,j]=0) then;do;
             fulldat=fulldat||ctmp[,j];
			 fulldatr=fulldatr||relcov[1,j];
             ctmpuse[1,j]=1;ctmploc[1,j]=datcount;datcount=datcount+1;
           end;
           datindx[start:(start+nrow(ctmploc)-1),(i-1)]=ctmploc[1,j];
           start=start+nrow(ctmploc[1,j]);
        end;
      end;
    end;
    * END COV;
    wdid=0;zdid=0;wzdid=0;
    vlabs=vlabs//modlabel[2:nrow(modlabel),1];
    numint[1,(i-1)]=cntmp-1;
    nump[1,(i-1)]=nrow(modlabel)-1;
  end;
  * END DV;

  if (modcok=1 & ((nms > 0) | (zcmat[2,1] ^= 1) | (mcx ^= 0))) then;do;
    notecode[notes,1] = 19;notes=notes+1;modcok=0;
  end;
  if ((serial = 1 | (numint[,+]>0) | nms=0) & mc > 0) then;do;
    notecode[notes,1] = 15;notes = notes + 1;boot=mc;mc=0;
  end;
  if ((boot ^= 0) | (mc ^= 0)) then;do;
    bootsz=boot;if (mc > 0) then;do;bootsz=mc;end;
    do until ((cilow > 0) & (cihigh <= bootsz));
      cilow = round(bootsz*(1-(conf/100))/2);
      cihigh = floor((bootsz*(conf/100)+(bootsz*(1-(conf/100))/2)))+1;
      if ((cilow < 1) | (cihigh > bootsz)) then;do;
        bootsz=floor((bootsz+1000)/1000)*1000;adjust=1;
      end;
    end;
    if (boot > 0) then;do;boot=bootsz;end;
    if (mc > 0) then;do;mc=bootsz;end;
    if ((adjust = 1) & (boot > 0)) then;do;notecode[notes,1]=8;notes=notes+1;end;
    if ((adjust = 1) & (mc > 0)) then;do;notecode[notes,1]=16;notes=notes+1;end;
  end;
  maxboot = floor(2*boot);
  if (&maxboot > maxboot) then;do;maxboot=floor(&maxboot);end;
  vlabs=vlabs[2:nrow(vlabs),1];
  if (numint[,+] > 0) then;do;intkey=intkey[2:nrow(intkey),];end;
  fulldat=fulldat[,2:ncol(fulldat)];
  fulldatr=fulldatr[1,2:ncol(fulldatr)];
  fochigh=fochigh[1:max(nump),];whigh=whigh[1:max(nump),];
  zhigh=zhigh[1:max(nump),];wzhigh=wzhigh[1:max(nump),];
  coeffs=fochigh+whigh+zhigh+wzhigh;
   * this is rowmax in SPSS version;
   bootloc=j(max(nump),ncol(nump),0);


  * here i am deriving the locations in boot file needed for indirect effects;
  if (nms > 0) then;do;
    cntmp=1;
    do i = 1 to ncol(nump);
      do j = 1 to nump[1,i];bootloc[j,i]=cntmp;cntmp=cntmp+1;end;
    end;
    fochighb=j(nrow(fochigh),ncol(fochigh),0);
    whighb=fochighb;zhighb=fochighb;wzhighb=fochighb;
    thetaxmb=j(nrow(fochighb),nms,0);thetaxyb=j(nrow(fochighb),1,0);pathsfoc=j(nxvls,1,0);
    cntmp=1;
    do i = 1 to (nms+nys);
      do j = 1 to i;
        fochighb[,cntmp]=fochigh[,cntmp]#bootloc[,i];
        whighb[,cntmp]=whigh[,cntmp]#bootloc[,i];
        zhighb[,cntmp]=zhigh[,cntmp]#bootloc[,i];
        wzhighb[,cntmp]=wzhigh[,cntmp]#bootloc[,i];
        coeffsb=fochighb+whighb+zhighb+wzhighb;
        if ((i < (nms+nys)) & (j = 1)) then;do;thetaxmb[,i]=coeffsb[,cntmp];end;
        if ((i = (nms+nys)) & (j = 1)) then;do;thetaxyb[,1]=coeffsb[,cntmp];end;
        cntmp=cntmp+1;
      end;
    end;
    thetamyb=coeffsb[,(ncol(coeffsb)-nms+1):ncol(coeffsb)];
    if (serial = 1) then;do;thetammb=j(nrow(coeffsb),((nms*(nms-1))/2),0);end;
    cntmp=1;
    if ((nms > 1) & (serial = 1)) then;do;
      do i = 1 to (nms-1);
        start=((i+2)*(i+1))/2;
        do j = 2 to (nms-i+1);thetammb[,cntmp]=coeffsb[,start];start=start+j+i-1;cntmp=cntmp+1;end;
      end; 
    end;
  end;
  if ((total = 1) & ((numint[,+]=0) | (xmint=1))) then;do;
    dototal=1;
	rsumtp=bcmat[,1];rsumtp2=bcmat[nrow(bcmat),];
    if ((rsumtp[+,] ^= (nms+nys)) | (rsumtp2[,+] ^= (nms+nys))) then;do;
      dototal=0;alttotal=1;notecode[notes,1]=12;notes=notes+1;
    end;
    if (ncs > 0) then;do;
      if (ccmat[+,+] < (nrow(ccmat)*ncol(ccmat))) then;do;
        dototal=0;alttotal=1;notecode[notes,1]=11;notes=notes+1;
      end;
    end;
	if (model=74) then;do;
      if (xdich=0) & (nxvls=1) then;do;dototal=0;alttotal=1;end;
	  if (((xdich=1) | (nxvls > 1)) & (ncs > 0) & (model=74)) then;do;dototal=0;alttotal=1;end;
	end;
  end;  
  if (eivbad=0) then;do;
    reltmp=relx||relm||relcov;
    reliabc1=(reltmp > 1);reliabc2=(reltmp <=0);
	reliabck=reliabc1[,+]+reliabc2[,+];
	reliabck=reliabck[,+];
    if (reliabck ^= 0) then;do;
      errcode[errs,1]=84;errs=errs+1;criterr=1;eivbad=1;
    end;
  end;  
  if (eivdo=1) then; do;
    if (nxvls > 1) then;do;
      mcxrel=j(1,(nxvls-1),relx[1,1]);
      relx=mcxrel||relx;
      eivrel=mcxrel||eivrel;
    end;
    ssquares=0;crossv=0;stand=0;subsets=0;savediag=0;
    dominate=0;diagnose=0;
	if (robustse = 1) | (hc ^= 5) then;do;
      errcode[errs,1]=87;errs=errs+1;criterr=1;hc=5;robustse=0;
    end;
    modelres=0;*linsum=999;*nlinsum=0;
    effsize=0;
  end;

end;
* END D;
if ((criterr=0) & (ncs > 0)) then;do;
  rsumccm=ccmat[+,];rsumccm=(rsumccm=0);rsumccm=rsumccm[,+];
  if (rsumccm ^= 0) then;do;errcode[errs,1]=51;errs=errs+1;criterr=1;end;
end;
if (outscreen=1) then;do;
  print "**********************   PROCESS Procedure for SAS Version 5.0   ***********************";
  print "Written by Andrew F. Hayes, Ph.D.  http://www.afhayes.com";
  print "Documentation available in Hayes (2022) www.guilford.com/p/hayes3";
end;
if (criterr=0) then;do;  
  modresid=j(n,1,999999);
  alldfbs=modresid;
  if ((stand=1) & (ydich=1)) then;do;stand=0;end;
  anymod2=wcmat+zcmat+wzcmat;anymod2=anymod2[+,];anymod2=anymod2[,+];
  *if ((anymod2 > 0) & (stand = 1)) then;*do;
  *  notecode[notes,1]=27;*notes=notes+1;*stand=0;
  *end;
  funny=1;
  if (outscreen=1) then;do;
    print "*****************************************************************************************";
    print modelvar [rowname = modelvlb label = "Model and Variables"];
    if (ncs > 0) then;do;
      okcovpr=1;covname9=covnames;
      if (ncs = xfakecov) then;do;okcovpr=0;end;
      if (ncs > xfakecov) then;do;
        covname9=covname9[1,(xfakecov+1):ncol(covname9)];
      end;
      if (okcovpr=1) then;do;
        print covname9 [label="Covariates:"];
      end;
    end;
    print "Sample size:" n [label = " "];
  end;
  if (&seed ^= 0) then;do;
    seedt=&seed;
	if (outscreen=1) then;do;
	  print seedt [label = "Custom seed:"];
	end;
  end;
  if (nspl > 0) then;do;
    print spl [label="Location of spline joints:" rowname=xnmspl colname=nmspl format=&decimals];
  end;
  if (clusok=1) then;do;
    clusrnm="Number"||"Mean"||"Min"||"Max";
    print clusinfo [label="Number of clusters and cluster size:" rowname=clusrnm format=&decimals];
  end;
  maxresm=9;
  resultm=j(1,maxresm,99999);  
  if (describe=1) then;do;
    means=dat[+,]/n;
    sigmatal=((dat-J(n,1)*dat[:,])`*(dat-J(n,1)*dat[:,]))/(n-1);
    sdvec=sqrt(diag(sigmatal));
    sdall=diag(1/vecdiag(sdvec));
    sdvec=vecdiag(sdvec); 
    corall=sdall*sigmatal*sdall`;
    means=means//sdvec`//dat[><,]//dat[<>,];
	*if (ncol(means) > 9) then;do;resultm=j(1,ncol(means),99999);maxresm=ncol(means);end;
	%outform3 (outtodo=means,outbig=maxresm);
	%outform3 (outtodo=corall,outbig=maxresm);
	if (outscreen=1) then;do;
      mnsdlab="Mean"//"SD"//"Min"//"Max";
      print means [label="Variable means and standard deviations" colname=varnames rowname=mnsdlab format=&decimals];
      print corall [label="Variable intercorrelations (Pearson's r)" colname=varnames rowname=varnames format=&decimals];
	end;
  end;
  if (mcxok=1) then;do;
    labtmp=xnames||xcatlab[1:nxvls,1]`;
	if (outscreen=1) then;do;
	  rlabtmp=j(nxvls,1," ");
	  print dummatx [colname=labtmp rowname=rlabtmp label="Coding of categorical X variable for analysis:"];
	end;
  end;
  if ((mcwok=1) & (xmint=0)) then;do;
    labtmp=wnames||wcatlab[1:nwvls,1]`;
	if (outscreen=1) then;do;
	  rlabtmp=j(nwvls,1," ");
	  print dummatw [colname=labtmp rowname=rlabtmp label="Coding of categorical W variable for analysis:"];
	end;
  end;
  if (mczok=1) then;do;
    labtmp=znames||zcatlab[1:nzvls,1]`;
	if (outscreen=1) then;do;
	  rlabtmp=j(nzvls,1," ");
	  print dummatz [colname=labtmp rowname=rlabtmp label="Coding of categorical Z variable for analysis:"];
	end;
  end;
end;
* start of start;
if (criterr=0) then;do;
  diaglist=ListCreate();
  diaglisl=ListCreate();
  outnames=ynames;
  outvars=ytmp;
  if (nms > 0) then;do;
    outnames=mnames||ynames;outvars=mtmp||ytmp;
    indcov=j(((nms*2)+(nms*(nxvls-1))),((nms*2)+(nms*(nxvls-1))),0);
    mcsopath=j(((nms*2)+(nms*(nxvls-1))),1,0);
  end;
  labstart=1;intstart=1;start=1;coeffmat=j(1,6,0);conseq={"        "};dfmat=0;coeffcol=0;pathscnt=1;pathscn2=1;
  * start G loop;
  do i = 1 to (nms+nys) while (criterr=0);
    highf=j(1,5,0);
    highf2=highf;
    flabel=" ";y=outvars[,i];
	if ((i =(nms+nys)) & (ydich=1)) then;do;highf=j(1,3,0);highf2=highf;end;
	xindx=datindx[1:(nump[1,i]-1),i];
	x=fulldat[,xindx];
	if ((eivdo=1) & (ydich=0)) then;do;
      releiv=fulldatr[1,xindx];
	  releiv=1||releiv;
	  x2eiv=y||x;
	  sigmatal=((x2eiv-J(n,1)*x2eiv[:,])`*(x2eiv-J(n,1)*x2eiv[:,]))/(n-1);
      sdvec=sqrt(diag(sigmatal));
      sdall=diag(1/vecdiag(sdvec));
      corbxx=sdall*sigmatal*sdall`;
      tolstat2=j((ncol(x2eiv)-1),1,9999);
      do tolcom=2 to ncol(x2eiv);
        riichoose=I(ncol(x2eiv));
        riichoose[tolcom,tolcom]=0;
	    riichoose[1,1]=1;
        riix=riichoose*corbxx*riichoose`;
        riix[tolcom,tolcom]=1;
        riiy=corbxx[,tolcom]#vecdiag(riichoose);
        tolstat2[(tolcom-1),1]=riiy`*inv(riix)*riiy;
      end;
	  tolstat2=(t(releiv[1,2:ncol(releiv)]) < tolstat2);
	  tolstat2=tolstat2[+,];
      if (tolstat2 > 0) then;do;
        criterr=1;errcode[errs,1]=85;errs=errs+1;
      end;  
      free x2eiv;
	end;
	x=ones||x;xsq=x`*x;
    exsq=eigval(xsq);
	exsq=(exsq <= .000000000002);
	zeroeig=exsq[+,];

    means=x[+,]/n;
	vlabsm=vlabs[labstart:(labstart+(nump[1,i]-1)),1];
    * start e;
    if (criterr=0) then;do;
	  if ((ydich=0) | (i<(nms+nys))) then;do;
	    %modeles3 (y=y,x=x,type=1,full=1);
		if (modelres=1) then;do;modresid=modresid||resid;end;
	    *dfmatt=j(nrow(modres),1,modsum[1,6]);
	  end;
      if ((i =(nms+nys)) & (ydich=1)) then;do;
	    %modeles3 (y=y,x=x,type=2,full=1);
	    dfmatt=j(nrow(modres),1,-999);
		%outform3 (outtodo=modsum,outbig=maxresm);
        %outform3 (outtodo=modres,outbig=maxresm);
	  end;

	  if (criterr=0) then;do;

      outnmtmp=outnames[1,i];  
	  if ((outscreen=1) & (criterr=0)) then;do;
        print "******************************************************************************************";
	    if (eivdo=1) then;do;
	      print "                            Errors-in-variables regression";
	    end;
	    print outnmtmp [label="OUTCOME VARIABLE:"];
	    if ((i =(nms+nys)) & (ydich=1)) then;do;
	      nmsd = outnames[1,i]||"Analysis";
	      if (outscreen=1) then;do;
	        print "Coding of binary Y for logistic regression analysis:";
            print rcd [colname = nmsd label = " " format = 5.2];
	      end;
	    end;
	  end;    
	  if (zeroeig > 0) then;do;
        print "SINGULAR OR NEAR SINGULAR DATA MATRIX";
	    criterr=1;errcode[errs,1]=31;errs=errs+1;
	  end;

	  * this part might not have to be moved in R because it may not exist;
      if ((ydich=0) | (i < (nms+nys))) then;do;
        %outform3 (outtodo=modsum,outbig=maxresm);
	    if (crossv=1) then;do;%outform3 (outtodo=crossr,outbig=maxresm);end;
	    if (ssquares=1) then;do;%outform3 (outtodo=sumtable,outbig=maxresm);end;
	    %outform3 (outtodo=modres,outbig=maxresm);
	  end;
	  

	  obscoeff=obscoeff||b`;
	  if (outscreen=1) then;do;
	    print modsum [label="Model Summary" colname=modsuml format=&decimals];
		if ((ydich=0) | (i < (nms+nys))) then;do;
		  if (crossv=1) then;do;
            crossvcl="Browne"||"LvOut1"||"LvOut2";
			print crossr [label="Shrunken R estimates" colname=crossvcl format=&decimals];
		  end;
		  if (ssquares=1) then;do;
		    sumtablr="Regress"||"Residual"||"Total";
		    sumtablc="SS"||"df"||"MS";
            print sumtable [label=" " rowname=sumtablr colname=sumtablc format=&decimals];
		  end;
		end;
	    print modres [label="Model" rowname=vlabsm colname=modresl format=&decimals];
	  end;
	  if ((savediag=1) & (ydich=0) & (sv4match=0)) then;do;
	  call ListAddItem(diaglist, regdiag);
	  diagnms="casenum"||vlabsm[2:nrow(vlabsm),1]`||outnames[1,i]||"pred"||"resid"||"d_resid"||"stresid"||"tresid"||"h"||"mahal"||"cook"||"dmsreg"||"drsq"||"dskew"||t(dfbetas[1:nrow(modres),1]);
      call ListAddItem(diaglisl,diagnms);
		*if (model < 4) then;*do;*dfilenum[i]="";*end;
        *create ("&diagfile"+dfilenum[i]) from regdiag [colname=diagnms];*append from regdiag;
		*close ("&diagfile"+dfilenum[i]);
      end;
	  basemod=modsum[1,1];
	  basemodx=basemod;
      if ((i =(nms+nys)) & (ydich=1)) then;do;
	    if (outscreen=1) then;do;
	      print "These results are expressed in a log-odds metric";
		end;
		notecode[notes,1]=26;notes=notes+1;
      end;
	  coeffmat=coeffmat//modres;
      conseqt=j(nrow(modres),1,outnames[1,i]);
      conseq=conseq//conseqt;
	  dfmat=dfmat//dfmatt;
	  labstart=labstart+nump[1,i];
	  do jklm = 1 to nrow(modres);
	    savlabs[savlabsc,1]=outnames[1,i];savlabs[savlabsc,2]="_";savlabs[savlabsc,3]=vlabsm[jklm,1];
		savlabsc=savlabsc+1;
	  end;
	  if (stand=1) then;do;
        predsd=j(nrow(modres),1,0);
		stdmod=modres[,1]/ovsd[1,i];
		do jd=1 to ncol(x);
          descdat=x[,jd];
		  predsd[jd,1]=(n*descdat`*descdat)-((descdat[+,])`*descdat[+,]);
  		  predsd[jd,1]=sqrt(predsd[jd,1]/(nrow(descdat)*(nrow(descdat)-1)));
		end;
        if ((wherex[1,i] ^= -999) & ((nxvls > 1) | (xdich=1))) then;do;
          sdmsone=j(nxvls,1,1);
		  predsd[wherex[1,i]:wherex[2,i],1]=sdmsone;
		  pstog=1;
		end;
		predsd[1,1]=1;stdmod=stdmod#predsd;
		stdmod=stdmod[2:nrow(stdmod),1];
		sdvlabs=vlabsm[2:nrow(vlabsm),1];
		*%outform3 (outtodo=stdmod,outbig=maxresm);
		coeffl22="coeff";
		*if (outscreen=1) then;*do;
	      *print stdmod[label="Standardized coefficients" rowname=sdvlabs colname=coeffl22 format=&decimals];
        *end;
      end;
	  *if (zpp=1 & ((i < (nms+nys)) | ((i=(nms+nys)) & ydich=0))) then;*do;
	  if (stand=1 & ((i < (nms+nys)) | ((i=(nms+nys)) & ydich=0))) then;do;
        ivnames=vlabsm[2:nrow(vlabsm),1];
		%outform3 (outtodo=zppout,outbig=maxresm);
		%outform3 (outtodo=zppout2,outbig=maxresm);
		if (outscreen=1) then;do;
		  zppcnms="r"||"sr"||"pr"||"standYX"||"standY"||"standX";
          print zppout [label="Scale-free and standardized measures of association" rowname=ivnames colname=zppcnms format=&decimals];
		  zppcnms2="eta-sq"||"p_eta-sq"||"f-sq";
		  print zppout2 [label=" " rowname=ivnames colname=zppcnms2 format=&decimals];
		end;
      end; 
      if ((nms > 0) & (serial = 0) & (numint[,+] = 0) & ((normal=1) | (mc > 0))) then;do;
        if (i < (nms+nys)) then;do;
          indcov[(((i-1)*nxvls)+1):(i*nxvls),(((i-1)*nxvls)+1):(i*nxvls)]=varb[2:(1+nxvls),2:(1+nxvls)];
          mcsopath[(((i-1)*nxvls)+1):(i*nxvls) ,1]=modres[2:(1+nxvls),1];
        end;
        if (i = (nms+nys)) then;do;
          atm=ncol(wherem);
          indcov[((nms*nxvls)+1):nrow(mcsopath),((nms*nxvls)+1):nrow(mcsopath)]=varb[wherem[1,atm]:(wherem[1,atm]+nms-1),wherem[1,atm]:(wherem[1,atm]+nms-1)];
          mcsopath[((nms*nxvls)+1):nrow(mcsopath),1]=modres[wherem[1,atm]:(wherem[1,atm]+nms-1),1];
          sobelok=1;          
        end;
      end;
	  obsdirfx=j(1,nxvls,0);dirzes=j(1,nxvls,0);
	  if ((i = (nms+nys)) & (bcmat[nrow(bcmat),1]=1)) then;do;
        direff=modres[2:(1+nxvls),];
		obsdirfx=direff[,1]`;
        direfflb=modresl;
        direffl2=vlabsm[2:(1+nxvls),];
        lmat=j(nrow(b),1,0);lmat2=j(nxvls,1,1);
        lmat[2:(1+nxvls),1]=lmat2;
		if (ydich ^= 1) then;do;
          %ftest3 (lm=lmat,bcoef=b,cv=varb,chr=1,brsq=r2);
          diromni=fresult[1,(1+eivdo):ncol(fresult)];
		end;
		if (ydich=1) then;do;
          %llrtest3 (lm=lmat);
		  diromni=fresult;
		end;
      end;
      if (numint[1,i] > 0) then;do;
        intkeym=intkey[intstart:(intstart+numint[1,i]-1),];
		if (outscreen=1) then;do;
          print intkeym [label="Product terms key:"];
		end;
      end;
      if (covcoeff=1) then;do;
	    if (outscreen=1) then;do;
          print varb [label="Covariance matrix of regression parameter estimates:" rowname=vlabsm colname=vlabsm format=&decimals];
        end;
        %outform3 (outtodo=varb,outbig=maxresm);	       
      end;
	  if ((model=0) & (settest=1)) then;do;
        lmat2=j(nrow(b),(nxset+setxcat),0);
        lmat2[2:(nxset+setxcat+1),]=I(nxset+setxcat);
        if (ydich ^= 1) then;do;
          %ftest3 (lm=lmat2,bcoef=b,cv=varb,chr=(1-eivdo),brsq=r2,skip=1);          
          if (outscreen=1) then;do;
		    ftestclb="R2-chng"||hcflab||"df1"||"df2"||"p";
			if (eivdo=1) then;do;
			  ftestclb=ftestclb[1,2:ncol(ftestclb)];
			end;
            print fresult [label = "Hypothesis test for variables in X set:" colname=ftestclb format=&decimals];
          end;
		  if (diagnose=1) then do; 
            zzzx=x*lmat2;
            zzzx=ones||zzzx;            
            bptestx=0.5*(qprime`*zzzx*inv(zzzx`*zzzx)*zzzx`*qprime);
            bprobusx=bptestx*(2/((qprime`*qprime)/nrow(zzzx)));
		    bpresulx=bptestx||ncol(lmat2)||(1-probchi(bptestx,(ncol(lmat2))));
            bpresu2x=bprobusx||ncol(lmat2)||(1-probchi(bprobusx,(ncol(lmat2))));
	        bpresulx=bpresulx//bpresu2x;
		    bprlabs="Normal"||"Robust";bpclabs="Chi-sq"||"df"||"p";
			if (outscreen=1) then;do;
		      print bpresulx [label="Breusch-Pagan test of heteroskedasticity for variables in X set:" colname=bpclabs rowname=bprlabs format=&decimals];
			end;
          end;
        end;
        if (ydich=1) then;do; 
          lmat2=lmat2[,+];   
          %llrtest3 (lm=lmat2);
          if (outscreen=1) then;do;
			ftestclb="Chi-sq"||"df"||"p";
            print fresult [label="Likelihood ratio test for variables in X set:" colname=ftestclb format=&decimals];
          end;
        end;
        %outform3 (outtodo=fresult,outbig=maxresm); 
        if ((ydich=0) & (diagnose=1)) then;do;
		  %outform3 (outtodo=bpresulx,outbig=maxresm); 
        end; 
      end;
      * start of X by M interaction;
      if ((model ^=74) & (xmtest=1) & (nms > 0)) then;do;
        r2tmp=r2;btmp=b;varbtmp=varb;dfrestmp=dfres;tvaltmp=tval;
        xmtst=j(nms,4,0);xmtstlbc=hcflab||"df1"||"df2"||"p";
        if ((i=(nms+nys)) & (ydich=1)) then;do;
          xmtst=j(nms,3,0);xmtstlbc="Chi-sq"||"df"||"p"; 
		end;
        xmtstlb=" ";xmtmat=x;numxint=0;
        do xmints=2 to i;
		  x=xmtmat;
		  if ((bcmat[(i+1),xmints]=1) & (wzcmat[(i+1),xmints] ^=1)) then;do;
            if (bcmat[(i+1),1]=0) then;do;
			  x=xmtmat||xtmp;
              if ((i = (nms+nys)) & (ydich=1)) then;do;
                %modeles3 (y=y,x=x,type=2,full=1);
			    basemodx=LL2;
			  end;
			end;
			do xmtlp1=1 to nxvls;
              x=x||(xtmp[,xmtlp1]#mtmp[,(xmints-1)]);
			end;
			if ((i < (nms+nys)) | (ydich=0)) then;do;
              %modeles3 (y=y,x=x,type=1,full=1);
			end;
            if ((i = (nms+nys)) & (ydich=1)) then;do;
              %modeles3 (y=y,x=x,type=2,full=1);
			  chidfxm=basemodx-LL2;
			end;
            lmat=j(nrow(b),nxvls,0);lmattmp=I(nxvls);
			lmat[(nrow(lmat)-nxvls+1):nrow(lmat),]=lmattmp;
			%ftest3 (lm=lmat,bcoef=b,cv=varb,skip=1);
			numxint=numxint+1;
			xmtst[numxint,]=fresult;
            if ((i = (nms+nys)) & (ydich=1)) then;do;
			  xmtst[numxint,1]=chidfxm;
			  xmtst[numxint,3]=1-probchi(chidfxm,nxvls);
			end;
			xmtstlb=xmtstlb//highlbx[(xmints-1),1];
		  end;
		end;
        x=xmtmat;
        if (numxint > 0) then;do;
          xmtstlb=xmtstlb[2:(numxint+1),];xmtst=xmtst[1:numxint,];
		  %outform3 (outtodo=xmtst,outbig=maxresm);
		  if (nms = 1) then;do;
            xmtstlb=" ";
		  end;
		  if ((i < (nms+nys)) | (ydich=0)) then;do;
		    if (outscreen=1) then;do;
              print xmtst [label="Test(s) of X by M interaction" rowname=xmtstlb colname=xmtstlbc format=&decimals];
			end;
          end;
		  if ((i = (nms+nys)) & (ydich=1)) then;do;
		    if (outscreen=1) then;do;
		      print xmtst [label="Likelihood ratio test(s) of X by M interaction" rowname=xmtstlb colname=xmtstlbc format=&decimals];
			end;
		  end;
		end;
        r2=r2tmp;b=btmp;varb=varbtmp;dfres=dfrestmp;tval=tvaltmp;
	  end;
	  * end of X by M interaction;
      * here is where we do F tests;
      * START F;
      if (criterr = 0) then;do;
        jj=0;
        do j = start to ((start+i)-1);
		  dbint=0;
          lmat=whigh[1:nump[1,i],j];
          lmat2=wzhigh[1:nump[1,i],j];
          if ((lmat[+,] > 0) & (lmat2[+,] = 0)) then;do;
		    if ((i <(nms+nys)) | (ydich ^=1)) then;do;
              %ftest3 (lm=lmat,bcoef=b,cv=varb,chr=1,brsq=r2);
			  lmatdb=lmat;dbint=dbint+1;
			end;
			if ((ydich=1) & (i=(nms+nys))) then;do;
              %llrtest3 (lm=lmat);
			  lmatdb=lmat;dbint=dbint+1;
			end;
            highf=highf//fresult;
			highf2=highf2//fresult;
            if (j = start) then;do;flabel=flabel//"X*W";end;
            if (j > start) then;do;
              if (nms > 1) then;do;flabel=flabel//highlbw[jj,1];end;
              if (nms = 1) then;do;
			    if (xmint=0) then;do;flabel=flabel//"M*W";end;
				if (xmint=1) then;do;flabel=flabel//"X*M";end;
              end;
            end;
          end;      
          lmat=zhigh[1:nump[1,i],j];lmat2=wzhigh[1:nump[1,i],j];
          if ((lmat[+,] > 0) & (lmat2[+,] = 0)) then;do;
		  	if ((i <(nms+nys)) | (ydich ^=1)) then;do;
              %ftest3 (lm=lmat,bcoef=b,cv=varb,chr=1,brsq=r2);
			  dbint=dbint+1;
			end;
			if ((ydich=1) & (i=(nms+nys))) then;do;
			  %llrtest3 (lm=lmat);
			  dbint=dbint+1;
			end;
            highf=highf//fresult;
			highf2=highf2//fresult;
            if (j = start) then;do;flabel=flabel//"X*Z";end;
            if (j > start) then;do;
              if (nms > 1) then;do;flabel=flabel//highlbz[jj,1];end;
              if (nms = 1) then;do;flabel=flabel//"M*Z";end;
            end;
          end;
          
		  if (dbint=2) then;do;
            lmatdb=lmatdb+lmat;
			if ((ydich=1) & (i=(nms+nys))) then;do;
              %llrtest3 (lm=lmatdb);
			end;
            if ((ydich ^= 1) | (i < (nms+nys))) then;do;
              %ftest3 (lm=lmatdb,bcoef=b,cv=varb,chr=1,brsq=r2);
			end;
			dbint=0;
			highf=highf//fresult;
			if ((jj=0) & (nms > 0)) then;do;flabel=flabel//"BOTH(X)";end;
			if ((jj=0) & (nms = 0)) then;do;flabel=flabel//"BOTH";end;
			if ((jj>0) & (nms=1)) then;do;flabel=flabel//"BOTH(M)";end;
			if ((nms > 1) & (jj > 0)) then;do;flabel=flabel//highlbbt[jj,1];end;
		  end;

          lmat2=wzhigh[1:nump[1,i],j];
          if (lmat2[+,] > 0) then;do;
		  	if ((i <(nms+nys)) | (ydich ^=1)) then;do;
              %ftest3 (lm=lmat2,bcoef=b,cv=varb,chr=1,brsq=r2);
			end;
			if ((ydich=1) & (i=(nms+nys))) then;do;
			 %llrtest3 (lm=lmat2);
			end;
            highf=highf//fresult;
			highf2=highf2//fresult;
            if (j = start) then;do;flabel=flabel//"X*W*Z";end;
            if (j > start) then;do;
              if (nms > 1) then;do;flabel=flabel//highlbwz[jj,1];end;
              if (nms = 1) then;do;flabel=flabel//"M*W*Z";end;
            end;
          end;
          jj=jj+1;
        end;
        start=start+i;
      end;
	  * END F;
	  if (nrow(highf) > 1) then;do;
        highf=highf[2:nrow(highf),];
		highf2=highf2[2:nrow(highf2),];
        flabel=flabel[2:nrow(flabel),1];
		%outform3 (outtodo=highf,outbig=maxresm);
		if ((i <(nms+nys)) | (ydich =0)) then;do;
          clabtmp="R2-chng"||hcflab||"df1"||"df2"||"p";
		  if (outscreen=1) then;do;
            print highf [label="Test(s) of highest order unconditional interactions:" format = &decimals rowname=flabel colname=clabtmp];
		  end;
        end;
		if ((ydich=1) & (i = (nms+nys))) then;do;
          clabtmp="Chi-sq"||"df"||"p";
		  if (outscreen=1) then;do;
		    print highf [label="LR test(s) of highest order unconditional interactions:" format = &decimals rowname=flabel colname=clabtmp];
		  end;
		end;
        intpb=highf2[,ncol(highf2)];
      end;
      intstart=intstart+numint[1,i];
	end; * end E loop;


* here is the probing macro;

if (criterr=0) then;do;
  threeway=0;didprint=0;didsome=0;sigintct=0;
  * start R;
  do jmed =1 to (nms+1);  
    hasw=0;hasz=0;jnok=0;nm1vls=0;nm2vls=0;panelgrp=0;graphixs="with"||outnames[1,i]||"by";
    focpred4={" "};intprint=0;modcat=0;
   * start A;
    if (jmed <= i) then;do;
      if ((jmed = 1) & ((i+1) = nrow(bcmat))) then;do;pathscnt=pathscnt+1;end;
      if ((jmed ^= 1) | ((i+1) ^= nrow(bcmat))) then;do;
        paths=paths||bcmat[(i+1),jmed];
        pathsw=pathsw||wcmat[(i+1),jmed];
        pathsz=pathsz||zcmat[(i+1),jmed];
        pathswz=pathswz||wzcmat[(i+1),jmed];
        temp=fochigh[,pathscnt]#bootloc[,i];
        pathsfoc=pathsfoc||pathsfoc[,1];
        if (jmed=1) then;do;pathtype=pathtype||1;end;
        if ((i+1)=nrow(bcmat)) then;do;pathtype=pathtype||3;end;
        if ((jmed > 1) & ((i+1) < nrow(bcmat))) then;do;pathtype=pathtype||2;end;
        if ((jmed=1) & (nxvls > 1) & (bcmat[(i+1),jmed]=1)) then;do;
          pathsfoc[,(pathscn2+1)]=temp[2:(nxvls+1),1];
        end;
        if ((jmed > 1) | ((jmed=1) & (nxvls=1))) then;do;
          temp=temp[<>,];
          pathsfoc[1,(pathscn2+1)]=temp;
        end;
        pathscnt=pathscnt+1;pathscn2=pathscn2+1;
        if (i <= nms) then;do;pathsdv=pathsdv||mnames[1,i];end;
        if (i > nms) then;do;pathsdv=pathsdv||ynames;end;
      end;
      coeffcol=coeffcol+1;
      probettt=coeffs[1:nrow(b),coeffcol];
      if ((jmed=1) & ((bcmat[(i+1),jmed]=1))) then;do;
        omni=j(nrow(probettt),nxvls,0);omnitmp=I(nxvls);omni[2:(1+nxvls),]=omnitmp;
      end;
	  probttmp=probettt[+,];
      if (probttmp > 0) then;do;
        probvarb=j(probttmp,probttmp,999);probcoef=j(probttmp,1,999);coefflp2=1;
        do coefflp=1 to nrow(probettt);
          if (probettt[coefflp,1]=1) then;do;probcoef[coefflp2,1]=b[coefflp,1];coefflp2=coefflp2+1;end;
        end;
        coefflp=0;coefflp2=0;
        do iclp=1 to nrow(probettt);
          if probettt[iclp,1]=1 then;do;
            coefflp=coefflp+1;coefflp2=coefflp;
            probvarb[coefflp,coefflp] = varb[iclp,iclp];
            if (iclp < nrow(probettt)) then;do;
              do jclp=(iclp+1) to nrow(probettt);       
                if (probettt[jclp,1]=1) then;do;
                  coefflp2=coefflp2+1;
                  probvarb[coefflp,coefflp2]=varb[iclp,jclp];
                  probvarb[coefflp2,coefflp]=varb[iclp,jclp];
                end;
              end;
            end;
          end;
        end; 
      end;
    end;
    * end A;
    xprobval=xmodvals; 
    if ((nxvls > 1 | mcx > 0) & (nspl < 1)) then;do;xprobval=dummatx[,2:ncol(dummatx)];end;
    * start B;
    if ((wcmat[(i+1),jmed]=1) & (zcmat[(i+1),jmed]=0)) then;do;
      numplps=1;modvals=wmodvals;probeval=wmodvals;wheremv1=wherexw;
      nm1vls=nwvls;lpstsp=1||1;modcat=0;jnmod=wtmp;jnmodlab=wnames;
      jnok=1;jnmin=wmin;jnmax=wmax;wherejn1=2;
      if (jmed=1) then;do;
        wherejn3=wherexw[1,i];
        if (nxvls > 1) then;do;jnok=1;end;
      end;
      if (jmed > 1) then;do;wherejn1=wherem[(jmed-1),i];wherejn3=wheremw[((2*jmed)-3),i];end;
      if (nwvls > 1) then;do;
        probeval=wprobval;lpstsp[1,2]=ncol(probeval);modcat=1;jnok=0;
      end;
      if (wdich = 1) then;do;modcat=1;jnok=0;end;
      problabs=wnames;focpred3=wnames||"(W)";
	  if (xmint=1) then;do;focpred3=wnames||"(X)";end;
      hasw=1;modgrph=wnames;intprint=1;
      sigintct=sigintct+1;printpbe=intpb[sigintct,1];
    end;
    * end B;
    * start C;
    if ((wcmat[(i+1),jmed]=0) & (zcmat[(i+1),jmed]=1)) then;do;
      numplps=1;modvals=zmodvals;probeval=zmodvals;wheremv1=wherexz;nm1vls=nzvls;
      lpstsp=1||1;jnok=1;jnmod=ztmp;jnmin=zmin;jnmax=zmax;jnmodlab=znames;wherejn1=2;
      if (jmed=1) then;do;
        wherejn3=wherexz[1,i];
        if (nxvls > 1) then;do;jnok=0;end;
      end;
      if (jmed > 1) then;do;wherejn1=wherem[(jmed-1),i];wherejn3=wheremz[((2*jmed)-3),i];end;
      if (nzvls > 1) then;do;probeval=zprobval;lpstsp[1,2]=ncol(probeval);modcat=1;jnok=0;end;
      if (zdich = 1) then;do;modcat=1;jnok=0;end;
      problabs=znames;focpred3=znames||"(Z)"; 
      modgrph=znames;hasz=1;intprint=1;sigintct=sigintct+1;printpbe=intpb[sigintct,1];
    end;
    * end C;
    * start D;
    if ((wzcmat[(i+1),jmed]=1) | ((wcmat[(i+1),jmed]=1) & (zcmat[(i+1),jmed]=1))) then;do;
      numplps=2;probecnt=1;intprint=1;
      if (wzcmat[(i+1),jmed]=1) then;do;sigintct=sigintct+1;printpbe=intpb[sigintct,1];end;
      if (wzcmat[(i+1),jmed]^=1) then;do;sigintct=sigintct+2;
        tempsmal=intpb[(sigintct-1):sigintct,1];
        printpbe=tempsmal[><,]; 
      end;
      panelgrp=1;hasw=1;hasz=1;
      panelcde="/PANEL"||"ROWVAR="||znames||".";modgrph=wnames;
      lpstsp={1 1,1 1};wheremv1=wherexw;nm1vls=nwvls;wheremv2=wherexz;nm2vls=nzvls;jnok=0;
      if (wzcmat[(i+1),jmed]=1) then;do;jnok=1;end;
      if (jmed > 1) then;do;mprobval=mmodvals;end;
      if (jmed=1) then;do;if (nxvls > 1) then;do;jnok=0;end;end;
      if (nwvls > 1) then;do;lpstsp[1,2]=ncol(wprobval);modcat=1;jnok=0;end;
      if (zdich=1) then;do;modcat=1;jnok=0;end;
      lpstsp[2,1]=lpstsp[1,2]+1;lpstsp[2,2]=lpstsp[1,2]+1;
      if (nzvls > 1) then;do;
        lpstsp[2,1]=lpstsp[1,2]+1;lpstsp[2,2]=lpstsp[1,2]+ncol(zprobval);jnok=0;
      end;
      if (zdich=1) then;do;jnok=0;end;
      omni3=j(nrow(b),(nxvls*nwvls),0);
      if (jmed > 1) then;do;omni3=j(nrow(b),nwvls,0);end;
      focpred3=wnames||"(W)";
      focpred4="    "||"Mod var:"||znames||"(Z)"; 
      modvals=j((nrow(wmodvals)*nrow(zmodvals)),2,0);
      probeval=j((nrow(wmodvals)*nrow(zmodvals)),(ncol(wprobval)+ncol(zprobval)),0);
      do probei= 1 to nrow(wmodvals);
        do probej =1 to nrow(zmodvals);
          modvals[probecnt,1]=wmodvals[probei,1];
          probeval[probecnt,1:nwvls]=wprobval[probei,];
          modvals[probecnt,2]=zmodvals[probej,1];
          probeval[probecnt,(nwvls+1):(nwvls+nzvls)]=zprobval[probej,];
          probecnt=probecnt+1;
        end;
      end;
      if (wzcmat[(i+1),jmed]=1) then;do;
        numplps=numplps+1;probprod=j(1,(ncol(wprobval)*ncol(zprobval)),0);
        lpstsp2=1||1;lpstsp=lpstsp//lpstsp2;
        lpstsp[3,1]=lpstsp[2,2]+1;
        lpstsp[3,2]=lpstsp[2,2]+ncol(probprod);
        jnmod=ztmp;jnmin=zmin;jnmax=zmax;jnmodlab=znames;
        if (jmed = 1) then;do;wherejn1=wherexw[1,i];wherejn3=wherexwz[1,i];end;
        if (jmed > 1) then;do;wherejn1=wheremw[((2*jmed)-3),i];wherejn3=wheremwz[((2*jmed)-3),i];end;
        do probei = 1 to nrow(wmodvals);
          do probej = 1 to nrow(zmodvals);
            probtemp=1;
            do probek = 1 to ncol(wprobval);
              probtemp=probtemp||(wprobval[probei,probek]#zprobval[probej,]);
            end;
            probprod=probprod//probtemp[1,2:ncol(probtemp)];
          end;
        end;
        probprod=probprod[2:nrow(probprod),];
        probeval=probeval||probprod;
      end;
      problabs=wnames||znames;
    end;
    * end D;
    * Start E;
    if (intprint=1) then;do;
      focpred="   Focal"||"predict:";
      if (jmed=1) then;do;focpred=focpred||xnames||"(X)";focplotv=xmodvals;end;
      if (jmed >1) then;do;
        if (nms > 1) then;do;focpred=focpred||mnames[1,(jmed-1)]||medlb2[1,(jmed-1)];end;
        if (nms = 1) then;do;focpred=focpred||mnames[1,(jmed-1)]||"(M)";end;
        focplotv=mmodvals[,(jmed-1)];
      end;
      focpred2="    "||"Mod var:"||focpred3;focpred=focpred//focpred2;
      if (ncol(focpred4) > 1) then;do;focpred=focpred//focpred4;focpred4=" ";end;
      if (((plot = 1) | (plot = 2)) | (printpbe <= intprobe)) then;do;
	    if (outscreen=1) then;do;
          print focpred [label="--------------------------"];
		end;
      end;
      foctmp=j(nrow(modvals),1,1);
      probexpl=1;probeva2=foctmp||probeval;
      if ((jmed=1) & (nxs > 0) & (mcx > 0)) then;do;probexpl=nxvls;end;
      foctmp=j(nrow(modvals),1,1);modvals3=j(1,(6+ncol(problabs)),0);probrown=j(nrow(probeval),1,0);jtmp=1;
      do probei = 1 to nrow(probeval);probrown[probei,1]=jtmp;jtmp=jtmp+nxvls;end;
      probrow=999;modvarl=problabs;
      * start F; 
      if ((plot = 1) | (plot = 2) | (nxvls > 1)) then;do;
        plotvals=j((nrow(modvals)*nrow(focplotv)),(ncol(modvals)+1),999);
        do ploti=1 to nrow(modvals);
          do plotj=1 to nrow(focplotv);
            plotvals[(((ploti-1)*nrow(focplotv))+plotj),2:ncol(plotvals)]=modvals[ploti,];
            plotvals[(((ploti-1)*nrow(focplotv))+plotj),1]=focplotv[plotj,1];
          end;
        end;
        focpredn=3;
        if (jmed=1) then;do;
          if (nxvls > 1) then;do;focpredn=(nxvls+1);end;
          if ((nxvls=1) & (xdich=1)) then;do;focpredn=2;end;
        end;
        meanmat=diag(means);
        onesmat=j(nrow(meanmat),(nrow(probeval)*focpredn),1);
        probeplt=(diag(means)*onesmat)`;

        * start G;
        if (jmed=1) then;do;
          if ((wcmat[(i+1),1]=1) | (zcmat[(i+1),1]=1)) then;do;
            plotcnt=1;iloops=nwpval*nzpval;plotmx=nxpval*nzpval;
            if ((wcmat[(i+1),1]=1) & (zcmat[(i+1),1]=0)) then;do;
              iloops=nwpval;plotmx=nxpval;
            end;
            if ((wcmat[(i+1),1]=0) & (zcmat[(i+1),1]=1)) then;do;
              iloops=nzpval;plotmx=nxpval;
            end;
            xestvals=j((nxpval*iloops),ncol(xprobval),-999);
            if (wcmat[(i+1),1]=1) then;do;westvals=j(nrow(xestvals),ncol(wprobval),-999);end;
            if (zcmat[(i+1),1]=1) then;do;zestvals=j(nrow(xestvals),ncol(zprobval),-999);end;
            do ploti=1 to iloops;
              do plotj=1 to nxpval;
                xestvals[plotcnt,]=xprobval[plotj,];plotcnt=plotcnt+1;
              end;
            end;
            plotcnt=1;plotcnt1=1;plotcnt2=1;plotcntz=1;
            do ploti = 1 to (iloops*nxpval);
              if (wcmat[(i+1),1]=1) then;do;westvals[ploti,]=wprobval[plotcnt1,];end;        
              if ((wcmat[(i+1),1]=0) & (zcmat[(i+1),1]=1)) then;do;
                zestvals[ploti,]=zprobval[plotcnt1,];
              end;   
              if ((wcmat[(i+1),1]=1) & (zcmat[(i+1),1]=1)) then;do;
                zestvals[ploti,]=zprobval[plotcnt2,];plotcntz=plotcntz+1;
              end;
              plotcnt=plotcnt+1;
              if (plotcnt > plotmx) then;do;plotcnt=1;plotcnt1=plotcnt1+1;end;
              if (plotcntz > nxpval) then;do;
                plotcnt2=plotcnt2+1;plotcntz=1;
                if (plotcnt2 > nzpval) then;do;plotcnt2=1;end;
              end;
            end;
            probeplt[,2:(1+(ncol(xestvals)))]=xestvals; 
            if (wcmat[(i+1),1]=1) then;do;probeplt[,(wherew[1,i]):(wherew[2,i])]=westvals;end;    
            if (zcmat[(i+1),1]=1) then;do;probeplt[,(wherez[1,i]):(wherez[2,i])]=zestvals;end;  
          end;
        end;

        * end G;
        * start H;
        if (jmed > 1) then;do;
          if ((wcmat[(i+1),jmed]=1) | (zcmat[(i+1),jmed]=1)) then;do;
            plotcnt=1;iloops=nwpval*nzpval;plotmx=3*nzpval;
            if ((wcmat[(i+1),jmed]=1) & (zcmat[(i+1),jmed]=0)) then;do;iloops=nwpval;plotmx=3;end;
            if ((wcmat[(i+1),jmed]=0) & (zcmat[(i+1),jmed]=1)) then;do;iloops=nzpval;plotmx=3;end;
            mestvals=j((3*iloops),1,-999);
            if (wcmat[(i+1),jmed]=1) then;do;westvals=j(nrow(mestvals),ncol(wprobval),-999);end;
            if (zcmat[(i+1),jmed]=1) then;do;zestvals=j(nrow(mestvals),ncol(zprobval),-999);end;
            do ploti=1 to iloops;
               do plotj=1 to 3;
                 mestvals[plotcnt,]=mprobval[plotj,(jmed-1)];
                 plotcnt=plotcnt+1;
               end;
            end;
            plotcnt=1;plotcnt1=1;plotcnt2=1;plotcntz=1;
            do ploti = 1 to (iloops*3);
              if (wcmat[(i+1),jmed]=1) then;do;
                westvals[ploti,]=wprobval[plotcnt1,];
              end;        
              if ((wcmat[(i+1),jmed]=0) & (zcmat[(i+1),jmed]=1)) then;do;
                zestvals[ploti,]=zprobval[plotcnt1,];
              end;   
              if ((wcmat[(i+1),jmed]=1) & (zcmat[(i+1),jmed]=1)) then;do;
                zestvals[ploti,]=zprobval[plotcnt2,];
                plotcntz=plotcntz+1;
              end;
              plotcnt=plotcnt+1;
              if (plotcnt > plotmx) then;do;plotcnt=1;plotcnt1=plotcnt1+1;end;
              if (plotcntz > 3) then;do;plotcnt2=plotcnt2+1;plotcntz=1;
                if (plotcnt2 > nzpval) then;do;plotcnt2=1;end;
              end;
            end;
            probeplt[,wherem[(jmed-1),i]]=mestvals; 
            if (wcmat[(i+1),jmed]=1) then;do;
			   if (model ^= 74) then;do;
                 probeplt[,(wherew[1,i]):(wherew[2,i])]=westvals;
			   end;
			   if (model = 74) then;do;
                 probeplt[,(wherex[1,i]):(wherex[2,i])]=westvals;
			   end;
            end;    
            if (zcmat[(i+1),jmed]=1) then;do;probeplt[,(wherez[1,i]):(wherez[2,i])]=zestvals;end;  
          end;
        end;
        * end H;

        * Here I am doing the multiplications to produce data for the plot ;
        prodloop = 1;
        if (jmed=1) then;do;prodloop=ncol(xestvals);end;
        if (wcmat[(i+1),jmed]=1) then;do;
          plotcnt=0;
          do ploti = 1 to prodloop;
            do plotj = 1 to ncol(westvals);
              if (jmed=1) then;do;probeplt[,(wherexw[1,i]+plotcnt)]=xestvals[,ploti]#westvals[,plotj];end;
              if (jmed > 1) then;do;
                probeplt[,(wheremw[((jmed*2)-3) ,i]+plotcnt)]=mestvals[,ploti]#westvals[,plotj];
              end;
              plotcnt=plotcnt+1;
            end;
          end; 
        end;
        if (zcmat[(i+1),jmed]=1) then;do;
          plotcnt=0;
          do ploti = 1 to prodloop;
            do plotj = 1 to ncol(zestvals);
              if (jmed = 1) then;do;
                probeplt[,(wherexz[1,i]+plotcnt)]=xestvals[,ploti]#zestvals[,plotj];
              end;
              if (jmed > 1) then;do;
                probeplt[,(wheremz[((jmed*2)-3),i]+plotcnt)]=mestvals[,ploti]#zestvals[,plotj];
              end;
              plotcnt=plotcnt+1;
            end;
          end; 
        end;
        if (wzcmat[(i+1),jmed]=1) then;do;plotcnt=0;threeway=1;
          do ploti = 1 to ncol(westvals);
            do plotj = 1 to ncol(zestvals);
              probeplt[,(wherewz[1,i]+plotcnt)]=westvals[,ploti]#zestvals[,plotj];plotcnt=plotcnt+1;
            end;
          end; 
          plotcnt=0;
          do plotk = 1 to prodloop;
            do ploti = 1 to ncol(westvals);
              do plotj = 1 to ncol(zestvals);
                if (jmed = 1) then;do;
                  probeplt[,(wherexwz[1,i]+plotcnt)]=xestvals[,plotk]#westvals[,ploti]#zestvals[,plotj];
                end;
                if (jmed > 1) then;do;
                  probeplt[,(wheremwz[((jmed*2)-3),i]+plotcnt)]=mestvals[,plotk]#westvals[,ploti]#zestvals[,plotj];
                end;
                plotcnt=plotcnt+1;
              end;
            end; 
          end;
        end;
        * here is where we add holding constant products as needed when generating data for plotting;
		
        * start I;
        do newplp=1 to i;
          if (newplp ^= jmed) then;do;
            if (wcmat[(i+1),newplp]=1) then;do;prodloop=1;
              if (newplp=1) then;do;prodloop=nxvls;end;
              plotcnt=0;
              do ploti = 1 to prodloop;
                do plotj = 1 to nwvls;
                  if (newplp = 1) then;do;
                    probeplt[,(wherexw[1,i]+plotcnt)]=probeplt[,(1+ploti)]#probeplt[,(wherew[1,i]+plotj-1)];
                  end;
                  if (newplp > 1) then;do;
				    if (model ^= 74) then;do;
                      probeplt[,(wheremw[((newplp*2)-3) ,i]+plotcnt)]=probeplt[,(wherem[(newplp-1),i])]#probeplt[,(wherew[1,i]+plotj-1)];
					end;
					if (model=74) then;do;
					  probeplt[,(wheremw[((newplp*2)-3) ,i]+plotcnt)]=probeplt[,(wherem[(newplp-1),i])]#probeplt[,(wherex[1,i]+plotj-1)];
					end;
                  end;
                  plotcnt=plotcnt+1;
                end;
              end; 
            end;
 
            if (zcmat[(i+1),newplp]=1) then;do;prodloop=1;
              if (newplp=1) then;do;prodloop=nxvls;end;
              plotcnt=0;
              do ploti = 1 to prodloop;
                do plotj = 1 to nzvls;
                  if (newplp = 1) then;do;
                    probeplt[,(wherexz[1,i]+plotcnt)]=probeplt[,(1+ploti)]#probeplt[,(wherez[1,i]+plotj-1)];
                  end;
                  if (newplp > 1) then;do;
                    probeplt[,(wheremz[((newplp*2)-3),i]+plotcnt)]=probeplt[,(wherem[(newplp-1),i])]#probeplt[,(wherez[1,i]+plotj-1)];
                  end;
                  plotcnt=plotcnt+1;
                end;
              end; 
            end;
            if (wzcmat[(i+1),newplp]=1) then;do;plotcnt=0;
              if (threeway=0) then;do;
                do ploti = 1 to nwvls;
                  do plotj = 1 to nzvls;
                    probeplt[,(wherewz[1,i]+plotcnt)]=probeplt[,(wherew[1,i]+ploti-1)]#probeplt[,(wherez[1,i]+plotj-1)];
                    plotcnt=plotcnt+1;
                  end;
                end;
              end; 
              prodloop=1;
              if (newplp=1) then;do;prodloop=nxvls;end;
              plotcnt=0;
              do plotk = 1 to prodloop;
                do ploti = 1 to nwvls;
                  do plotj = 1 to nzvls;
                    if (newplp = 1) then;do;
                      probeplt[,(wherexwz[1,i]+plotcnt)]=probeplt[,(1+plotk)]#probeplt[,(wherew[1,i]+ploti-1)]#probeplt[,(wherez[1,i]+plotj-1)];
                    end;
                    if (newplp > 1) then;do;
                      probeplt[,(wheremwz[((newplp*2)-3),i]+plotcnt)]=probeplt[,wherem[(newplp-1),i]]#probeplt[,(wherew[1,i]+ploti-1)]#probeplt[,(wherez[1,i]+plotj-1)];
                    end;
                    plotcnt=plotcnt+1;
                  end;
                end; 
              end;
            end;
          end;
        end;
        * END I;






        predvals=probeplt*b;
		if ((i = (nms+nys)) & (ydich=1)) then;do;
		  predvalt=(predvals < 709.7);prevalt7=(1-predvalt)*709.7;
		  predvals=(predvals#predvalt)+prevalt7;
          expyhat=exp(predvals)/(1+exp(predvals));
		end;
        sepred=j(nrow(plotvals),3,999);
        do sei=1 to nrow(plotvals);
          ask=probeplt[sei,];       
          sepred[sei,1]=sqrt(ask*varb*ask`);
		  if ((i < (nms+nys)) | (ydich=0)) then;do;
            sepred[sei,2]=predvals[sei,1]-tval*sepred[sei,1];
            sepred[sei,3]=predvals[sei,1]+tval*sepred[sei,1];
		  end;
		  if ((i=(nms+nys)) & (ydich=1)) then;do;
            sepred[sei,2]=predvals[sei,1]-xp2*sepred[sei,1];
            sepred[sei,3]=predvals[sei,1]+xp2*sepred[sei,1];
          end;
        end;
        prevloc=ncol(plotvals)+1;
        probeplt=plotvals||predvals;
        if (plot = 2) then;do;probeplt=probeplt||sepred;end;
		if ((i=(nms+nys)) & (ydich=1)) then;do;
		  probeplt=probeplt||expyhat;
		end;
        didsome=0;
      end;
      * END F;
      * here is the loop that is printing the conditional effects;
      * this does conditional two way interactions;
      * start J;
      if ((wzcmat[(i+1),jmed]=1) & (printpbe <= intprobe)) then;do;
        if (jmed=1) then;do;omnilp2=nxvls*nwvls;omnitmp=I(omnilp2);omni3[wherexw[1,i]:wherexw[2,i],]=omnitmp;end;
        if (jmed>1) then;do;omnilp2=nwvls;omnitmp=I(omnilp2);
          omni3[wheremw[((jmed*2)-3),i]:wheremw[((jmed*2)-2),i],]=omnitmp;
        end;
        omnif=j(1,4,0);
        if ((i=(nms+nys)) & (ydich=1)) then;do;omnif=j(1,3,0);end;
        condeff3=0;
        do omnilp1=1 to nrow(zprobval);
          do omnilp=1 to (omnilp2);
            if (jmed=1) then;do;
              omni3[(wherexwz[1,i]+((omnilp-1)*nzvls)):(wherexwz[1,i]+((omnilp-1)*nzvls)+(nzvls-1)),omnilp]=(zprobval[omnilp1,])`;
            end;
            if (jmed > 1) then;do;
              omni3[(wheremwz[((jmed*2)-3),i]+((omnilp-1)*nzvls)):(wheremwz[((jmed*2)-3),i]+((omnilp-1)*nzvls)+(nzvls-1)),omnilp]=(zprobval[omnilp1,])`;
            end;
          end;
          condeff=omni3`*b;
          condeff3=condeff3//condeff;
          %ftest3 (lm=omni3,bcoef=b,cv=varb,skip=1);
          omnif=omnif//fresult;
        end;
        omnif=omnif[2:nrow(omnif),];clabtmp=znames;condeff3=condeff3[2:nrow(condeff3),];
        if ((nxvls*nwvls)=1) then;do;omnif=condeff3||omnif;clabtmp=clabtmp||"Effect";end; 
        omnif=zmodvals||omnif;
		if ((i < (nms+nys)) | (ydich=0)) then;do;
          clabtmp=clabtmp||hcflab||"df1"||"df2"||"p";
		end;
        if ((i=(nms+nys)) & (ydich=1)) then;do;
		  clabtmp=clabtmp||"Chi-sq"||"df"||"p";
        end; 
		%outform3 (outtodo=omnif,outbig=maxresm);	
		rlabtmp=" ";
        if (jmed=1) then;do;
		  if (outscreen=1) then;do;
            print omnif [label="Test of conditional X*W interaction at value(s) of Z:" rowname=rlabtmp colname=clabtmp format=&decimals];
		  end;
        end;
        if (jmed>1) then;do;
		  if (outscreen=1) then;do;
            print omnif [label="Test of conditional M*W interaction at value(s) of Z:" rowname=rlabtmp colname=clabtmp format=&decimals];
		  end;
        end;
      end;
      * end J;
      * start O;
      do probei = 1 to probexpl;
        if (probexpl > 1) then;do;
          foctmp=j(nrow(modvals),probexpl,0);
          foctmp[,probei]=foctmp[,probei]+1;
          probtemp=j(nrow(modvals),1,0);
          do probem = 1 to numplps;
            do probek = 1 to nxvls;
              do probej=lpstsp[probem,1] to lpstsp[probem,2];
                probtemp=probtemp||(foctmp[,probek]#probeval[,probej]);
              end;
            end;
          end;
          probeva2=probtemp[,2:ncol(probtemp)];
          probeva2=foctmp||probeva2;
        end;    
        probres=probeva2*probcoef;
        probrese=sqrt(vecdiag(probeva2*probvarb*probeva2`));  
        tratio = probres/probrese;
        p = 2*(1-probt(abs(tratio), dfres));
		if ((ydich=1) & (i=(nms+nys))) then;do;
		  p=2*(1-probnorm(abs(tratio)));
		end;
        modvals2=modvals||probres||probrese||tratio||p;
        if ((i < (nms+nys)) | (ydich=0)) then;do;
          modvals2=modvals2||(probres-tval#probrese)||(probres+tval#probrese);   
          problabs=problabs||"Effect"||hclab||"t"||"p"||"LLCI"||"ULCI";        
		end;
        if ((i = (nms+nys)) & (ydich=1)) then;do;
          modvals2=modvals2||(probres-xp2#probrese)||(probres+xp2#probrese);   
          problabs=problabs||"Effect"||"se"||"Z"||"p"||"LLCI"||"ULCI";        
		end;
        * start L;
        if ((probexpl > 1) & (printpbe <= intprobe)) then;do;
          if (hasz = 1) then;do;printz=1;end;
          if (hasw=1) then;do;printw=1;end;
          probrlab=j(nrow(modvals),1,xcatlab[probei,1]);
          modvals3=modvals3//modvals2;probrow=probrow//probrown;probrown=probrown+1;
          if (probei=probexpl) then;do;
            xproblab=xcatlab[1:nxvls,1];probrow=probrow[2:nrow(probrow),1];
            modvals3=modvals3[2:nrow(modvals3),];
            temp=modvals3;temp[rank(probrow[,1]),]=modvals3;modvals3=temp;
            start2=1;problabs=problabs[1,(1+(ncol(modvarl))):ncol(problabs)];pstart=1;
            * start K;
            do probek= 1 to nrow(probeval);
              endstart=start2+(nxvls-1);
              temp=modvals3[start2:endstart,(1+ncol(modvarl)):ncol(modvals3)];
              temp2=(modvals3[start2:start2,1:ncol(modvarl)])`;trnames=modvarl`;
              if (probek > 1) then;do;if (outscreen=1) then;do;print "-------";end;end;
			  if (probek <= 1) then;do;
			    if (outscreen=1) then;do;
                  print "Conditional effects of the focal predictor at values of the moderator(s):";
				end;
                if ((jmed=1) & (i = (nms+nys)) & (nms > 0)) then;do;
                  if (nxvls = 1) then;do;
				    if (outscreen=1) then;do;
                      print "(These are also the conditional direct effects of X on Y)";
					end;
				  end;
                  if (nxvls ^= 1) then;do;
				    if (outscreen=1) then;do;
                      print "(These are also the relative conditional direct effects of X on Y)";
					end;
                  end;
                end;
              end;
			  if (outscreen=1) then;do;
                print temp2 [label = "Moderator value(s):" rowname=trnames format=&decimals];
			  end;
			  %outform3 (outtodo=temp2,outbig=maxresm);
			  if (outscreen=1) then;do;
                print temp [label=" " colname=problabs rowname=xproblab format=&decimals];
			  end;
			  %outform3 (outtodo=temp,outbig=maxresm);
              start2=start2+nxvls;didsome=1;
              if (jmed=1) then;do;
                mod1val=probeval[probek,1:nm1vls];
                do omnilp=1 to nxvls;
                  omni[(wheremv1[1,i]+((omnilp-1)*nm1vls)):(wheremv1[1,i]+((omnilp-1)*nm1vls)+(nm1vls-1)),omnilp]=mod1val`;
                  if (nm1vls < ncol(probeval)) then;do;
                    mod2val=probeval[probek,(nm1vls+1):(nm1vls+nm2vls)];
                    omni[(wheremv2[1,i]+((omnilp-1)*nm2vls)):(wheremv2[1,i]+((omnilp-1)*nm2vls)+(nm2vls-1)),omnilp]=mod2val`;
                    if ((nm1vls+nm2vls) < ncol(probeval)) then;do;
                      intlen=nm1vls*nm2vls;
                      modintvl=probeval[probek,(nm1vls+nm2vls+1):ncol(probeval)];
                      omni[(wherexwz[1,i]+((omnilp-1)*intlen)):(wherexwz[1,i]+((omnilp-1)*intlen)+(intlen-1)),omnilp]=modintvl`;
                    end;
                  end;
                end;
                %ftest3 (lm=omni,bcoef=b,cv=varb,skip=1);
				%outform3 (outtodo=fresult,outbig=maxresm);	
				if ((i<(nms+nys)) | (ydich=0)) then;do;
                  clabtmp=hcflab||"df1"||"df2"||"p";
				  if (outscreen=1) then;do;
                    print fresult [label="Test of equality of conditional means" colname=clabtmp format=&decimals];
				  end;
				end;
				if ((i = (nms+nys)) & (ydich=1)) then;do;
                  clabtmp="Chi-sq"||"df"||"p";
				  if (outscreen=1) then;do;
                    print fresult [label="Test of equality of conditional logits or probabilities" colname=clabtmp format=&decimals];
				  end;
                end;
                probetmp=probeplt[pstart:(pstart+nxvls),1];
                probetmp=probetmp||probeplt[pstart:(pstart+nxvls),prevloc:ncol(probeplt)];
                pstart=pstart+(nxvls+1);
				%outform3 (outtodo=probetmp,outbig=maxresm);	
				if ((i < (nms+nys)) | (ydich=0)) then;do;
                  clabtmp=xnames||outnames[1,i]||hclab||"LLCI"||"ULCI";
				  if (outscreen=1) then;do;
                    print probetmp [label = "Estimated conditional means being compared:" colname=clabtmp format=&decimals];
				  end;
				end;
				if ((i = (nms+nys)) & (ydich=1)) then;do;
                  clabtmp=xnames||outnames[1,i]||"prob";
				  probetm2=probetmp[,1:2];
				  probetm2=probetm2||probetmp[,ncol(probetmp)];
				  if (outscreen=1) then;do;
                    print probetm2 [label = "Estimated conditional logits and probabilities:" colname=clabtmp format=&decimals];
				  end;
				end;
              end;
            end;
            * end K;          
          end;
        end;
        * end L;
        * start N;
        if (probexpl = 1 & (printpbe <= intprobe)) then;do;
		  %outform3 (outtodo=modvals2,outbig=maxresm);
		  if (outscreen=1) then;do;
            print "Conditional effects of the focal predictor at values of the moderator(s):";		  
            print modvals2 [label=" " colname=problabs format=&decimals];
		  end;
          didsome=1;
          if (hasz = 1) then;do;printz=1;end;
          if (hasw=1) then;do;printw=1;end;
          * start M;
          if ((jn = 1) & (jnok=1)) then;do;
            if (criterr=0) then;do;
              *dfres=n-nrow(b);
              roots=99999;
              *jncrit =(dfres*(exp((dfres-(5/6))*((xp2/(dfres-(2/3)+(.11/dfres)))*(xp2/(dfres-(2/3)+(.11/dfres)))))-1));
			  jncrit=(-quantile('t',alpha2,dfres))##2;
              if ((i=(nms+nys)) & (ydich=1)) then;do;
                jncrit=xp2*xp2;
			  end;
              jnb1=b[wherejn1,1];jnb3=b[wherejn3,1];
              jnsb1=varb[wherejn1,wherejn1];jnsb3=varb[wherejn3,wherejn3];
              jnsb1b3=varb[wherejn1,wherejn3];
              ajn =(jncrit*jnsb3)-(jnb3*jnb3);bjn = 2*((jncrit*jnsb1b3)-(jnb1*jnb3));cjn = (jncrit*jnsb1)-(jnb1*jnb1);
              radarg = (bjn*bjn)-(4*ajn*cjn);den = 2*ajn;nrts=0;
              if ((radarg >= 0) & (den ^= 0)) then;do;
                x21 = (-bjn+sqrt(radarg))/den;x22 = (-bjn-sqrt(radarg))/den;roots = 0;
                if ((x21 >= jnmin) & (x21 <= jnmax)) then;do;nrts=1;roots = roots//x21;end;
                if ((x22 >= jnmin) & (x22 <= jnmax)) then;do;nrts=nrts+1;roots=roots//x22;end;
                roots=roots||j(nrow(roots),2,0);
              end;
              if (nrts > 0) then;do;                           
                roots = roots[2:nrow(roots),1:3];
				tmproot=(jnmod < roots[1,1]);
                roots[1,2]=(tmproot[+,]/n)*100;
				tmproot=(jnmod > roots[1,1]);
                roots[1,3]=(tmproot[+,]/n)*100;
                if (nrow(roots)=2) then;do;
				  tmproot=(jnmod < roots[2,1]);
                  roots[2,2]=(tmproot[+,]/n)*100;
				  tmproot=(jnmod > roots[2,1]);
                  roots[2,3]=(tmproot[+,]/n)*100;
                end;				
                colntmp="Value"||"% below"||"% above";
				if (outscreen=1) then;do;
                  print roots [label = "Moderator value(s) defining Johnson-Neyman significance region(s):" colname=colntmp format=&decimals];
				end;
				if (nrts=1) then;do;tmprts=j(1,3,99999);roots=roots//tmprts;end;
              end;
              if (nrts = 0) then;do;
			    roots=j(2,1,99999);
			    if (outscreen=1) then;do;
                  print "There are no statistical significance transition points within the observed";
                  print "range of the moderator found using the Johnson-Neyman method.";
				end;
              end;
			  %outform3 (outtodo=roots,outbig=maxresm);	
              jnvals=j(23,7,0);
              do jni= 0 to (21-nrts);jnvals[(jni+1),1]=jnmin+(jni*((jnmax-jnmin)/(21-nrts)));end;
              if (nrts > 0) then;do;
                do jni = 1 to nrts;
                  do jnj = 2 to (nrow(jnvals)-1);
                    if ((roots[jni,1] > jnvals[(jnj-1),1]) & (roots[jni,1] < jnvals[jnj,1])) then;do;
                      jnvals[(jnj+1):(21+jni),1]=jnvals[jnj:(20+jni),1];
                      jnvals[jnj,1]=roots[jni,1];
                    end;
                  end;
                end;
              end; 
			  jnvals=jnvals[1:22,];
              do jni = 1 to nrow(jnvals);
                jnvals[jni,2]=jnb1+jnb3*jnvals[jni,1];
                jnvals[jni,3]=sqrt(jnsb1+2*jnvals[jni,1]*jnsb1b3+(jnvals[jni,1]*jnvals[jni,1])*jnsb3);
                jnvals[jni,4]=jnvals[jni,2]/jnvals[jni,3];
                jnvals[jni,5]=2*(1-probt(abs(jnvals[jni,4]), dfres));
                jnvals[jni,6]=jnvals[jni,2]-sqrt(jncrit)*jnvals[jni,3];
                jnvals[jni,7]=jnvals[jni,2]+sqrt(jncrit)*jnvals[jni,3];
				if ((i=nms+nys) & (ydich=1)) then;do;
				  jnvals[jni,5]=2*(1-probnorm(abs(jnvals[jni,4])));
				  jnvals[jni,6]=jnvals[jni,2]-xp2*jnvals[jni,3];
                  jnvals[jni,7]=jnvals[jni,2]+xp2*jnvals[jni,3];
				end;
              end; 
			  %outform3 (outtodo=jnvals,outbig=maxresm);
			  if ((i < (nms+nys)) | (ydich=0)) then;do;
                jnclbs=jnmodlab||"Effect"||hclab||"t"||"p"||"LLCI"||"ULCI";
              end;
			  if ((i = (nms+nys)) & (ydich=1)) then;do;
                jnclbs=jnmodlab||"Effect"||"se"||"Z"||"p"||"LLCI"||"ULCI";
			  end;
              jnrlbs=" ";
			  if (outscreen=1) then;do;
                if (((wcmat[(i+1),jmed]=1) | (zcmat[(i+1),jmed]=1)) & (wzcmat[(i+1),jmed]=0)) then;do;
                  print jnvals [label = "Conditional effect of focal predictor at values of the moderator:" rowname=jnrlbs colname =jnclbs format = &decimals];
                end;
                if ((jmed = 1) & (wzcmat[(i+1),jmed]=1)) then;do;
                  print jnvals [label = "Conditional X*W interaction at values of the moderator Z:" rowname=jnrlbs colname =jnclbs format = &decimals];
                end;
                if ((jmed > 1) & (wzcmat[(i+1),jmed]=1)) then;do;
                  print jnvals [label = "Conditional M*W interaction at values of the moderator Z:" rowname=jnrlbs colname =jnclbs format = &decimals];
                end;
			  end;
            end;
          end;
          * END M;
        end;
        * END N;
        if ((i = (nms+nys)) & (jmed=1) & (bcmat[nrow(bcmat),1]=1)) then;do;
          if (probei=1) then;do;direfflb=problabs;direff=modvals2;end;
          if (probei>1) then;do;direff=direff//modvals2;end;  
        end;
        intprint=0;
        * This does the contrast for conditional effects;
        if (((jmed=1) & (i=1) & (nms=0)) & (modcok=1)) then;do;
          contvec2=j(2,1,1);
          contvec2=contvec2||wcontval||zcontval;
          if (wzcmat[(i+1),jmed]=1) then;do;
            do conti= 1 to ncol(wcontval);
              do contj = 1 to ncol(zcontval);
                contvec2=contvec2||wcontval[,conti]#zcontval[,contj];
              end;
            end;
          end;
          conteff=contvec2*probcoef;
          contdiff=contvec2[1,]-contvec2[2,];
          contse=sqrt(contdiff*probvarb*contdiff`);
          conteffd=conteff[1,1]-conteff[2,1];
          contvec=contvec||conteff;
		  contvecm=contvec;
		  %outform3 (outtodo=contvecm,outbig=maxresm);	
		  if (outscreen=1) then;do;
            print "Contrast between conditional effects of X:";
		  end;
		  rwnmtmp="Effect1:"||"Effect2:";
          print contvec [label=" " rowname=rwnmtmp colname=problabs format = &decimals];
		  if (ydich=0) then;do;
            p=2*(1-probt(abs(conteffd/contse), dfres));
            contvec=conteffd||contse||conteffd/contse||p;
            contvec=contvec||(conteffd-(tval*contse));
            contvec=contvec||(conteffd+(tval*contse));
            contlabs="Contrast"||hclab||"t"||"p"||"LLCI"||"ULCI";
		  end;
		  if (ydich=1) then;do;
            p=2*(1-probnorm(abs(conteffd/contse)));
            contvec=conteffd||contse||conteffd/contse||p;
            contvec=contvec||(conteffd-(xp2*contse));
            contvec=contvec||(conteffd+(xp2*contse));
            contlabs="Contrast"||"se"||"Z"||"p"||"LLCI"||"ULCI";
		  end;
		  %outform3 (outtodo=contvec,outbig=maxresm);	
		  if (outscreen=1) then;do;
            print contvec [label="Test of Effect1 minus Effect2" format=&decimals colname=contlabs];
		  end;
        end;
      end;
      *end O;
      if ((plot = 1) | (plot = 2)) then;do;
        datalabs=(focpred[,3])`||outnames[1,i];
        if (plot = 1) then;do;datalabs=datalabs;end;
        if (plot = 2) then;do;datalabs=datalabs||"se"||"LLCI"||"ULCI";end;
		if ((i=(nms+nys)) & (ydich=1)) then;do;
		  datalabs=datalabs||"prob";
		end;
		%outform3 (outtodo=probeplt,outbig=maxresm);
        dumb = " "||" "||" "||" "||" "||" "||" ";
		if (outscreen=1) then;do;
		  print "Data for visualizing the conditional effect of the focal predictor:";
          print probeplt [label=" " colname=datalabs format=&decimals];
		end;
        focgrph=datalabs[1,1];
        graphix=focgrph||graphixs||modgrph;
        if (((xdich=1) | (nxvls > 1)) & (modcat=0)) then;do;
          graphix=modgrph||graphixs||focgrph;     
        end;
        if (panelgrp = 0) then;do;graphix=graphix||".";end;
        if (panelgrp ^=0) then;do;graphix=graphix||panelcde;end;
      end;  
    end;
    * end E;
  end;
  *end R;  
end;
* this is the end of the probing macro;

if (model=74) & (i <=nms) then;do;
  onetemp=j(nrow(xprobval),1,1);
  mestmt74=onetemp||xprobval;
  if (ncs > 0) then;do;
    ncovmdlt=ccmat[i,];ncovmdl=ncovmdlt[,+];
    if (ncovmdl > 0) then;do;
      cvmnc=j(nrow(mestmt74),ncovmdl,1);
      cvmnctmp=x[+,(ncol(x)-ncovmdl+1):ncol(x)]/nrow(x); 
	  if (cuscoval > 0) then;do;cvmnctmp=coval;end; 
	  do mestlp=1 to ncovmdl;
	    cvmnc[,mestlp]=cvmnc[,mestlp]*cvmnctmp[,mestlp];
	  end;
	  mestmt74=mestmt74||cvmnc;
	end;
  end;
  mest74t=mestmt74*b;
  if (i=1) then;do;mest74=mest74t;end;
  if (i>1) then;do;mest74=mest74||mest74t;end;
end;



* linear combination; 
  if ((i=(nms+nys)) & (model >=0 & model < 4) & (linsum[1,1] ^= 999)) then;do;
    lhyprob=1;meansub=0;covsubok=0;
    if (nlinsum=nrow(b)) then;do;lhyprob=0;end;
    if ((nlinsum = (nrow(b)-ncs)) & (ncs > 0) & (model ^= 0)) then;do;
	  lhyprob=0;covsubok=1;covmean2=covmeans;
    end;
    if ((nlinsum = (nrow(b)-ncs+xfakecov)) & (model = 0) & (lhyprob=1)) then;do;
	  covmean2=covmeans[1,(xfakecov+1):ncol(covmeans)];covsubok=1;lhyprob=0;
    end;
    if (lhyprob=0) then;do;
      if (covsubok=1) then;do;linsum=linsum||covmean2;meansub=1;end;
      hypest=linsum*b;
	  sehypest=sqrt(linsum*varb*linsum`);
	  if (ydich=0) then;do;
	    phypest = 2*(1-probt(abs(hypest/sehypest),(dfres)));
        hypest=hypest||sehypest||(hypest/sehypest)||phypest||(hypest-tval*sehypest)||(hypest+tval*sehypest);
      end;
	  if (ydich=1) then;do;
	    phypest = 2*(1-probnorm(abs(hypest/sehypest)));
        hypest=hypest||sehypest||(hypest/sehypest)||phypest||(hypest-xp2*sehypest)||(hypest+xp2*sehypest);
	  end;
	  %outform3 (outtodo=linsum`,outbig=maxresm);
	  %outform3 (outtodo=hypest,outbig=maxresm);
      if (outscreen=1) then;do;
	    hyplabs="Estimate"||hclab||"t"||"p"||"LLCI"||"ULCI";
	    if (ydich=1) then;do;
          hyplabs="Estimate"||"se"||"Z"||"p"||"LLCI"||"ULCI";
		end;
	    linsum=linsum`;
	    print "--------------------------";
	    print "Linear Combination Estimate and Hypothesis Test";
        print linsum [label="Weight vector:" rowname=vlabsm format=&decimals];
	    print hypest [label=" " colname=hyplabs format=&decimals];
        if (meansub=1) then;do;
          print "Covariate weight(s) set to the sample mean";
        end;
      end;
    end; 
    if (lhyprob=1) then;do;notecode[notes,1] = 30;notes=notes+1;end;
  end;

  if (((subsets=1) | (dominate=1)) & (model=0) & (ydich=0)) then;do;     
    numbx=ncol(x)-nxvls;
    subdomin=1;
    if ((numbx < 2) | (numbx > 15)) then;do;
      notecode[notes,1]=40;notes=notes + 1;subdomin=0;dominate=0;
    end;
    if (subdomin=1) then;do;
      rsqrmat = j(((2##numbx)-1),numbx+2,0);
      dommat=j(numbx,numbx,0);
      desc5x=corall[2:(numbx+nxvls),2:(numbx+nxvls)];
	  allcomp=(2##(numbx-2));
      domx=j(1,numbx,0);
      domx2=j(1,(numbx+(nxvls-1)),0);
      do jss = 1 to ((2##numbx)-1);
        domx[1,1]=domx[1,1]+1;
        do iss = 1 to numbx;
          if (domx[1,iss]=2) then;do;
            domx[1,iss]=0;
            domx[1,(iss+1)]=domx[1,(iss+1)]+1;
          end;
        end;
        rsqrmat[jss,1:(ncol(rsqrmat)-2)]=domx;
        xdumsone=j(1,nxvls,0);
        if (domx[1,1]=1) then;do;xdumsone=j(1,nxvls,1);end;
        domx2=xdumsone||domx[1,2:ncol(domx)];
        rii=(domx2`*domx2)#desc5x;
        bin=j(1,(numbx+nxvls-1),0);
        do ksss = 1 to (numbx+nxvls-1);
          rii[ksss,ksss]=1;
          bin[1,ksss]=2##(ksss-1);
        end;
        riy=corall[1,2:(numbx+nxvls)]#domx2;
		rsqtmp=(riy*inv(rii)*riy`);
        rsqrmat[jss,numbx+1]=rsqtmp;
		rsqrmat[jss,numbx+2]=1-((1-rsqtmp)*(n1-1)/(n1-(domx[,+]+(domx[1,1]*(nxvls-1))+1)));
        rsqrmat[jss,1:numbx]=domx;
      end;
      temp=rsqrmat; 
      temp[rank(rsqrmat[,(ncol(rsqrmat)-0)]),]=rsqrmat;
      rsqrmats=temp; 
      ssvlabs=varnames[1,2:ncol(varnames)]||"R-sq"||"Adj R-sq";
	  if (subsets=1) then;do;
        %outform3 (outtodo=rsqrmats,outbig=maxresm);
        if (outscreen=1) then;do;
		  ssvlabsc=j(nrow(rsqrmats),1," ");
          print rsqrmats [label="All subsets regression results" colname=ssvlabs rowname=ssvlabsc format=&decimals];
        end;
	  end;
    end;

    if (dominate = 1) then;do;
      do idmt = 1 to (numbx-1);
        do jdmt = (idmt+1) to numbx;
          critdiff=bin[1,jdmt]-bin[1,idmt];
	      do kdmt = 1 to nrow(rsqrmat);
	        if ((rsqrmat[kdmt,idmt]=1) & (rsqrmat[kdmt,jdmt]=0)) then;do;
	          tmps=rsqrmat[kdmt,(numbx+1)]||rsqrmat[(kdmt+critdiff),(numbx+1)];
		      if (tmps[1,1] > tmps[1,2]) then;do;
		        dommat[idmt,jdmt]=dommat[idmt,jdmt]+1;
		      end;
		      if (tmps[1,1] < tmps[1,2]) then;do;
		        dommat[jdmt,idmt]=dommat[jdmt,idmt]+1;
		      end;
	        end;
	      end;
        end;
      end;
      dommat=dommat/allcomp;
	  dovlabs=varnames[1,2:ncol(varnames)];
	  %outform3 (outtodo=dommat,outbig=maxresm);
	  if (outscreen=1) then;do;
        *print "******************************************************************************";
        print dommat [label="Dominance matrix" colname=dovlabs rowname=dovlabs format=6.3];
	  end;
    end;
  end;
  if (diagnose=1) then;do;
    if (ydich=0) then;do;
      %outform3 (outtodo=maxnmin,outbig=maxresm);
	  %outform3 (outtodo=skewres,outbig=maxresm);
      %outform3 (outtodo=bp,outbig=maxresm);
	  %outform3 (outtodo=wadf,outbig=maxresm);
      tolstat=tolstat||(1/tolstat);    
      %outform3 (outtodo=tolstat,outbig=maxresm);
      %outform3 (outtodo=bpresult,outbig=maxresm);         
      if (outscreen=1) then;do;
        print "-----------";
        print "Some regression diagnostics";
		maxnminr="fitted"||"residual"||"t-resid";maxnminc="Min."||"Max.";
        print maxnmin [label=" " rowname=maxnminr colname=maxnminc format=&decimals];
		skewresr="Value"||"se";
        skewresc="Skewness"||"Kurtosis";
		print skewres [label="Shape of residuals" rowname=skewresr colname=skewresc format=&decimals];
		bplabss="t-resid"||"p-value"||"Casenum";
        print bp [label = "Bonferroni-corrected p for largest t-residual" colname=bplabss format=&decimals];
        wadfclab="casenum"||"dfbeta";
        print wadf [label="Most influential observations" colname=wadfclab rowname=vlabsm format=&decimals]; 
		tolvnm=vlabsm[2:nrow(vlabsm),1];
        tolcnm="Tol."||"VIF"; 
        print tolstat [label="Variable tolerance and VIF" rowname=tolvnm colname=tolcnm format=&decimals];
		bprlabs="Normal"||"Robust";bpclabs="Chi-sq"||"df"||"p";
		print bpresult [label="Breusch-Pagan test of heteroskedasticity" colname=bpclabs rowname=bprlabs format=&decimals];
      end;
    end;
  end; 

  end;

  end; *end of G loop;
  if ((criterr=0)) then;do;
    lastb=b;lastcov=varb;
  end;
  if ((criterr=0) & (dototal = 1)) then;do;
    x=xtmp;
    releiv=1||relx;
    vlabsm="CONSTANT"//xcatlab[1:nxvls,1];
    if (ncs > 0) then;do;x=x||ctmp;vlabsm=vlabsm//covnames`;releiv=releiv||relcov;end;
    x = ones||x;
    %modeles3 (y=y,x=x,type=1,full=1);
	if (criterr=0) then;do;
  	  toteff=modres[2:(1+nxvls),];
      nodotot=0;
      if ((xdich=1) & (xmint=1) & (model=74)) then;do;
        toteff[,1]=toteff[,1]*xscaling;
        toteff[,2]=toteff[,2]*abs(xscaling);
        toteff[,3]=toteff[,3]*xscaling;
        toteff[,5]=toteff[,5]*xscaling;
        toteff[,6]=toteff[,6]*xscaling;
        citmp=toteff[,5:6];
        if (xscaling < 0) then;do;
          toteff[,5]=citmp[,2];toteff[,6]=citmp[,1];
        end;
        nodotot=1;
      end;
      totefflb=modresl;toteffl2=vlabsm[2:(1+nxvls),];
      outnmtmp=outnames[1,ncol(outnames)];
      if (outscreen=1) then;do;
	    if (nodotot=0) then;do;
          print "********************************** TOTAL EFFECT MODEL ************************************";
        end;
	    if (eivdo=1) then;do;
	      print "                            Errors-in-variables regression";
	    end;
  	    if (nodotot=1) then;do;
          print "******************************************************************************************";
        end;	
        print outnmtmp [label = "OUTCOME VARIABLE:"];
	  end;
      %outform3 (outtodo=modsum,outbig=maxresm);
	  if (outscreen=1) then;do;
        print modsum [label = "Model Summary" colname = modsuml format=&decimals];
	  end;
      if ((ydich=0) | (i < (nms+nys))) then;do;
  	    if (crossv=1) then;do;
	      %outform3 (outtodo=crossr,outbig=maxresm);
	      if (outscreen=1) then;do;
            crossvcl="Browne"||"LvOut1"||"LvOut2";
	        print crossr [label="Shrunken R estimates" colname=crossvcl format=&decimals]; 
	  	  end;
	    end;
	    if (ssquares=1) then;do;
	      %outform3 (outtodo=sumtable,outbig=maxresm);
	      if (outscreen=1) then;do;
	        sumtablr="Regress"||"Residual"||"Total";
  		    sumtablc="SS"||"df"||"MS";
            print sumtable [label=" " rowname=sumtablr colname=sumtablc format=&decimals];
		  end;
        end;
      end;
	  %outform3 (outtodo=modres,outbig=maxresm);
      if (outscreen=1) then;do;
        print modres [label="Model" rowname=vlabsm colname=modresl format=&decimals];
      end;
      if ((savediag=1) & (ydich=0) & (sv4match=0)) then;do;
	    call ListAddItem(diaglist, regdiag);
	    diagnms="casenum"||vlabsm[2:nrow(vlabsm),1]`||outnames[1,ncol(outnames)]||"pred"||"resid"||"d_resid"||"stresid"||"tresid"||"h"||"mahal"||"cook"||"dmsreg"||"drsq"||"dskew"||t(dfbetas[1:nrow(modres),1]);
        call ListAddItem(diaglisl,diagnms);
      end;
      lmat=j(nrow(b),1,0);lmat2=j(nxvls,1,1);
      lmat[2:(1+nxvls),1]=lmat2;
	  if (ydich ^= 1) then;do;
        %ftest3 (lm=lmat,bcoef=b,cv=varb,chr=1,brsq=r2);
        totomni=fresult[1,(1+eivdo):ncol(fresult)];
	  end;
      if (stand=1) then;do;
        predsd=j(nrow(modres),1,0);
        stdmod=modres[,1]/ovsd[1,ncol(ovsd)];
	    do jd=1 to ncol(x);
          descdat=x[,jd];
  		  predsd[jd,1]=(n*descdat`*descdat)-((descdat[+,])`*descdat[+,]);
  		  predsd[jd,1]=sqrt(predsd[jd,1]/(nrow(descdat)*(nrow(descdat)-1)));
	    end;
        if ((wherex[1,ncol(wherex)] ^= -999) & ((nxvls > 1) | (xdich=1))) then;do;
          sdmsone=j(nxvls,1,1);
  		  predsd[wherex[1,ncol(wherex)]:wherex[2,ncol(wherex)],1]=sdmsone;
		  pstog=1;
	    end;
	    predsd[1,1]=1;stdmod=stdmod#predsd;
	    stdmod=stdmod[2:nrow(stdmod),1];
	    sdvlabs=vlabsm[2:nrow(vlabsm),1];
	    *%outform3 (outtodo=stdmod,outbig=maxresm);
	    coeffl22="coeff";
	    *if (outscreen=1) then;*do;
	    *  print stdmod[label="Standardized coefficients" rowname=sdvlabs colname=coeffl22 format=&decimals];
	    *end;
	  end;

	  *if ((zpp=1) & (ydich=0)) then;*do;
      if ((stand=1) & (ydich=0)) then;do;
        ivnames=vlabsm[2:nrow(vlabsm),1];
	    %outform3 (outtodo=zppout,outbig=maxresm);
	    %outform3 (outtodo=zppout2,outbig=maxresm);
	    if (outscreen=1) then;do; 
		  zppcnms="r"||"sr"||"pr"||"standYX"||"standY"||"standX";
          print zppout [label="Scale-free and standardized measures of association" rowname=ivnames colname=zppcnms format=&decimals];
		  zppcnms2="eqa-sq"||"p_eta-sq"||"f-sq";
		  print zppout2 [label=" " rowname=ivnames colname=zppcnms2 format=&decimals];
	    end;
      end; 

      if (covcoeff=1) then;do;
        if (outscreen=1) then;do;
          print varb [label="Covariance matrix of regression parameter estimates:" rowname=vlabsm colname=vlabsm format=&decimals];
        end;
        %outform3 (outtodo=varb,outbig=maxresm);
      end;

      if (diagnose=1) then;do;
        if ((ydich=0) | (i < (nms+nys))) then;do;
          %outform3 (outtodo=maxnmin,outbig=maxresm);
	      %outform3 (outtodo=skewres,outbig=maxresm);
          %outform3 (outtodo=bp,outbig=maxresm);
	      %outform3 (outtodo=wadf,outbig=maxresm);
          tolstat=tolstat||(1/tolstat);    
          %outform3 (outtodo=tolstat,outbig=maxresm);
          %outform3 (outtodo=bpresult,outbig=maxresm);         
          if (outscreen=1) then;do;
            print "-----------";
            print "Some regression diagnostics"; 
	    	maxnminr="fitted"||"residual"||"t-resid";maxnminc="Min."||"Max.";
            print maxnmin [label=" " rowname=maxnminr colname=maxnminc format=&decimals];
		    skewresr="Value"||"se";
            skewresc="Skewness"||"Kurtosis";
		    print skewres [label="Shape of residuals" rowname=skewresr colname=skewresc format=&decimals];
		    bplabss="t-resid"||"p-value"||"Casenum";
            print bp [label = "Bonferroni-corrected p for largest t-residual" colname=bplabss format=&decimals];  
		    wadfclab="casnum"||"dfbeta";
            print wadf [label="Most influential observations" colname=wadfclab rowname=vlabsm format=&decimals]; 
		    tolvnm=vlabsm[2:nrow(vlabsm),1];
            tolcnm="Tol."||"VIF"; 
            print tolstat [label="Variable tolerance and VIF" rowname=tolvnm colname=tolcnm format=&decimals];
		    bprlabs="Normal"||"Robust";bpclabs="Chi-sq"||"df"||"p";
		    print bpresult [label="Breusch-Pagan test of heteroskedasticity" colname=bpclabs rowname=bprlabs format=&decimals];
          end;
        end;
      end;
    end; 
  end;
end;  * end of start;
if ((criterr=0) & (nms > 0) & (ydich=0) & (modelres=1)) then;do;
  modresid=modresid[,2:ncol(modresid)];
  sigmatal=((modresid-J(n,1)*modresid[:,])`*(modresid-J(n,1)*modresid[:,]))/(n-1);
  sdvec=sqrt(diag(sigmatal));
  sdall=diag(1/vecdiag(sdvec));
  sdvec=vecdiag(sdvec); 
  corall=sdall*sigmatal*sdall`;
  %outform3 (outtodo=corall,outbig=maxresm);
  if (outscreen=1) then;do;
    print "************************* CORRELATIONS BETWEEN MODEL RESIDUALS ***************************";
    print corall [label=" " format=&decimals colname=outnames rowname=outnames];
  end;
end;

* DO BOOTSTRAPPING;
if ((criterr=0) & (boot > 0)) then;do;
  bootres=j(1,nump[,+],-999);
  bootdir=obsdirfx;
  natdirbt=j(1,nxvls,-999);
  if (effsize=1) then;do;bootysd=j(1,1,-999);bootxsd=j(1,1,-999);end;
  badboot=0;goodboot=0;smallest=1;booting=1;eiverrc=0;singerc=0;
  v=j(n,1,0);
  ones2=ones;
  if ((clusok=1) & (clusboot > 0)) then;do;
    temp=clusdat;
    temp[rank(clusdat[,3]),]=clusdat;
    clusdat=temp;
  end;
  do j = 1 to maxboot until (goodboot = boot);
    nobootx=1;modres2=999;eiverrct=0;singcnt=0;
	v4=999999;
	v=floor((ranuni(j(n,1,&seed)))*n)+1;
	if (clusok=1) then;do;  
      do clbt=1 to nclus;
		if (clusboot=1) then;do;
          isht=clusdat[current[clbt,3]:current[clbt,4],1];
          v2=floor((ranuni(j(current[clbt,2],1,&seed)))*current[clbt,2])+1;
          v[current[clbt,3]:current[clbt,4],1]=isht[v2,1];
        end;
	    if (clusboot > 1) then;do;
		  v2=floor((ranuni(j(1,1,&seed)))*nclus)+1;
          isht=clusdat[current[v2,3]:current[v2,4],1];
          v4=v4//isht;
        end;
	  end;
	  if (clusboot > 1) then;do;
	    v=v4[2:nrow(v4),1];
        ones2=j(nrow(v),1,1);
      end;
    end;
	bad=0;
    do i = 1 to (nms+nys);
      y=outvars[v,i];
      ynovar=(nrow(y)*y`*y)-((y[+,])`*y[+,]);
      ynovar=sqrt(ynovar/(nrow(y)*(nrow(y)-1)));
	  if (ynovar <= 0.00000000001) then;do;bad=1;end;
      xindx=datindx[1:(nump[1,i]-1),i];
      hello=0;x = fulldat[v,xindx];
      x=ones2||x;xsq=x`*x;exsq=eigval(xsq);
      holymoly=min(exsq);
	  exsq=(exsq <= .000000000002);
	  zeroeig=exsq[+,];bad=bad + (zeroeig > 0);singcnt=(zeroeig > 0);
      *%describ3 (descdatf=y,type=1);
      *bad=bad+ (desctmp[2,1] <= 0.00000000001);
      if (bad = 0) then;do;
        if (holymoly < smallest) then;do;smallest=holymoly;end;
		if ((ydich=0) | (i < (nms+nys))) then;do;
		  if (eivdo=1) then;do;
		    releiv=fulldatr[1,xindx];
		    releiv=1||releiv;
		  end;
          %modeles3 (y=y,x=x,type=1,full=0);
		  if (eiverr=1) then;do;bad=1;eiverrct=1;end;
		end;
        if ((ydich=1) & (i = (nms+nys))) then;do;
          %modeles3 (y=y,x=x,type=2,full=0);
		end;
		if (bad=0) then;do;modres2=modres2||modres`;end;
		if ((i=(nms+nys)) & (bad=0)) then;do;
          if (bcmat[(i+1),1]=1) then;do;
            bootdir=bootdir//(modres[wherex[1,i]:wherex[2,i],1])`;
		  end;
		  if (bcmat[(i+1),1]=0) then;do;
            bootdir=bootdir//dirzes;
		  end;
		end;
        if ((model=74) & (i <=nms)) then;do;
          onetemp=j(nrow(xprobval),1,1);
          mestmtb=onetemp||xprobval;
          if (ncs > 0) then;do;
            ncovmdlt=ccmat[i,];ncovmdlb=ncovmdlt[,+];
            if (ncovmdl > 0) then;do;
              cvmncb=j(nrow(mestmtb),ncovmdlb,1);
              cvmnctmp=x[+,(ncol(x)-ncovmdlb+1):ncol(x)]/nrow(x); 
	          if (cuscoval > 0) then;do;cvmnctmp=coval;end; 
	          do mestlp=1 to ncovmdlb;
	            cvmncb[,mestlp]=cvmncb[,mestlp]*cvmnctmp[,mestlp];
	          end;
	          mestmtb=mestmtb||cvmncb;
	        end;
          end;
          mestbt=mestmtb*modres;
          if (i=1) then;do;mestb=mestbt;end;
          if (i>1) then;do;mestb=mestb||mestbt;end;
        end;
        if ((model = 74) & (i = (nms+nys))) then;do;
          xvalptmp=j(1,nxvls,0);
          mest74sp=j(1,nms,0);
          mest74sp=mest74sp//mestb;
          xvalptmp=xvalptmp//I(nxvls);
          dirfxcf=j(nrow(mestb),1,0);         
          do cfloop1=1 to nrow(mestb);
            ndirfx=j(nrow(modres),1,0);
            ndirfx[2:(nxvls+1),1]=(xvalptmp[cfloop1,])`;
            do cfloop3=1 to nms;
              if ((mcx=1) | (mcx=0)) then;do;
                ndirfx[wheremw[(1+((cfloop3-1)*2)),ncol(wheremw)]:wheremw[(2+((cfloop3-1)*2)),ncol(wheremw)]]=(xvalptmp[cfloop1,]*mestb[1,cfloop3])`;
              end;
              if (mcx=2) then;do;
                ndirfx[wheremw[(1+((cfloop3-1)*2)),ncol(wheremw)]:wheremw[(2+((cfloop3-1)*2)),ncol(wheremw)]]=(xvalptmp[cfloop1,]*mest74sp[cfloop1,cfloop3])`;
              end;
            end;
            if (cfloop1 > 1) then;do;
              dirfxcf[cfloop1,1]=ndirfx`*modres*xscaling;
            end;
          end;
          natdirbt=natdirbt//(dirfxcf[2:nrow(dirfxcf),])`;
        end;
        if ((bcmat[(i+1),1] = 1) & (nobootx=1) & (effsize=1)) then;do;
          nobootx=0;
		  xsumtmp=x[,2];
          xsdtemp=(nrow(x)*x[,2]`*x[,2])-((xsumtmp[+,])`*xsumtmp[+,]); 
          xsdtemp=sqrt(xsdtemp/(nrow(x)*(nrow(x)-1)));
        end;
      end;
    end;
    if (bad = 0) then;do;
      bootres=bootres//modres2[,2:ncol(modres2)];
      if (effsize=1) then;do;
        ysdtemp=(nrow(y)*y`*y)-((y[+,])`*y[+,]); 
        ysdtemp=sqrt(ysdtemp/(nrow(y)*(nrow(y)-1)));
        bootysd=bootysd//ysdtemp;
        bootxsd=bootxsd//xsdtemp;
      end;
      goodboot=goodboot+1;
    end;
    if (bad ^= 0) then;do;badboot=badboot+1;eiverc=eiverc+eiverrct;singerc=singerc+singcnt;end;
  end;
  bootres=bootres[2:nrow(bootres),];
  if (effsize=1) then;do;
    bootysd=bootysd[2:nrow(bootysd),];
    if (nrow(bootxsd) > 1) then;do;bootxsd=bootxsd[2:nrow(bootxsd),];end;
  end;
  if (goodboot < (boot)) then;do;boot=0;modelbt=0;notecode[notes,1]=7;notes=notes+1;end;
  if (boot > 0) then;do;
    if (effsize=1) then;do;bootysd=ysd//bootysd;bootxsd=xsd//bootxsd;
    end;
    if (saveboot = 1) then;do;
	  savlabs=savlabs[1:(savlabsc-1),];
	  savlabs=rowcatc(savlabs);
      create &bootfile from bootres [colname=savlabs];
      append from bootres;
    end;
	if (modelbt=1) then;do;
      bootcim=j(ncol(bootres),5,-99999);
      bootcim[,2] = (bootres[+,]/nrow(bootres))`;
      bootcim[,1] = coeffmat[2:nrow(coeffmat),1];
      do i = 1 to ncol(bootres);
	    inpt=bootres[,i];
	    inpt2=(bootcim[i,1]*bc)+(9999*(1-bc));
        %bcboot3 (databcbt = inpt,estmte=inpt2);
        bootcim[i,4:5]=llcit||ulcit;
        bootcim[i,3]=bootse;
      end;
	end;
  end;
  if (badboot > 0) then;do;notecode[notes,1] = 6;notes=notes+1;end;
end;

if ((xmint=1) & (criterr=0)) then;do;
  xvalptmp=j(1,nxvls,0);
  mest74sp=j(1,nms,0);
  mest74sp=mest74sp//mest74;
  xvalptmp=xvalptmp//I(nxvls);
  do kcfuhd=1 to 2;
    dirfxcf=j(nrow(mest74),6,0);
    do cfloop1=1 to nrow(mest74);
      ndirfx=j(nrow(lastb),1,0);
      ndirfx[2:(nxvls+1),1]=(xvalptmp[cfloop1,])`;
      do cfloop3=1 to nms;
        if (kcfuhd=1) then;do;
          if ((mcx=1) | (mcx=0)) then;do;
            ndirfx[wheremw[(1+((cfloop3-1)*2)),ncol(wheremw)]:wheremw[(2+((cfloop3-1)*2)),ncol(wheremw)]]=(xvalptmp[cfloop1,]*mest74[1,cfloop3])`;
          end;
          if (mcx=2) then;do;
            ndirfx[wheremw[(1+((cfloop3-1)*2)),ncol(wheremw)]:wheremw[(2+((cfloop3-1)*2)),ncol(wheremw)]]=(xvalptmp[cfloop1,]*mest74sp[cfloop1,cfloop3])`;
          end;
        end;
        if (kcfuhd=2) then;do;
          ndirfx[wheremw[(1+((cfloop3-1)*2)),ncol(wheremw)]:wheremw[(2+((cfloop3-1)*2)),ncol(wheremw)]]=(xvalptmp[cfloop1,]*medmeans[1,cfloop3])`;
        end;
      end;
      if (cfloop1 > 1) then;do;
        dirfxcf[cfloop1,1]=ndirfx`*lastb*xscaling;
        dirfxcf[cfloop1,2]=sqrt(vecdiag(ndirfx`*lastcov*ndirfx))*abs(xscaling);
        dirfxcf[cfloop1,3]=dirfxcf[cfloop1,1]/dirfxcf[cfloop1,2];
        dirfxcf[cfloop1,4]=2*(1-probt(abs(dirfxcf[cfloop1,3]), dfres));
        dirfxcf[cfloop1,5]=dirfxcf[cfloop1,1]-tval*dirfxcf[cfloop1,2];  
        dirfxcf[cfloop1,6]=dirfxcf[cfloop1,1]+tval*dirfxcf[cfloop1,2];
      end;
    end;
    codireff=dirfxcf[2:nrow(dirfxcf),];
    if (kcfuhd=1) then;do;direff=codireff;end;
  end;
end;

* start of direct and indirect effects;

if ((criterr = 0) & (nms > 0)) then;do;
  paths=paths[,2:ncol(paths)];pathsw=pathsw[,2:ncol(pathsw)];
  pathsz=pathsz[,2:ncol(pathsz)];pathswz=pathswz[,2:ncol(pathswz)];
  pathsmod=pathsw+pathsz+pathswz;pathsdv=pathsdv[,2:ncol(pathsdv)];
  pathsfoc=pathsfoc[,2:ncol(pathsfoc)];pathtype=pathtype[,2:ncol(pathtype)];
  anymod=(pathsmod[,+] > 0);
  obscoeff=obscoeff[1,2:ncol(obscoeff)];
  if (outscreen=1) then;do;
    if (xmint=1) then;do;
	  print "******************************* COUNTERFACTUALLY DEFINED *********************************";
	end;
    if ((dototal = 0) & (alttotal=0)) then;do;
      print "************************* DIRECT AND INDIRECT EFFECTS OF X ON Y **************************";
    end;
    if (alttotal=1) then;do;
      print "********************* TOTAL, DIRECT, AND INDIRECT EFFECTS OF X ON Y **********************";
    end;
  end;
  if (dototal = 1) then;do;
    if (outscreen=1) then;do;
      print "********************* TOTAL, DIRECT, AND INDIRECT EFFECTS OF X ON Y **********************";
	end;
    totefflb[1,1]="Effect";
      if (effsize=1) then;do;
        toteffsz=toteff[,1]/ysd;
		if ((xdich=1) | (mcx > 0)) then;do;
          totefflb=totefflb||"c_ps";
		end;
        if ((xdich = 0) & (mcx = 0)) then;do;
          toteffsz=toteffsz*xsd;totefflb=totefflb||"c_cs";
        end;
        toteff=toteff||toteffsz;
      end;
	  %outform3 (outtodo=toteff,outbig=maxresm);	
      if (nxvls > 1) then;do;
	    %outform3 (outtodo=totomni,outbig=maxresm);
		clabtmp="R2-chng"||hcflab||"df1"||"df2"||"p";
        if (outscreen=1) then;do;
          print toteff [label="Relative total effects of X on Y:" rowname=toteffl2 colname=totefflb format=&decimals];
		  if (eivdo=1) then;do;clabtmp=clabtmp[1,2:ncol(clabtmp)];end;
          print totomni [label="Omnibus test of total effect of X on Y:" colname=clabtmp format=&decimals];
          print "----------";
		end;
      end;
      if (nxvls <= 1) then;do;
        toteffl2=" ";
		if (outscreen=1) then;do;
          print toteff [label="Total effect of X on Y" rowname=toteffl2 colname=totefflb format=&decimals];
		end;
      end;
  end;
  moddir=wcmat[nrow(bcmat),1]+zcmat[nrow(bcmat),1];
  if (xmint=1) then;do;moddir=1;end;
  if (bcmat[nrow(bcmat),1]=1) then;do;
    if (ydich=1) then;do;
      direfflb[,(ncol(direfflb)-5):ncol(direfflb)]="Effect"||"se"||"Z"||"p"||"LLCI"||"ULCI";
	end;
    if ((moddir=0) | (xmint=1)) then;do;
      direfflb[1,1]="Effect";
    end;
    if ((effsize=1) & (moddir=0) & (anymod = 0)) then;do;
      direffsz=direff[,1]/ysd;
	  if ((xdich=1) | (mcx > 0)) then;do;
        direfflb=direfflb||"c'_ps";
	  end;
      if ((xdich = 0) & (mcx = 0)) then;do;
        direffsz=direffsz*xsd;
        direfflb=direfflb||"c'_cs";
      end;
      direff=direff||direffsz;
    end;
	%outform3 (outtodo=direff,outbig=maxresm);
	if (xmint=1) then;do;
	  %outform3 (outtodo=codireff,outbig=maxresm);
	end;
    if ((moddir = 0) & (nxvls=1)) then;do;
      rowlbtmp=" ";
	  if (outscreen=1) then;do;
        print direff [label="Direct effect of X on Y" colname=direfflb rowname=rowlbtmp format=&decimals];
	  end;
    end;
    if ((moddir = 0) & (nxvls>1)) then;do;
	  %outform3 (outtodo=diromni,outbig=maxresm);
	  if (outscreen=1) then;do;
        print direff [label="Relative direct effects of X on Y" rowname=direffl2 colname=direfflb format=&decimals];
	  end;
	  if (outscreen=1) then;do;
        if (ydich=0) then;do; 
          clabtmp="R2-chng"||hcflab||"df1"||"df2"||"p";
		  if (eivdo=1) then;do;clabtmp=clabtmp[1,2:ncol(clabtmp)];end;
          print diromni [label="Omnibus test of direct effect of X on Y:" colname=clabtmp format=&decimals];		
	    end;
	    if (ydich=1) then;do;
          clabtmp="Chi-sq"||"df"||"p";
          print diromni [label="Omnibus LR test of direct effect of X on Y:" colname=clabtmp format=&decimals];
        end;
        print "----------";
	  end;
    end;
    if ((moddir > 0) & (nxvls=1)) then;do;
	  rowlbtmp=" ";
	  if ((xmint=0) & (outscreen=1)) then;do;
        print direff [label="Conditional direct effect(s) of X on Y:" rowname=rowlbtmp colname=direfflb format=&decimals];
      end;
	  if (xmint=1) then;do;
	    if (outscreen=1) then;do;
          print direff [label="(Pure) Natural direct effect of X on Y:" rowname=rowlbtmp colname=direfflb format=&decimals];
		  print codireff [label="Controlled direct effect of X on Y:" rowname=rowlbtmp colname=direfflb format=&decimals];
          print "----------";
	    end;
	    obnatdfx=direff[,1];
	  end;
    end;
	direffl4=direffl2;
    if ((moddir > 0) & (nxvls>1)) then;do;
      direffl2=" ";
      do i = 1 to nxvls;
        do j = 1 to (nrow(direff)/nxvls);direffl2=direffl2//xcatlab[i,1];end;
      end;
      direffl2=direffl2[2:nrow(direffl2),1];
	  if ((xmint=0) & (outscreen=1)) then;do;
        print direff [label="Relative conditional direct effect(s) of X on Y:" colname=direfflb rowname=direffl2 format=&decimals];
      end;
	  if (xmint=1) then;do;
        if (outscreen=1) then;do;
          print direff [label="Relative (pure) natural direct effect(s) of X on Y:" colname=direfflb rowname=direffl2 format=&decimals];
		  print codireff [label="Relative controlled direct effect(s) of X on Y:" colname=direfflb rowname=direffl2 format=&decimals];
          print "----------";
		end;
		obnatdfx=direff[,1];
      end;
    end;    
	direffl2=direffl4;
  end;
  if ((bcmat[nrow(bcmat),1]=0) & (xmint ^= 1)) then;do;
    if (outscreen=1) then;do;
      print "The direct effect of X on Y is fixed to zero.";
	end;
  end;

  * Here is the start of the indirect effects;

  if (nms = 1) then;do;indmark=2;indsets={1 2};end;
  if (nms = 2) then;do;indmark={2 2 3};indsets={1 4 2 5 1 3 5};thetam=1;end;
  if (nms = 3) then;do;indmark={2 2 2 3 3 3 4};indsets={1 7 2 8 4 9 1 3 8 1 5 9 2 6 9 1 3 6 9};thetam={1 2 3};end;
  if (nms = 4) then;do;indmark={2 2 2 2 3 3 3 3 3 3 4 4 4 4 5};thetam={1 2 4 3 5 6};
    indsets={1 11 2 12 4 13 7 14 1 3 12 1 5 13 1 8 14 2 6 13 2 9 14 4 10 14 1 3 6 13 1 3 9 14 1 5 10 14 2 6 10 14 1 3 6 10 14};
  end;
  if (nms = 5) then;do;indmark={2 2 2 2 2 3 3 3 3 3 3 3 3 3 3 4 4 4 4 4 4 4 4 4 4 5 5 5 5 5 6};thetam={1 2 5 3 6 8 4 7 9 10};
    indsets1={1 16 2 17 4 18 7 19 11 20 1 3 17 1 5 18 1 8 19 1 12 20 2 6 18 2 9 19 2 13 20 4 10 19 4 14 20 7 15 20 1 3 6 18};
    indsets2={1 3 9 19 1 3 13 20 1 5 10 19 1 5 14 20 1 8 15 20 2 6 10 19 2 6 14 20 2 9 15 20 4 10 15 20 1 3 6 10 19};
	indsets3={1 3 6 14 20 1 3 9 15 20 1 5 10 15 20 2 6 10 15 20 1 3 6 10 15 20};
    indsets=indsets1||indsets2||indsets3;
  end;
  if (nms = 6) then;do;indmark={2 2 2 2 2 2 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 6 6 6 6 6 6 7};
    indsets1={1 22 2 23 4 24 7 25 11 26 16 27 1 3 23 1 5 24 1 8 25 1 12 26 1 17 27 2 6 24 2 9 25 2 13 26 2 18 27 4 10 25 4 14 26};
    indsets2={4 19 27 7 15 26 7 20 27 11 21 27 1 3 6 24 1 3 9 25 1 3 13 26 1 3 18 27 1 5 10 25 1 5 14 26 1 5 19 27 1 8 15 26 1 8 20 27};
    indsets3={1 12 21 27 2 6 10 25 2 6 14 26 2 6 19 27 2 9 15 26 2 9 20 27 2 13 21 27 4 10 15 26 4 10 20 27 4 14 21 27 7 15 21 27};
    indsets4={1 3 6 10 25 1 3 6 14 26 1 3 6 19 27 1 3 9 15 26 1 3 9 20 27 1 3 13 21 27 1 5 10 15 26 1 5 10 20 27 1 5 14 21 27};
    indsets5={1 8 15 21 27 2 6 10 15 26 2 6 10 20 27 2 6 14 21 27 2 9 15 21 27 4 10 15 21 27 1 3 6 10 15 26 1 3 6 10 20 27};
    indsets6={1 3 6 14 21 27 1 3 9 15 21 27 1 5 10 15 21 27 2 6 10 15 21 27 1 3 6 10 15 21 27};
	indsets=indsets1||indsets2||indsets3||indsets4||indsets5||indsets6;
    thetam={1 2 6 3 7 10 4 8 11 13 5 9 12 14 15};
  end;
  if (nms=7) then;do;indmark={2 2 2 2 2 2 2};indsets={1 29 2 30 4 31 7 32 11 33 16 34 22 35};end;
  if (nms=8) then;do;indmark={2 2 2 2 2 2 2 2};indsets={1 37 2 38 4 39 7 40 11 41 16 42 22 43 29 44};end;
  if (nms=9) then;do;indmark={2 2 2 2 2 2 2 2 2};indsets={1 46 2 47 4 48 7 49 11 50 16 51 22 52 29 53 37 54};end;
  if (nms=10) then;do;indmark={2 2 2 2 2 2 2 2 2 2};indsets={1 56 2 57 4 58 7 59 11 60 16 61 22 62 29 63 37 64 46 65};end;
  
  indlbl=j(200,1,"xxxxxx");
  cntname=j(200,1,"xxxxxx");
  do i = 1 to 200;indlbl[i,1]=CAT("Ind",i);cntname[i,1]=CAT("{C",i,")");end; 

  indmake=j(ncol(indmark),(nms+2),0);indmod=j(ncol(indmark),1,999);indmmm=j(ncol(indmark),1,0);indmmmt=j(ncol(indmark),1,0);
  start=1;end=0;nindfx=0;indlocs=j(nrow(thetaxmb),ncol(paths),999);
  indkey=j(ncol(indmark),1+((indmark[,<>]*2)+1),"        ");  * this was a translation;
  c1=1;c2=1;c3=1;
  do i = 1 to ncol(paths);
    if (pathtype[1,i]=1) then;do;indlocs[,i]=thetaxmb[,c1];c1=c1+1;end;
    if (pathtype[1,i]=3) then;do;indlocs[,i]=thetamyb[,c2];c2=c2+1;end;
    if ((pathtype[1,i]=2) & (nms < 7) & (serial=1)) then;do;indlocs[,i]=thetammb[,thetam[1,c3]];c3=c3+1;end;
  end;
  do i = 1 to ncol(indlocs);
    c1=2;
    do j = 2 to nrow(indlocs);
      if (indlocs[j,i] ^= 0) then;do;indlocs[c1,i]=indlocs[j,i];c1=c1+1;end;
    end;
    indlocs[1,i]=c1-2;
  end;
  rmaxtmp=indlocs[1,]+1;
  indlocs=indlocs[1:rmaxtmp[,<>],]; * this is a translation;
  do i = 1 to ncol(indmark);
    numget=indmark[1,i];end=end+numget;gotcha=indsets[1,start:end];start=end+1;ok=1;temp=0;
    repoman=j(4,1,0);
    do j = 1 to ncol(gotcha);
      if (paths[1,gotcha[1,j]]=0) then;do;ok=0;end;
      if (pathsmod[1,gotcha[1,j]] > 0) then;do;
        temp=1;temp2=pathsw[1,gotcha[1,j]]//pathsz[1,gotcha[1,j]]//pathswz[1,gotcha[1,j]]//0;
        if ((temp2[1,1]=1) & (temp2[2,1]=1) & (temp2[3,1]=0)) then;do;temp2[4,1]=1;end;
        repoman=repoman+temp2;
      end;
    end;
    temp=0;tempmmm=0;typemmm=0;
    if ((repoman[1,1] > 0) & (repoman[2,1] = 0)) then;do;temp=1;
      if (repoman[1,1]=1) then;do;tempmmm=1;end;
      if ((repoman[1,1] > 1) & ((wdich=1) | (mcw > 0))) then;do;tempmmm=12;typemmm=mcw;
        if (wdich=1) then;do;typemmm=1;end;
      end;
      if ((repoman[1,1] > 1) & ((wdich=0) & (mcw = 0))) then;do;tempmmm=101;end;
    end;
    if ((repoman[1,1] = 0) & (repoman[2,1] > 0)) then;do;temp=2;
      if (repoman[2,1]=1) then;do;tempmmm=2;end;
      if ((repoman[2,1] > 1) & ((zdich = 1) | (mcz > 0))) then;do;tempmmm=22;typemmm=mcz;
        if (zdich=1) then;do;typemmm=1;end;
      end;
      if ((repoman[2,1] > 1) & ((zdich = 0) & (mcw = 0))) then;do;tempmmm=102;end;
    end;
    if ((repoman[1,1]>0) & (repoman[2,1]>0)) then;do;temp=3;
      if ((repoman[1,1]=1) & (repoman[2,1]=1)) then;do;
        if (repoman[4,1]=1) then;do;tempmmm=31;end;
        if (repoman[3,1]=1) then;do;tempmmm=41;end;
      end;
    end;
    if ((repoman[1,1]=1) & (repoman[2,1]=1) & (repoman[3,1]=0) & (repoman[4,1]=0)) then;do;tempmmm=51;end;
    if (ok = 1) then;do;
      nindfx=nindfx+1;indmake[nindfx,1]=numget;indmod[nindfx,1]=temp;
      indmmm[nindfx,1]=tempmmm;indmmmt[nindfx,1]=typemmm;indmake[nindfx,2:(1+numget)]=gotcha;indkey[nindfx,1]=xnames;
        do j = 1 to numget;
          indkey[nindfx,(j*2+1)]=pathsdv[1,gotcha[1,j]];
          indkey[nindfx,(j*2)]="   ->   ";
        end;
    end;
  end;
  cmaxtmp=indmake[,1];
  indkey=indkey[1:nindfx,1:((cmaxtmp[<>,]*2)+1)]; * this is a translation;
  indmake=indmake[1:nindfx,1:(cmaxtmp[<>,]+1)]; * this is a translation;
  indmod=indmod[1:nrow(indmake),1];indmmm=indmmm[1:nrow(indmake),1];indmmmt=indmmmt[1:nrow(indmake),1];
  ncpairs = (((nindfx)*(nindfx-1))/2);
  if (((contrast = 1) | (contrast = 2)) & (ncpairs > 105)) then;do;
    contrast=0;notecode[notes,1] = 13;notes = notes + 1;
  end;
  if (contrast = 3) then;do;
    if (ncol(contvec) ^= nindfx) then;do;contrast=0;notecode[notes,1] = 14;notes = notes + 1;end;
  end;

  * This is for models with no moderator *;
  if (anymod=0) then;do;
    if ((nms = 1) & (contrast > 0)) then;do;contrast=0;end;
    efloop=(((1-(effsize=0))*2)+1)-((((mcx>0) | (xdich=1)))*(1-(effsize=0)));
	if ((diagnose=1) | (savediag=1)) then;do;
	  alldfbs=alldfbs[,2:ncol(alldfbs)];
	end;
	dfindfx=j(n,1,999);
    do kk=1 to efloop;
      if (boot = 0) then;do;bootres=obscoeff;
	    if (kk=1) then;do;totbtvec=j(1,nxvls,0);end;
        bootdir=obsdirfx;indtab=999;inddiff=999;bootysd=ysd;bootxsd=xsd;
      end;
      if (boot > 0) then;do;bootres=obscoeff//bootres;
	    if (kk=1) then;do;totbtvec=j(nrow(bootres),nxvls,0);end;
        indtab=j(1,4,999);inddiff=j(nrow(bootres),1,999);
      end;
      indtotal=j(nrow(bootres),1,0);
      do i = 1 to nrow(indmake);
        do j = 1 to nxvls;
          indtemp=j(nrow(bootres),1,1);
		  dfabtemp=j(n,1,1);
          do k = 1 to indmake[i,1];jtemp=1;
            if ((j > 1) & (k=1)) then;do;jtemp=j;end;
			indtemp=indtemp#bootres[,pathsfoc[jtemp,indmake[i,(k+1)]]];
			if (kk=1) then;do;
			  if ((ydich=0) & ((diagnose=1) | (savediag=1))) then;do;
                dfabtemp=dfabtemp#(bootres[1,(pathsfoc[jtemp,indmake[i,(k+1)]])]-alldfbs[,pathsfoc[jtemp,indmake[i,(k+1)]]]);
			  end;
			end;
          end;
		  if ((kk=1) & (ydich=0) & ((diagnose=1) | (savediag=1))) then;do;
		    dfindfx=dfindfx||(indtemp[1,1]-dfabtemp);
		  end;
          if (kk = 2) then;do;indtemp=indtemp/bootysd;end;
          if (kk = 3) then;do;indtemp=(bootxsd#indtemp)/bootysd;end;
          if (contrast ^= 0) then;do;inddiff=inddiff||indtemp;end;
          if (nxvls=1) then;do;indtotal=indtotal+indtemp;end;
          indeff=indtemp[1,1];
		  if (kk=1) then;do;totbtvec[,j]=totbtvec[,j]+indtemp;end;
          if (boot > 0) then;do;
		    bcboottp=indtemp[2:nrow(indtemp),1];
		    inpt2=(indtemp[1,1]*bc)+(9999*(1-bc));
            %bcboot3 (databcbt = bcboottp,estmte=inpt2);
            indeff=indeff||bootse||llcit||ulcit;
          end;
		  if (kk=1) then;do;
		    indtabn=indtab//indeff;
		  end;
          indtab=indtab//indeff;
        end;
      end;
      indtab=indtab[2:nrow(indtab),];
	  if (kk=1) then;do;
        indtabn=indtabn[2:nrow(indtabn),];
        if ((ydich=0) & ((diagnose=1) | (savediag=1))) then;do;
          wadfie=j((ncol(dfindfx)-1),2,0);
          do wadf1ie=1 to (ncol(dfindfx)-1);
            do wadf2ie=1 to nrow(dfindfx);
              if ((abs(dfindfx[wadf2ie,(wadf1ie+1)])) > abs(wadfie[wadf1ie,2])) then;do;
                wadfie[wadf1ie,2]=dfindfx[wadf2ie,(wadf1ie+1)];
                wadfie[wadf1ie,1]=rownum[wadf2ie,1];
              end;                     
            end;
          end;
        end;
      end;
      rowlbs=indlbl[1:nrow(indtab),1];
      if (mc > 0) then;do;
        inddiff=j(mc,1,-999);
        indtab2=j(nrow(indtab),4,-999);indtab2[,1]=indtab;indtab=indtab2;mcct=0;indtotal=j(mc,1,0);
        if (kk = 1) then;do;
		  x1=sqrt(-2*log(ranuni(j(mc,nrow(mcsopath),&seed))))#cos((2*3.14159265358979)*(ranuni(j(mc,nrow(mcsopath),&seed))));
          x1=x1*root(indcov);
          do ii=1 to nrow(x1);
            x1[ii,]=x1[ii,]+mcsopath`;
          end;
        end;
        do ii=1 to nms;
          tmpb=x1[,((nms*nxvls)+ii)];
          tmpb2=tmpb;
          if (nxvls > 1) then;do;
            do jj=1 to (nxvls-1);tmpb2=tmpb2||tmpb;end;
          end;
          indtemp=x1[,(((ii-1)*nxvls)+1):(ii*nxvls)]#tmpb2;
          do jj=1 to ncol(indtemp);
            if (kk = 2) then;do;indtemp[,jj]=indtemp[,jj]/ysd;end;
            if (kk = 3) then;do;indtemp[,jj]=(xsd*indtemp[,jj])/ysd;end;
		    bcboottp=indtemp[,jj];
            %bcboot3 (databcbt = bcboottp);
            mcct=mcct+1;indtab[mcct,2:4]=bootse||llcit||ulcit;
          end;
          if (nxvls=1) then;do;indtotal=indtotal+indtemp;
            if (contrast ^= 0) then;do;inddiff=inddiff||indtemp;end;
          end;
        end;
      end;
      if ((normal = 1) & (sobelok=1)) then;do;
        sobelmat=indtab[,1];sobelmat=sobelmat||(sobelmat/2)||sobelmat||sobelmat;
        do ii=1 to nms;
          se2b=indcov[((nms*nxvls)+ii),((nms*nxvls)+ii)];
          bpath2=mcsopath[((nms*nxvls)+ii),1]##2;
          se2a=vecdiag(indcov[(((ii-1)*nxvls)+1):(ii*nxvls),(((ii-1)*nxvls)+1):(ii*nxvls)]);
          apath2=mcsopath[(((ii-1)*nxvls)+1):(ii*nxvls) ,1]##2;
          sesobel=sqrt(apath2*se2b+bpath2*se2a+se2a*se2b);
          sobelmat[(((ii-1)*nxvls)+1):(ii*nxvls),2]=sesobel;
        end;       
        sobelmat[,3]=sobelmat[,1]/sobelmat[,2];
        sobelmat[,4] = 2*(1-probnorm(abs(sobelmat[,3])));
      end;
      if (serial = 0) then;do;rowlbs=mnames`;end;
      if ((nxvls=1) & (nms > 1)) then;do;
        rowlbs="TOTAL"//rowlbs;
        indtemp=indtotal[1,1];
        if ((boot > 0) & (nxvls=1)) then;do;
		  bcboottp=indtotal[2:nrow(indtotal),1];
		  inpt2=(indtotal[1,1]*bc)+(9999*(1-bc));
          %bcboot3 (databcbt=bcboottp,estmte=inpt2);
          indtemp=indtemp||bootse||llcit||ulcit;
        end;
        if (mc > 0) then;do;
          obtmc=indtab[,1];indtemp=obtmc[+,];bcboottp=indtotal[,1];
          %bcboot3 (databcbt = bcboottp);
          indtemp=indtemp||bootse||llcit||ulcit;
        end;
        indtab=indtemp//indtab;
      end;
      bootlbs="Effect"||"BootSE"||"BootLLCI"||"BootULCI";
      if (mc > 0) then;do;bootlbs="Effect"||"MC SE"||"MC LLCI"||"MC ULCI";end;
      if (nxvls = 1) then;do;
        if (contrast ^= 0) then;do;
          inddiff=inddiff[,2:ncol(inddiff)];
          if (mc > 0) then;do;inddiff=obtmc`//inddiff;end;
          if (contrast = 3) then;do;
            inddifft=inddiff*contvec`;indtemp=inddifft[1,1];
            if ((boot > 0) | (mc > 0)) then;do;
			  if (mc > 0) then;do;
			    bcboottp=inddifft[2:nrow(inddifft),1];
                %bcboot3 (databcbt = bcboottp); 
			  end;
			  if (boot > 0) then;do;
			    bcboottp=inddifft[2:nrow(inddifft),1];
				inpt2=(inddifft[1,1]*bc)+(9999*(1-bc));
                %bcboot3 (databcbt = bcboottp,estmte=inpt2); 
			  end;
              indtemp=indtemp||bootse||llcit||ulcit;
            end;
            indtab=indtab//indtemp;
          end;
          if ((contrast = 1) | (contrast = 2)) then;do;
            conkey=j(1,4," ");
            do i = 1 to ncol(inddiff)-1;
              do j = (i+1) to ncol(inddiff);           
                inddifft=inddiff[,i]-inddiff[,j];
                if (contrast=2) then;do;inddifft=abs(inddiff[,i])-abs(inddiff[,j]);end;
                indtemp=inddifft[1,1];
                conkeyt=" "||rowlbs[(i+1),1]||" minus  "||rowlbs[(j+1),1];
                conkey=conkey//conkeyt;
                if ((boot > 0) | (mc > 0)) then;do;
				  if (mc > 0) then;do;
				    bcboottp=inddifft[2:nrow(inddifft),1];
					%bcboot3 (databcbt = bcboottp);
				  end;
				  if (boot > 0) then;do;
				    bcboottp=inddifft[2:nrow(inddifft),1];
					inpt2=(inddifft[1,1]*bc)+(9999*(1-bc));
                    %bcboot3 (databcbt = bcboottp,estmte=inpt2);
				  end;
                  indtemp=indtemp||bootse||llcit||ulcit;
                end;
                indtab=indtab//indtemp;
              end;
            end;
          end;
          contlbs=cntname[1:(((nindfx)*(nindfx-1))/2),1];
          rowlbs=rowlbs//contlbs;
        end;
		if ((kk=1) | (kk=2 & ((xdich=1) | (mcx > 0))) | (kk=3)) then;do;
		  %outform3 (outtodo=indtab,outbig=maxresm);
		end;
		if ((kk=1) & (ydich=0) & (diagnose=1)) then;do;
	      %outform3 (outtodo=wadfie,outbig=maxresm);
		end;
		if (outscreen=1) then;do;
          if (kk=1) then;do;
            print indtab [label = "Indirect effect(s) of X on Y:" rowname=rowlbs colname=bootlbs format=&decimals];
			dfielabs=rowlbs[(2-(nms=1)):((2-(nms=1))+nrow(indmake)-1),1];
            if ((ydich=0) & (diagnose=1)) then;do;
			  dfierlbs="casenum"||"dfb_ie";
              print wadfie [label="Cases with greatest influence on indirect effects:" format=&decimals rowname=dfielabs colname=dfierlbs];  
            end;
          end;
          if ((kk = 2) & ((xdich=1) | (mcx > 0))) then;do;
            print indtab [label = "Partially standardized (StandY) indirect effect(s) of X on Y:" rowname=rowlbs colname=bootlbs format=&decimals];
          end;
          if (kk = 3) then;do;
            print indtab [label = "Completely standardized (StandYX) indirect effect(s) of X on Y:" rowname=rowlbs colname=bootlbs format=&decimals];
          end;
		end;
        if ((normal=1) & (sobelok=1) & (kk=1)) then;do;
          sobellab="Effect"||hclab||"Z"||"p";sobelrlb=rowlbs;
          if (nms > 1) then;do;sobelrlb=rowlbs[2:(1+nms),1];end;
		  %outform3 (outtodo=sobelmat,outbig=maxresm);
		  if (outscreen=1) then;do;
            print sobelmat [label="Normal theory test for indirect effect(s):" colname=sobellab rowname=sobelrlb format=&decimals];
		  end;
        end;
        if (contrast ^= 0) then;do;
          if (((contrast=1) | (contrast = 2)) & (kk=efloop)) then;do;
            conkey=conkey[2:nrow(conkey),];
			if (outscreen=1) then;do;
              print conkey [label = "Specific indirect effect contrast definition(s):" rowname=contlbs];
			end;
          end;
          if ((contrast = 3) & (kk=efloop)) then;do;
            crowlbs=rowlbs[2:(nindfx+1),1];
			rnmtmp="(C1)";
			if (outscreen=1) then;do;
              print contvec [label = "Specific indirect effect contrast weights:" colname=crowlbs rowname=rnmtmp format=&decimals];
			end;
          end;
          if ((contrast = 2) & (kk=efloop)) then;do;
		    if (outscreen=1) then;do;
              print "Contrasts are differences between absolute values of indirect effects";
			end;
          end;
        end;
        if ((serial = 1) & (kk=efloop)) then;do;
          rowlbst=rowlbs[2:(nrow(indkey)+1),1];
		  colnmike=" "||" ";
		  indkey=rowlbst||indkey;
		  if (outscreen=1) then;do;
            print indkey [label = "Indirect effect key:"];
		  end;
        end;
	  end;
      if (nxvls > 1) then;do;
	    if (outscreen=1) then;do;
          if (kk = 1) then;do;print "Relative indirect effects of X on Y";end;
          if (kk = 2) then;do;print "Partially standardized (StandY) relative indirect effect(s) of X on Y:";end;
          if (kk = 3) then;do;print "Completely standardized (StandYX) relative indirect effect(s) of X on Y:";end;
		end;
        do i = 1 to nrow(indmake);
          indtabsm=indtab[(((i-1)*nxvls)+1):(nxvls*i),];
		  if ((diagnose=1) & (ydich=0)) then;do;
            wadfies=wadfie[(((i-1)*nxvls)+1):(nxvls*i),];
          end;
          indkeyt=indkey[i,];
		  if (outscreen=1) then;do;
            print indkeyt [label=" "];
		  end;
		  if (bcmat[nrow(bcmat),1]=0) then;do;
		    direffl2=xcatlab[1:nxvls,1];
		  end;
		  %outform3 (outtodo=indtabsm,outbig=maxresm);	
		  if ((kk=1) & (ydich=0) & (diagnose=1)) then;do;
	        %outform3 (outtodo=wadfies,outbig=maxresm);
		  end;
		  if (outscreen=1) then;do;
            print indtabsm [label = " " colname=bootlbs rowname=direffl2 format=&decimals];
			if ((ydich=0) & (kk=1) & (diagnose=1)) then;do;
			  dfierlbs="casenum"||"dfb_ie";
              print wadfies [label="Cases with greatest influence on relative indirect effects:" format=&decimals rowname=direffl2 colname=dfierlbs]; 
              print "---"; 
            end;
		  end;
          if ((normal=1) & (sobelok=1) & (kk=1)) then;do;
            sobelsm=sobelmat[(((i-1)*nxvls)+1):(nxvls*i),];
            sobellab="Effect"||hclab||"Z"||"p";
			%outform3 (outtodo=sobelsm,outbig=maxresm);
			if (outscreen=1) then;do;
              print sobelsm [label="Normal theory test for relative indirect effects:" colname=sobellab rowname=direffl2 format=&decimals];
			end;
          end;
        end;
      end;
      if ((effsize = 1) & (boot > 0)) then;do;bootres=bootres[2:nrow(bootres),];end;
    end;
    if (alttotal=1) then;do;
      altcnms="Effect";
	  totbtvec=totbtvec+bootdir;
      alttotfx=totbtvec[1,]`;
      if (boot > 0) then;do;
        alttotfx=j(ncol(totbtvec),4,0);
        alttotfx[,1]=(totbtvec[1,])`;
       do cec=1 to ncol(totbtvec);
	     inpt=totbtvec[2:nrow(totbtvec),cec];inpt2=(totbtvec[1,cec]*bc)+(9999*(1-bc));
         %bcboot3 (databcbt=inpt,estmte=inpt2);
         alttotfx[cec,2:4]=bootse||llcit||ulcit;
       end;
       altcnms=altcnms||"BootSE"||"BootLLCI"||"BootULCI";
      end;
	  %outform3 (outtodo=alttotfx,outbig=maxresm);
	  if (outscreen=1) then;do;
        if (nxvls > 1) then;do;
	      print "----------";
	      print alttotfx [label="Relative total effects of X on Y (sum of direct and indirect effects):" colname=altcnms rowname=direffl2 format=&decimals];
        end;
        if (nxvls = 1) then;do;
          print alttotfx [label="Total effect of X on Y (sum of direct and indirect effects):" colname=altcnms format=&decimals];
        end;
	  end;
    end;
  end;
  if (anymod > 0) then;do;
    if (boot = 0) then;do;bootres=obscoeff;indtab=999;end;
    if (boot > 0) then;do;bootres=obscoeff//bootres;indtab=j(1,4,999);end;
	csumintp=(indmod > 0);
	if (outscreen=1) then;do;
      if (csumintp[+,]=nrow(indmod)) then;do;
        if (nxvls > 1) then;do;
		   if (xmint=0) then;do;
             print "Relative conditional indirect effects of X on Y:";
           end;
           if (xmint=1) then;do;
		     print "Relative (total) natural indirect effects of X on Y:";
		   end;
		end;
        if (nxvls = 1) then;do;
		  if (xmint=0) then;do;
            print "Conditional indirect effects of X on Y:";
		  end;
		  if (xmint=1) then;do;
		    print "(Total) Natural indirect effect(s) of X on Y:";
		  end;
        end;
      end;
      if (csumintp[+,] < nrow(indmod)) then;do;
        if (nxvls > 1) then;do;print "Relative conditional and unconditional indirect effects of X on Y:";end;
        if (nxvls = 1) then;do;print "Conditional and unconditional indirect effects of X on Y:";end;
      end;
    end;
	cftotfx=j(nrow(bootres),nxvls,0);
    do i = 1 to nrow(indmake);
      indtab=indtab[1,]*0;
	  pnttemp=indkey[i,];
	  if (outscreen=1) then;do;
	    if (xmint=0) then;do;
          print pnttemp [label = "INDIRECT EFFECT:"];
		end;
		if (xmint=1) then;do;
		  print pnttemp [label = " "];
		end;
	  end;
      if (indmod[i,1]=0) then;do;
        do j = 1 to nxvls;
          indtemp=j(nrow(bootres),1,1);
          do k = 1 to indmake[i,1];jtemp=1;
            if ((j > 1) & (k=1)) then;do;jtemp=j;end;
            indtemp=indtemp#bootres[,pathsfoc[jtemp,indmake[i,(k+1)]]];
          end;
          indeff=indtemp[1,1];
          if (boot > 0) then;do;
		    bcboottp=indtemp[2:nrow(indtemp),1];
		    inpt2=(indtemp[1,1]*bc)+(9999*(1-bc));
            %bcboot3 (databcbt = bcboottp,estmte=inpt2);
            indeff=indeff||bootse||llcit||ulcit;
          end;
          indtab=indtab//indeff;
        end;
		%outform3 (outtodo=indtab,outbig=maxresm);
		colnmtp="Effect"||"BootSE"||"BootLLCI"||"BootULCI";
        if (nxvls > 1) then;do;
          indefflb=xcatlab[1:nxvls,1];
		  inttabtp=indtab[2:nrow(indtab),];
		  if (outscreen=1) then;do;
            print inttabtp [label = " " colname=colnmtp rowname=indefflb format=&decimals];
		  end;
        end;
        if (nxvls = 1) then;do;
		  inttabtp=indtab[2:nrow(indtab),];
		  rownmtp=" ";
		  if (outscreen=1) then;do;
            print inttabtp [label = " " colname=colnmtp rowname=rownmtp format=&decimals];
		  end;
        end;
      end;
      * end of unmoderated;
      * start of moderated;
      if (indmod[i,1]>0) then;do;
        if (indmod[i,1]=1) then;do;indmodva=wmodvals;indprova=wprobval;condlbs=wnames;printw=1;end;
        if (indmod[i,1]=2) then;do;indmodva=zmodvals;indprova=zprobval;condlbs=znames;printz=1;end;
        if (indmod[i,1]=3) then;do;cntmp=1;printz=1;printw=1;
          indmodva=j((nrow(wmodvals)*nrow(zmodvals)),2,999);
          do k7 = 1 to nrow(wmodvals);
            do k8 = 1 to nrow(zmodvals);indmodva[cntmp,]=wmodvals[k7,1]||zmodvals[k8,1];cntmp=cntmp+1;end;
          end;
          condlbs=wnames||znames;
        end;
        condres=j(nrow(indmodva),1,999);
        if (boot > 0) then;do;condres=j(nrow(indmodva),4,999);end;
        condres=indmodva||condres;
        do k4 = 1 to nxvls;
          imm3=j(nrow(bootres),1,1);imm4=j(nrow(bootres),1,1);indcontr=0;  
          if (indmod[i,1]=3) then;do;tihsw=wprobval;tihsz=zprobval;end;
         do k1=1 to nrow(indmodva);
            tucker2=j(nrow(bootres),1,1);imm2=j(nrow(bootres),1,1);wfirst=0;zfirst=0;immset=0;
           do k2=1 to indmake[i,1];
             colnumb=indmake[i,(k2+1)];
             if (k2=1) then;do;
               wbb=j(nrow(bootres),(nwvls*nxvls),0);zbb=j(nrow(bootres),(nzvls*nxvls),0);
               wzbb=j(nrow(bootres),(nwvls*nzvls*nxvls),0);
             end;
             if (k2^= 1) then;do;
                 wbb=j(nrow(bootres),nwvls,0);zbb=j(nrow(bootres),nzvls,0);
                 wzbb=j(nrow(bootres),(nwvls*nzvls),0);
             end;
             cnt=1;tihs=indlocs[2:((indlocs[1,colnumb])+1),colnumb];
             if (k2 = 1) then;do;
               focbb=tihs[1:nxvls,1];focbb=bootres[,focbb];
               if (indmmm[i,1]>0) then;do;imm=focbb[,k4];condbb=imm;end;
               focaddon=j(1,nxvls,0);focaddon[1,k4]=1;cnt=cnt+nxvls;placeh=nxvls;
               if (indmod[i,1]=1) then;do;
                  tihsz=j(nrow(wprobval),(nzvls*nxvls),0);
                  tihswz=j(nrow(wprobval),(nwvls*nzvls*nxvls),0);
                 if (pathsw[1,colnumb]=1) then;do;
                   temp=j(nrow(wprobval),(nxvls*nwvls),0);
                   do k5 = 1 to nrow(wprobval);
                     do k6=1 to nwvls;temp[k5,(((k4-1)*nwvls)+k6)]=wprobval[k5,k6];end;
                   end;
                   indprova=temp||tihsz||tihswz;
                 end;
                 if (pathsw[1,colnumb] ^= 1) then;do;
                   indprova=wprobval||tihsz||tihswz;
                 end;
               end;
               if (indmod[i,1]=2) then;do;
                  tihsw=j(nrow(zprobval),(nwvls*nxvls),0);
                  tihswz=j(nrow(zprobval),(nwvls*nzvls*nxvls),0);
                 if (pathsz[1,colnumb]=1) then;do;
                   temp=j(nrow(zprobval),(nxvls*nzvls),0);
                   do k5 = 1 to nrow(zprobval);
                     do k6 =1 to nzvls;temp[k5,(((k4-1)*nzvls)+k6)]=zprobval[k5,k6];end;
				   end;
                   indprova=tihsw||temp||tihswz;
				 end;
                 if (pathsz[1,colnumb] ^= 1) then;do;
                   indprova=tihsw||zprobval||tihswz;
                 end;
               end;
               if (indmod[i,1]=3) then;do;
                 indprova=j((nrow(wprobval)*nrow(zprobval)),((ncol(wprobval)*nxvls)+(ncol(zprobval)*nxvls)+(nwvls*nzvls*nxvls)),0);
                 cntemp=1;           
                 do k7=1 to nrow(wprobval);
                   do k8 =1 to nrow(zprobval);
                      temp=wprobval[k7,]*focaddon[1,k4];
                      indprova[cntemp,(((k4-1)*nwvls)+1):(k4*(nwvls))]=temp;
                      temp=zprobval[k8,]*focaddon[1,k4];
                      indprova[cntemp,((((k4-1)*nzvls)+1)+(nxvls*nwvls)):((((k4-1)*nzvls)+1)+(nxvls*nwvls)+(nzvls-1))]=temp;
                      cntemp=cntemp+1;
                   end;
                 end;
                 if (pathsz[1,colnumb]=0) then;do;
                    temp=j(nrow(indprova),(ncol(zprobval)*nxvls),0);
                    indprova[,((ncol(wprobval)*nxvls)+1):((ncol(wprobval)+ncol(zprobval))*nxvls)]=temp;
                 end;
                 if (pathsw[1,colnumb]=0) then;do;
                    temp=j(nrow(indprova),(ncol(wprobval)*nxvls),0);
                    indprova[,1:(ncol(wprobval)*nxvls)]=temp;   
                 end;
                 if (pathswz[1,colnumb]=1) then;do;
                    cntemp=(ncol(wprobval)*nxvls)+(ncol(zprobval)*nxvls)+((k4-1)*ncol(wprobval)*ncol(zprobval))+1;
                    do k7=1 to ncol(wprobval);
                      do k8=1 to ncol(zprobval);
					     * ok?;
                         indprova[,cntemp]=indprova[,((ncol(wprobval)*(k4-1))+k7)]#indprova[,((((k4-1)*ncol(zprobval))+k8)+(nxvls*ncol(wprobval)))];
                         cntemp=cntemp+1;
                      end;
                    end;
                 end;
               end;
             end;
             if (k2 > 1) then;do;
                focbb=tihs[1,1];focbb=bootres[,focbb];
               if (indmmm[i,1]>0) then;do;imm=focbb[,1];condbb=imm;end;
               focaddon=1;cnt=cnt+1;placeh=1;
               if (indmod[i,1]=1) then;do;
                  tihsz=j(nrow(wprobval),nzvls,0);
                  tihswz=j(nrow(wprobval),(nwvls*nzvls),0);
                  indprova=wprobval||tihsz||tihswz;
               end;
               if (indmod[i,1]=2) then;do;
                 tihsw=j(nrow(zprobval),nwvls,0);
                 tihswz=j(nrow(zprobval),(nwvls*nzvls),0);
                 indprova=tihsw||zprobval||tihswz;
               end;
               if (indmod[i,1]=3) then;do;
                 indprova=j((nrow(wprobval)*nrow(zprobval)),((ncol(wprobval)+ncol(zprobval))+(nwvls*nzvls)),0);
                 cntemp=1;           
                 do k7=1 to nrow(wprobval);
                   do k8 =1 to nrow(zprobval);
                      indprova[cntemp,1:(ncol(wprobval)+ncol(zprobval))]=wprobval[k7,]||zprobval[k8,];
                      cntemp=cntemp+1;
                   end;
                 end;
                 if (pathsz[1,colnumb]=0) then;do;
                    temp=j(nrow(indprova),ncol(zprobval),0);
                    indprova[,(ncol(wprobval)+1):(ncol(wprobval)+ncol(zprobval))]=temp;
                 end;
                 if (pathsw[1,colnumb]=0) then;do;
                    temp=j(nrow(indprova),ncol(wprobval),0);
                    indprova[,1:ncol(wprobval)]=temp;   
                 end;
                 if (pathswz[1,colnumb]=1) then;do;
                    cntemp=ncol(wprobval)+ncol(zprobval)+1;
                    do k7=1 to ncol(wprobval);
                      do k8=1 to ncol(zprobval);
                        indprova[,cntemp]=indprova[,k7]#indprova[,(ncol(wprobval)+k8)];
                        cntemp=cntemp+1;
                      end;
                    end;
                 end;
               end;
             end;  
             if (pathsw[1,colnumb] = 1) then;do;
                wbb=tihs[cnt:(cnt+(placeh*nwvls)-1),1];
                wbb=bootres[,wbb];
                immlbs2=wcatlab[1:nwvls,1];
               if (zfirst=0) then;do;wfirst=1;end;
               if ((indmmm[i,1]=1) | (indmmm[i,1]=31) | (indmmm[i,1]=51)) then;do;
                 imm=wbb[,1];
                 do k7 = 1 to nwvls;imm=imm||wbb[,(((k4-1)*nwvls*(k2=1))+k7)];end;
                 imm=imm[,2:ncol(imm)];               
               end;
               if ((indmmm[i,1]=41) | (indmmm[i,1]=51)) then;do;
                 condbb=j(nrow(bootres),1,0);
                 do k7 = 1 to nwvls;condbb=condbb||wbb[,(((k4-1)*nwvls*(k2=1))+k7)];end;
                 condbb=condbb[,2:ncol(condbb)];
               end;
               cnt=cnt+(placeh*nwvls);
             end;
             if (pathsz[1,colnumb] = 1) then;do;
               zbb=tihs[cnt:(cnt+(placeh*nzvls)-1),1];
               zbb=bootres[,zbb];
               if (wfirst=0) then;do;zfirst=1;end;
               if (indmmm[i,1] ^= 31) then;do;immlbs2=zcatlab[1:nzvls,1];end;
               if ((indmmm[i,1]=2) | (indmmm[i,1]=31) | (indmmm[i,1]=51)) then;do;
                 if (indmmm[i,1]=2) then;do;imm=zbb[,1];end;
                 do k7 = 1 to nzvls;imm=imm||zbb[,(((k4-1)*nzvls*(k2=1))+k7)];end;
                 if ((indmmm[i,1]=2) | (indmmm[i,1]=51)) then;do;
                   imm=imm[,2:ncol(imm)];  
                   if (indmmm[i,1]=51) then;do;condbb=condbb||imm;end;
                 end;         
               end;
               cnt=cnt+(placeh*nzvls);
             end;
             if (pathswz[1,colnumb] = 1) then;do;
               wzbb=tihs[cnt:(cnt+(placeh*nwvls*nzvls)-1),1];
               wzbb=bootres[,wzbb];
               if (indmmm[i,1]=41) then;do;imm=wzbb[,1];	
                 do k7=1 to (nwvls*nzvls);imm=imm||wzbb[,(((k4-1)*nzvls*nwvls*(k2=1))+k7)];end;
			   end;
               if (indmmm[i,1]=41) then;do;
                  imm=imm[,2:ncol(imm)];
                  condbb=condbb||imm[,(ncol(imm)-(nwvls*nzvls)+1):ncol(imm)]; 
               end;
               cnt=cnt+(placeh*nzvls*nwvls);
             end;
             indprobe=focaddon||indprova[k1,];
             tucker=focbb||wbb||zbb||wzbb;
             do k3=1 to ncol(indprobe);tucker[,k3]=tucker[,k3]*indprobe[1,k3];end;
             tucker2=tucker2#tucker[,+];
             if ((indmmm[i,1] = 1) | (indmmm[i,1]=2) | (indmmm[i,1]=31) | (indmmm[i,1]=41) | (indmmm[i,1]=51)) then;do;
               if (immset=1) then;do;
                 if ((ncol(imm2)=1) & (ncol(imm) = 1)) then;do;imm2=imm2#imm;end;
                 if ((indmmm[i,1]=41) | (indmmm[i,1]=51)) then;do;
                   if ((ncol(condbb2) > 1) & (ncol(condbb)>1)) then;do;
                     condbb2t=j(nrow(condbb2),(ncol(condbb2)*ncol(condbb)),-999999);k9=1;
                     if (wfirst=1) then;do;
                       do k7=1 to ncol(condbb2);
                         do k8 = 1 to ncol(condbb);
                            condbb2t[,k9]=condbb2[,k7]#condbb[,k8];k9=k9+1;
                         end;
                       end;
                     end;
                     if (zfirst=1) then;do;
                       do k7=1 to ncol(condbb);
                         do k8 = 1 to ncol(condbb2);
						    * changing from imm2t to condbb2;
                            * imm2t[,k9]=condbb[,k7]#condbb2[,k8];*k9=k9+1;
							condbb2t[,k9]=condbb[,k7]#condbb2[,k8];k9=k9+1;
                         end;
                       end;
                     end;
                     condbb2=condbb2t;                    
                   end;
                   if ((ncol(condbb2) > 1) & (ncol(condbb)=1)) then;do;
                     do k7 = 1 to ncol(condbb2);condbb2[,k7]=condbb2[,k7]#condbb;end;
                   end;
                   if ((ncol(condbb2) = 1) & (ncol(condbb)>1)) then;do;
                     do k7 = 1 to ncol(condbb);condbb[,k7]=condbb2#condbb[,k7];end;
                     condbb2=condbb;
                   end;                 
                 end;
                 if ((ncol(imm2) ^= 1) & (ncol(imm) ^= 1)) then;do;
                   imm2t=j(nrow(imm2),(ncol(imm2)*ncol(imm)),-999999);k9=1;
                   if (wfirst=1) then;do;
                     do k7=1 to ncol(imm2);
                       do k8 = 1 to ncol(imm);
                          imm2t[,k9]=imm2[,k7]#imm[,k8];
                          k9=k9+1;
                       end;
                     end;
                   end;
                   if (zfirst=1) then;do;
                     do k7=1 to ncol(imm);
                       do k8 = 1 to ncol(imm2);
                         imm2t[,k9]=imm[,k7]#imm2[,k8];
                         k9=k9+1;
                       end;
                     end;
                   end;
                   imm2=imm2t;
                 end;
                 if ((ncol(imm2) > 1) & (ncol(imm)=1)) then;do;
                   do k7=1 to ncol(imm2);
                     imm2[,k7]=imm2[,k7]#imm;
                   end;
                 end;
                 if ((ncol(imm2) = 1) & (ncol(imm) > 1)) then;do;
                   do k7=1 to ncol(imm);imm[,k7]=imm2#imm[,k7];end;
                    imm2=imm;
                 end;
               end;
               if (immset=0) then;do;
                 imm2=imm;
                 if ((indmmm[i,1]=41) | (indmmm[i,1]=51)) then;do;
                   condbb2=condbb;
                 end;
                 immset=1;
               end;
             end;
           end;
           * end of looping through paths;
           indtemp=tucker2[1,1];
           if ((indmmm[i,1]=12) | (indmmm[i,1]=22)) then;do;
             imm3=imm3||tucker2;
             if (k1=nrow(indmodva)) then;do;
               imm3=imm3[,2:ncol(imm3)];immstop=ncol(imm3);
               do k8=2 to immstop;
                 if (indmmmt[i,1]=1) then;do;imm3=imm3||(imm3[,k8]-imm3[,1]);end;
                 if (indmmmt[i,1]=2) then;do;imm3=imm3||(imm3[,k8]-imm3[,(k8-1)]);end;
                 if (indmmmt[i,1]=3) then;do;
				    rsumtmp=imm3[,(k8:immstop)];
                    imm3=imm3||((rsumtmp[,+]/(immstop-k8+1))-imm3[,(k8-1)]);
                 end;
                 if (indmmmt[i,1]=4) then;do;
				    rsumtmp=imm3[,1:immstop];
                    imm3=imm3||(imm3[,k8]-(rsumtmp[,+]/immstop));
                 end;
               end;
               if (indmmmt[i,1]<5) then;do;
                  imm2=imm3[,(immstop+1):ncol(imm3)];
               end;
             end;
           end;      
           if ((indmmm[i,1]>(-1)) & ((contrast = 1) | (contrast = 2))) then;do;
             imm4=imm4||tucker2;
             if ((k1=nrow(indmodva)) & (k1 > 1)) then;do;
               imm4=imm4[,2:ncol(imm4)];immstop=ncol(imm4);
               condcont=j((immstop*(immstop-1)/2),6,-999);              
               do k8 = 1 to (immstop-1);
                 do k9 = (k8+1) to immstop;                   
                   if (contrast=1) then;do;imm4=imm4||(imm4[,k9]-imm4[,k8]);end;
                   if (contrast=2) then;do;imm4=imm4||(abs(imm4[,k9])-abs(imm4[,k8]));end;
                    condcont[(ncol(imm4)-immstop),1]=imm4[1,k9];
                    condcont[(ncol(imm4)-immstop),2]=imm4[1,k8];
                 end;
               end;
               imm4=imm4[,(immstop+1):ncol(imm4)];   
               do k8=1 to ncol(imm4);
                 condcont[k8,3]=imm4[1,k8];
                 if (boot > 0) then;do;
				   bcboottp=imm4[2:nrow(imm4),k8];
				   inpt2=(imm4[1,k8]*bc)+(9999*(1-bc));
                   %bcboot3 (databcbt = bcboottp,estmte=inpt2);
                   condcont[k8,4:6]=bootse||llcit||ulcit;  
                 end;
               end;
               if (boot=0) then;do;condcont=condcont[,1:3];end;
               indcontr=1;
             end;
           end;
		   if (xmint=1) then;do;
		     if (k1=(k4+1)) then;do;
			   cftotfx[,k4]=cftotfx[,k4]+(tucker2*xscaling);
			 end;
		   end;
           if (boot > 0) then;do;
		     tucker2=tucker2*xscaling;
		     bcboottp=tucker2[2:nrow(tucker2),1];
			 inpt2=(tucker2[1,1]*bc)+(9999*(1-bc));
             %bcboot3 (databcbt = bcboottp,estmte=inpt2);
             indtemp=(indtemp*xscaling)||bootse||llcit||ulcit;  
           end;
		   if (boot=0) then;do;
		     indtemp=indtemp*xscaling;
		   end;
           condres[k1,(ncol(indmodva)+1):ncol(condres)]=indtemp;
         end;
		 * end of looping through indirect effects: k1;
		 if (xmint=0) then;do;
		   %outform3 (outtodo=condres,outbig=maxresm);
		 end;

          condlbs=condlbs||"Effect";
          if (boot > 0) then;do;condlbs=condlbs||"BootSE"||"BootLLCI"||"BootULCI";end;
          if (xmint = 1) then;do;
            if (k4 = 1) then;do;natindfx=condres[(2+(k4-1)),2:ncol(condres)];end;
            if (k4 > 1) then;do;natindfx=natindfx//condres[(2+(k4-1)),2:ncol(condres)];end;
            if (k4=nxvls) then;do;
			  %outform3 (outtodo=natindfx,outbig=maxresm);
            end;
          end;
          if (nxvls=1) then;do;
            rownmtp=" ";
		    if ((outscreen=1) & (xmint=0)) then;do;
              print condres [label=" " colname=condlbs rowname=rownmtp format=&decimals];
			end;
          end;
          if (nxvls ^=1) then;do;
            condrlb=j(nrow(condres),1,xcatlab[k4,1]);
			if ((outscreen=1) & (xmint=0)) then;do;
              print condres [label=" " colname=condlbs rowname=condrlb format=&decimals];
			end;
          end;
		  if ((outscreen=1) & (xmint=1) & (k4=nxvls)) then;do;
            if (nxvls=1) then;do;
              rownmtp=" ";
              print natindfx [label=" " colname=condlbs rowname=rownmtp format=&decimals];
			end;
            if (nxvls ^= 1) then;do;
              condrlb=j(nrow(condres),1,xcatlab[k4,1]);
              print natindfx [label=" " colname=condlbs rowname=direffl2 format=&decimals];
			end;
          end;
          dichadj=0;immcat=0;
          if ((indmmm[i,]>0) & (xmint=0)) then;do;
            if ((indmmm[i,1]=1) | (indmmm[i,1]=12) | (indmmm[i,1]=31)) then;do;
              if ((wdich=1) & (mcw=0)) then;do;
                if (indmmm[i,1] ^= 12) then;do;
                  imm2[,1]=imm2[,1]*(wmax-wmin);
				end;
                if (indmmm[i,1] ^= 31) then;do;dichadj=1;end;
              end;           
              if (((mcw = 1) | (mcw = 2)) & (indmmm[i,1] ^= 31)) then;do;immcat=1;end;
            end;
            if ((indmmm[i,1]=2) | (indmmm[i,1]=22) | (indmmm[i,1]=31)) then;do;
              if ((zdich=1) & (mcz=0)) then;do;
			    if (indmmm[i,1]=31) then;do;
                  imm2[,(nwvls+1):ncol(imm2)]=imm2[,(nwvls+1):ncol(imm2)]*(zmax-zmin);
				end;
				if (indmmm[i,1]=2) then;do;
                  imm2[,1]=imm2[,1]*(zmax-zmin);
				end;
                if (indmmm[i,1] ^= 31) then;do;dichadj=1;end;
              end;
              if (((mcz = 1) | (mcz = 2)) & (indmmm[i,1] ^= 31)) then;do;immcat=1;end;
            end;
            immtemp2=imm2[1,]`;immtemp=immtemp2;immlbs="Index";
            if (boot > 0) then;do;
              immtemp=j(1,3,0);
              do k7=1 to ncol(imm2);
			    bcboottp=imm2[2:nrow(imm2),k7];
				inpt2=(imm2[1,k7]*bc)+(9999*(1-bc));
                %bcboot3 (databcbt = bcboottp,estmte=inpt2);
                temp=bootse||llcit||ulcit;immtemp=immtemp//temp;
              end;  
               immtemp=immtemp[2:nrow(immtemp),];
               immtemp=immtemp2||immtemp;
               immlbs=immlbs||"BootSE"||"BootLLCI"||"BootULCI";
            end;
			%outform3 (outtodo=immtemp,outbig=maxresm);
            if ((dichadj=0) & (immcat=0) & (indmmmt[i,1]^=5) & (indmmm[i,1] < 100)) then;do;
			  if (outscreen=1) then;do;
                if (indmmm[i,1] < 30) then;do;
                  print immtemp [label="Index of moderated mediation:" colname=immlbs rowname=immlbs2 format=&decimals];
                end;
                if (indmmm[i,1] = 31) then;do;
                  immlbs2=immlbs2//zcatlab[1:nzvls,1];
                  print immtemp [label="Indices of partial moderated mediation:" colname=immlbs rowname=immlbs2 format=&decimals];
                end;
              end;
			  if ((nwvls=1) & (nzvls=1)) then;do;
              if ((indmmm[i,1] = 41) | (indmmm[i,1]=51)) then;do;
                do k7=1 to nwvls;
                  immlbs2=zcatlab[1:nzvls,1];
                  immtemp2=immtemp[(((k7-1)*nzvls)+1):(((k7-1)*nzvls)+nzvls),];              
                  if (nwvls > 1) then;do;
                    primodv="        "||wcatlab[k7,1];
					cnametmp=" ";
					if (outscreen=1) then;do;
                      print primodv [label="Primary moderator:" colname=cnametmp rowname=cnametmp];
					end;
                  end;
				  if (outscreen=1) then;do;
                    if (nzvls=1) then;do;
				      cnametmp=" ";
                      print immtemp2 [label="      Index of moderated moderated mediation" rowname=cnametmp colname=immlbs format=&decimals];
				    end;
                    if (nzvls ^= 1) then;do;
                      print immtemp2 [label="      Indices of moderated moderated mediation" colname=immlbs rowname=immlbs2 format=&decimals];
                    end;
				  end;
                  cmmtemp=j(nrow(zprobval),4,0);        
                  do k8=1 to nrow(zprobval);
                    condbb3=condbb2[,((nwvls+1)+((k7-1)*nzvls)):((nwvls+1)+((k7-1)*nzvls)+(nzvls-1))];
                    if (ncol(zprobval) > 1) then;do;condbb3=condbb3*diag(zprobval[k8,]);end;
                    if (ncol(zprobval) <=1) then;do;condbb3=condbb3#zprobval[k8,];end;
                    condbb3=condbb2[,k7]||condbb3;icmm=condbb3[,+];cmmtemp[k8,1]=icmm[1,1];
                    if (boot > 0) then;do;
					  bcboottp=icmm[2:nrow(icmm),1];
					  inpt2=(icmm[1,1]*bc)+(9999*(1-bc));
                      %bcboot3 (databcbt = bcboottp,estmte=inpt2);
                      cmmtemp[k8,2:4]=bootse||llcit||ulcit;
                    end;
                  end;
                  cmmtemp=zmodvals||cmmtemp;
                  if (boot=0) then;do;cmmtemp=cmmtemp[,1:2];end;                    
                  cmmlbs=znames||immlbs;
				  rownmtp=" ";
				  %outform3 (outtodo=cmmtemp,outbig=maxresm);
				  if (outscreen=1) then;do;
                    print cmmtemp [label="      Indices of conditional moderated mediation by W" colname=cmmlbs rowname=rownmtp format=&decimals];
				  end;
                end;
              end;

			  end;

            end;
            if ((dichadj=1) | (immcat=1) & (indmmm[i,1] < 30)) then;do;
			  if (outscreen=1) then;do;
                print immtemp [label="Index of moderated mediation (difference between conditional indirect effects):" colname=immlbs rowname=immlbs2 format=&decimals];
			  end;
            end;
          end;
          if (indcontr=1) then;do;
		    %outform3 (outtodo=condcont,outbig=maxresm);
            condctlb= "Effect1"||"Effect2"||"Contrast"||"BootSE"||"BootLLCI"||"BootULCI";
			rownmtp=" ";
			if (outscreen=1) then;do;
              print condcont [label=" Pairwise contrasts between conditional indirect effects (Effect1 minus Effect2)" colname=condctlb rowname=rownmtp format=&decimals];
			end;
          end;
		  if ((outscreen=1) & (k4=nxvls)) then;do;
            print "---";
		  end;
        end;
      end;
      * end of moderated;
    end;
    if (alttotal=1) then;do;
      altcnms="Effect"; 
      alttotfx=cftotfx[1,]`+obnatdfx;
      if (boot > 0) then;do;
        alttotfx=j(ncol(cftotfx),4,0);
        alttotfx[,1]=(cftotfx[1,])`+obnatdfx;
        natdirbt[1,]=obnatdfx`;
        cftotfx=cftotfx+natdirbt;
        do cec=1 to ncol(cftotfx);
		  bcboottp=cftotfx[2:nrow(cftotfx),cec];
		  inpt2=(cftotfx[1,cec]*bc)+(9999*(1-bc));
          %bcboot3 (databcbt = bcboottp,estmte=inpt2);
          alttotfx[cec,2:4]=bootse||llcit||ulcit;
        end;
        altcnms=altcnms||"BootSE"||"BootLLCI"||"BootULCI";
      end;
	  %outform3 (outtodo=alttotfx,outbig=maxresm);
      if (outscreen=1) then;do;
	    print "----------";
        if (nxvls > 1) then;do;
          print alttotfx [label="Relative total effects of X on Y (sum of direct and indirect effects)" colname=altcnms rowname=direffl2 format=&decimals];
        end;
        if (nxvls = 1) then;do;
		  rwlbtmp=" ";
          print alttotfx [label="Total effect of X on Y (sum of direct and indirect effects)" colname=altcnms rowname=rwlbtmp format=&decimals];
        end;
      end;
    end;
  end;
end;

* end of direct and indirect effects;

if ((criterr=0) & (saveboot=1) & (boot > 0)) then;do;
  conseq=conseq[2:nrow(conseq),];
  *colslab=colslab[1:ncol(bootres),1];
  *colslab=colslab||conseq||vlabs;
  *svlbs=" "||"Conseqnt"||"Antecdnt";
  if (outscreen=1) then;do;
    print "******************************************************************************************";
    print "Bootstrap estimates were saved to a file";
    *print colslab [label="Map of column names to model coefficients" colname=svlbs];
  end;
end;

* PRINT BOOTSTRAP RESULTS FOR MODEL PARAMETERS;
if ((criterr=0) & (boot > 0) & (modelbt=1)) then;do;
  labstart=1;
  if (outscreen=1) then;do;
    print "******************* BOOTSTRAP RESULTS FOR REGRESSION MODEL PARAMETERS *********************";
    print outnmtmp [label = "OUTCOME VARIABLE:"];
  end;
  do iboot = 1 to (nms+nys);
    outnmtmp=outnames[1,iboot];
    vlabsm=vlabs[labstart:(labstart+(nump[1,iboot]-1)),1];
    outnmtmp=bootcim[labstart:(labstart+(nump[1,iboot]-1)),];
	%outform3 (outtodo=outnmtmp,outbig=maxresm);
    clabels="Coeff"||"BootMean"||"BootSE"||"BootLLCI"||"BootULCI";
	if (outscreen=1) then;do;
      print outnmtmp [label=" " rowname=vlabsm colname=clabels format=&decimals];
	end;
    labstart=labstart+nump[1,iboot];
    if (iboot < (nms+nys)) then;do;
	  if (outscreen=1) then;do;
        print "-------";
	  end;
    end;
  end;
end;

if (criterr=0) then;do;
  * if ((savediag=1) & (ydich=0) & (sv4match=0) & ((anymod2=0) | (model < 4)))then;*do;
    if ((savediag=1) & (ydich=0) & (sv4match=0)) then;do;
    notecode[notes,1]=41;notes=notes+1;
    do i = 1 to (nms+nys+dototal);
      regdiag=ListGetItem(diaglist,i);
      regdiagl=ListGetItem(diaglisl,i);
      if (model < 4) then;do;dfilenum[i]="";end;
  	  if ((nms > 0) & (anymod2=0)) then;do;
	    regdiag=regdiag||dfindfx[,2:ncol(dfindfx)];
	    regdiagl=regdiagl||t(dfinds[1:(ncol(dfindfx)-1),1]);
	  end;
      create ("&diagfile"+dfilenum[i]) from regdiag [colname=regdiagl];append from regdiag;
      close ("&diagfile"+dfilenum[i]);
    end;
  end;
end;

/* PRINT MODEL MATRICES */;
if ((criterr = 0) & (matrices=1)) then;do;
  if (outscreen=1) then;do;  
    print "******************************** MODEL DEFINITION MATRICES ********************************";
    print "FROM variables are columns, TO variables are rows.";
    temp2=j(nrow(bcmat),ncol(bcmat),"0");
    do i = 2 to nrow(bcmat);
      do j = 1 to (ncol(bcmat)-1);
        if (bcmat[i,j]=1) then;do;temp2[i,j]="1";end;
        if (j >= i) then;do;temp2[i,j]=" ";end;
      end;
    end;
    temp2=temp2[2:nrow(bcmat),(1:(ncol(bcmat)-1))];
    if (nms > 0) then;do;cmatlabs=xnames||mnames;rmatlabs=mnames||ynames;end;
    if (nms = 0) then;do;cmatlabs=xnames;rmatlabs=ynames;end;
    print temp2 [label="BMATRIX: Paths freely estimated (1) and fixed to zero (0):" colname=cmatlabs rowname=rmatlabs]; 
    z=0;
    if (wcmat[+,+] ^= 0) then;do;
      temp2=j(nrow(wcmat),ncol(wcmat),"0");
      do i = 2 to nrow(wcmat);
        do j = 1 to (ncol(wcmat)-1);
          if (wcmat[i,j]=1) then;do;temp2[i,j]="1";end;
          if (j >= i) then;do;temp2[i,j]=" ";end;
        end;
      end;
      temp2=temp2[2:nrow(wcmat),(1:(ncol(wcmat)-1))];
      print temp2 [label="WMATRIX: Paths freely estimated (1) and fixed to zero (0):" colname=cmatlabs rowname=rmatlabs]; 
    end;
    if (zcmat[+,+] ^= 0) then;do;
      temp2=j(nrow(zcmat),ncol(zcmat),"0");
      do i = 2 to nrow(zcmat);
        do j = 1 to (ncol(zcmat)-1);
          if (zcmat[i,j]=1) then;do;temp2[i,j]="1";end;
          if (j >= i) then;do;temp2[i,j]=" ";end;
        end;
      end;
      temp2=temp2[2:nrow(zcmat),(1:(ncol(zcmat)-1))];
      print temp2 [label="ZMATRIX: Paths freely estimated (1) and fixed to zero (0):" colname=cmatlabs rowname=rmatlabs]; 
    end;
    if (wzcmat[+,+] ^= 0) then;do;
      temp2=j(nrow(wzcmat),ncol(wzcmat),"0");
      do i = 2 to nrow(wzcmat);
        do j = 1 to (ncol(wzcmat)-1);
          if (wzcmat[i,j]=1) then;do;temp2[i,j]="1";end;
          if (j >= i) then;do;temp2[i,j]=" ";end;
        end;
      end;
      temp2=temp2[2:nrow(wzcmat),(1:(ncol(wzcmat)-1))];
      print temp2 [label="WZMATRIX: Paths freely estimated (1) and fixed to zero (0):" colname=cmatlabs rowname=rmatlabs]; 
    end;
    if (ncs > 0) then;do;
      print ccmat [label="CMATRIX: Covariates (columns) in (1) and not in (0) the models of M and Y" colname=covnames rowname=rmatlabs]; 
    end;
  end;
end;
if (activate=1) then;do;
  print "*****************************************************************************************";
end;
if (outscreen=1) then;do;
  if (activate=0) then;do;
    print "******************************* ANALYSIS NOTES AND ERRORS *******************************";
  end;
end;
if (criterr = 0) then;do;
  if (saveboot=1) then;do;close &bootfile;end;
  if (outscreen=1) then;do;
  print "Level of confidence for all confidence intervals in output:" conf [label=" " format=8.4];
  if (boot > 0) then;do;
    if ((goodboot = boot) & (bc=0)) then;do;
	  if (clusboot=0) then;do;
	    print "Number of bootstrap samples for percentile bootstrap confidence intervals:" boot [label=" "];
	  end;
	  if (clusboot > 0) then;do;
	    print "Number of bootstrap samples for (cluster) percentile bootstrap confidence intervals:" boot [label=" "];
	  end;
	end;
	if ((goodboot = boot) & (bc=1)) then;do;
	  if (clusboot=0) then;do;
	    print "Number of bootstrap samples for bias-corrected bootstrap confidence intervals:" boot [label=" "];
	  end;
	  if (clusboot > 0) then;do;
	    print "Number of bootstrap samples for (cluster) bias-corrected bootstrap confidence intervals:" boot [label=" "];
	  end;
	end;
	if (booterr = 1) then;do;
      badend=badend[1,2:(ncol(badend))];
	  badend=badend`;
      print badend [label = "WARNING: Bootstrap CI endpoints below not trustworthy. Decrease confidence or increase bootstraps" format = &decimals];
    end;
  end;
  if (mc > 0) then;do;
    print "Number of samples for Monte Carlo confidence intervals:" mc [label=" "];
  end;
  if ((wnotev > 0) & (printw = 1)) then;do;
    if (wnotev = 1) then;do;print "W values in conditional tables are the 16th, 50th, and 84th percentiles";end;
	if (wnotev = 2) then;do;
      if ((minwwarn=0) & (maxwwarn=0)) then;do;print "W values in conditional tables are the mean and +/- SD from the mean";end;
	  if (minwwarn=1) then;do;print "W values in conditional tables are the minimum, the mean, and 1 SD above the mean";end;
	  if (maxwwarn=1) then;do;print "W values in conditional tables are 1 SD below the mean, the mean, and the maximum";end;
	end;
  end;
  if ((znotev > 0) & (printz = 1)) then;do;
    if (znotev = 1) then;do;print "Z values in conditional tables are the 16th, 50th, and 84th percentiles";end;
	if (znotev = 2) then;do;
      if ((minzwarn=0) & (maxzwarn=0)) then;do;print "Z values in conditional tables are the mean and +/- SD from the mean";end;
	  if (minzwarn=1) then;do;print "Z values in conditional tables are the minimum, the mean, and 1 SD above the mean";end;
	  if (maxzwarn=1) then;do;print "Z values in conditional tables are 1 SD below the mean, the mean, and the maximum";end;
	end;
  end;
  if (minwwarn > 0) then;do;
    print "NOTE: One SD below the mean is below the minimum observed in the data for W,";
	print "      so the minimum measurement on W is used for conditioning instead.";
  end;
  if (maxwwarn > 0) then;do;
    print "NOTE: One SD above the mean is above the maximum observed in the data for W,";
	print "      so the maximum measurement on W is used for conditioning instead.";
  end;
  if (minzwarn > 0) then;do;
    print "NOTE: One SD below the mean is below the minimum observed in the data for Z,";
	print "      so the minimum measurement on Z is used for conditioning instead.";
  end;
  if (maxzwarn > 0) then;do;
    print "NOTE: One SD above the mean is above the maximum observed in the data for Z,";
	print "      so the maximum measurement on Z is used for conditioning instead.";
  end;
  *if (pstog=1) then;*do;
  *  print "NOTE: Standardized coefficients for dichotomous or multicategorical X are in";
  *	print "      partially standardized form.";
  *end;
  do i = 1 to notes;
    if (notecode[i,1]=32) then;do;
      print "Direct, indirect, and total effects are counterfactuallly defined";
	  reset PRINTADV=0;
	  if (xcontcf=0) then;do;print "assuming X by M interaction.";end;
	  if (xcontcf=1) then;do;
        print "assuming X by M interaction and with the following reference (x_ref)";
		states=xrefvals`;
		cflabs="x_ref"||"x_cf";
		print "and counterfactual (x_cf} states for X:" , states [label=" " rowname=cflabs format=&decimals];
	  end;
	  reset PRINTADV=1;
	end;
	if (notecode[i,1]=41) then;do;
	  print "NOTE: Regression diagnostics were saved to a file.";
	end;
    if (notecode[i,1]=1) then;do;
      print "NOTE: COVMY is ignored when using CMATRIX option.";
    end;
    if (notecode[i,1]=2) then;do;
      print "NOTE: Confidence level restricted to between 50 and 99.9999. 95% confidence is provided in output.";
    end;
    if (notecode[i,1]=3) then;do;
      print centvar [label = "NOTE: The following variables were mean centered prior to analysis:"]; 
    end;
    if (notecode[i,1]=4) then;do;
	  if (robustse=0) then;do;
        print "NOTE: A heteroskedasticity-consistent standard error and covariance matrix estimator was used.";
	  end;
	  if (robustse=1) then;do;
        print "NOTE: A cluster robust standard error and covariance matrix estimator was used.";
		reset printadv=0;
		print "      Degrees of freedom for t statistics and denominator for F-tests is " dfres [label=" "];
		reset printadv=1;
		if (intncd=1) then;do;
		  print "NOTE: Some F tests could not be completed due to an insufficient number of clusters.";
	      reset printadv=0;
          print "      These are displayed in the output as 99999.";
		  reset printadv=1;
		end;
	  end;
    end;
    if (notecode[i,1]=5) then;do;
      print "NOTE: The HC3 option has been replaced with HC3. See the documentation.";
    end;
    if (notecode[i,1]=6) then;do;
      print badboot [label = "NOTE: Some bootstrap samples had to be replaced. The number of such replacements was:" format = 10.0];
    end;
    if (notecode[i,1]=7) then;do;
      print "NOTE: The bootstrapping was not completed due to problematic bootstrap samples.  Bootstrap CIs are suppressed.";
    end;
    if (notecode[i,1]=8) then;do;
      print "NOTE: The number of bootstrap samples was adjusted upward given your desired confidence.";
    end;
    if (notecode[i,1]=9) then;do;
      print "NOTE: WMODVAL is ignored when W is specified as multicategorical.";
    end;
    if (notecode[i,1]=10) then;do;
      print "NOTE: ZMODVAL is ignored when Z is specified as multicategorical.";
    end;
    if (notecode[i,1]=11) then;do;
      print "NOTE: Total effect model generated only when all covariates are specified in all models of M and Y.";
    end;
	if (notecode[i,1]=30) then;do;
      print "NOTE: Your vector of linear hypothesis weights is of the wrong length for this model.";
    end;
    if (notecode[i,1] = 40) then;do;
      print "NOTE: All subsets regression and dominance analysis are not available with fewer";
	  reset printadv=0;
      print "      than 2 or more than 15 regressors.";
	  reset printadv=1;
    end;
    if (notecode[i,1]=12) then;do;
      print "NOTE: Total effect model generated only when X is freely estimated to affect each M";
	  reset printadv=0;
	  print "      and both X and M are freely estimated to affect Y.";
	  reset printadv=1;
    end;
    if (notecode[i,1]=13) then;do;
      print "NOTE: There are too many pairwise contrasts to conduct with this model.";
    end;
    if (notecode[i,1]=14) then;do;
      print "NOTE: The number of contrast weights must equal the number of indirect effects.";
    end;
    if (notecode[i,1]=15) then;do;
      print "NOTE: Monte Carlo confidence intervals not available for this model. Bootstrapping is used instead.";
    end;
    if (notecode[i,1]=16) then;do;
      print "NOTE: The number of Monte Carlo confidence intervals was adjusted upward given your desired confidence.";
    end;
    if (notecode[i,1]=19) then;do;
      print "NOTE: Your contrast matrix is invalid or not applicable to this model.";
    end;
    if (notecode[i,1]=20) then;do;
      print "NOTE: One of the groups specified by your contrast matrix does not exist in the data.";
    end;
    if (notecode[i,1]=21) then;do;
      print "NOTE: The VARORDER option is not available in this release.";
    end;
    if (notecode[i,1]=22) then;do;
      print "NOTE: The VMODVAL and QMODVAL options are not available in this release.";
    end;
    if (notecode[i,1]=23) then;do;
      print "NOTE: The QUANTILE option is not available in this release.";
    end; 
	if (notecode[i,1]=24) then;do;
	  print "NOTE: Total effect model not available with dichotomous Y.";
	end;
	if (notecode[i,1]=25) then;do;
	  print "NOTE: EFFSIZE/STAND options not available with dichotomous Y.";
	end;
    if ((notecode[i,1]=26) & (nms > 0)) then;do;
	  print "NOTE: Direct and indirect effects of X on Y are on a log-odds metric.";
	end;
	if (notecode[i,1]=27) then;do;
	  print "NOTE: Regression diagnostics are not available for models with a dichotomous Y.";
	end;
    if (notecode[i,1]=28) then;do;
	  print "NOTE: The contrast option is not available with a multicategorical X.";
	end;
	if (notecode[i,1]=31) then;do;
	  if (nms > 1) then;do;
	    print "NOTE: Controlled direct effect(s) estimated at the following mediator values:" , medmeans [label=" " colname=mnames format=&decimals];
	  end;
	  if (nms=1) then;do;
	  	print "NOTE: Controlled direct effect(s) estimated at the following mediator value:" medmeans [label=" " format=&decimals];
	  end;
	end;
    if (notecode[i,1]=33) then;do;
	  print "NOTE: Sobel test is not available with use of the XMINT option.";
	end;
    if (notecode[i,1]=34) then;do;
	  print "NOTE: Standardized effects are not available when using the XMINT option.";
	end;
	if (notecode[i,1]=35) then;do;
	  print coval [label="NOTE: Counterfactual effects estimated at the following covariate values:" colname=covnames format=&decimals];
	end;
    if (notecode[i,1]=36) then;do;
	  print "NOTE: The XREFVAL option is ignored when X is declared as multicategorical.";
	end;
	if (notecode[i,1]=37) then;do;
	  print "NOTE: CONTRAST option not available with use of the XMINT option.";
	end;
    if (notecode[i,1] = 38) then;do;
      print "NOTE: One or more cases were deleted prior to analysis at your request.";
    end;
	if (notecode[i,1]=39) then;do;
      print "NOTE: Due to a naming conflict, regression diagnostics were not saved.";
    end; 
    /* starts here */;
    if ((notecode[i,1]=29) & (listmiss=1)) then;do;
      a=missrow;conum=ncol(a);allgood=0;smremain=12;largesti=1;smallrow=0;
      if (conum > 12) then;do;
        do ii = 1 to 12;
          check=(conum/ii);
          if (check = floor(check)) then;do;
            check2=conum/ii;aok=ii;
            if (aok > 2) then;do;allgood=1;end;
	      end;
          if (check ^= floor(check)) then;do;      
            remain=conum-(ii*floor(check));
            if (remain <= smremain) then;do;
              smremain=remain;largesti=ii;smallrow=floor(conum/largesti);            
            end;
          end;
        end;
        atemp=a[1,1:(aok*check2)];atemp=shape(atemp,check2,aok);
        if (ncol(atemp) > 2) then;do;
          print "NOTE: The following row(s) of data were deleted from the analysis due to missingness:", atemp [label=" " format=6.0];
        end;
        if (allgood=0) then;do;
          atemp=a[1,1:(smallrow*largesti)];
          atemp=shape(atemp,smallrow,largesti);
          btemp=a[1,((largesti*smallrow)+1):conum];
          print "NOTE: The following row(s) of data were deleted from the analysis due to missingness:", atemp, [label=" " format=6.0];
          print btemp [label=" " format=6.0];
        end;
	  end;
      if (conum <= 12) then;do;
        print "NOTE: The following row(s) of data were deleted from the analysis due to missingness:" a [label=" " format=6.0];
      end;
    end;
	/* ends here */;
 
  end;
  if (eivdo=1) then;do;
    varneiv=varnames[1,2:ncol(varnames)];
	eivrel2=eivrel[1,nxvls:ncol(eivrel)];
	if (ncol(eivrel2) < 9) then;do;
	  print "NOTE: The errors-in-variables analysis assumes the following reliabilities:", eivrel2 [label=" " colname=varneiv format=8.4]; 
	end;
	if (ncol(eivrel2) >= 9) then;do;
	  eivrel2=eivrel2`;
      print "NOTE: The errors-in-variables analysis assumes the following reliabilities:", eivrel2 [label=" " rowname=varneiv format=8.4]; 
	end;
  end;

  end;
end;

* PRINT ERRORS;
do i = 1 to 100;
  if (errcode[i,1]=1) then;do;
    print "ERROR: You must specify a Y and an X variable.";
  end;
  if (errcode[i,1]=2) then;do;
    print "ERROR: X, M, or Y variable used more than once or W and Z are the same variable.";
    if (toomany = 1) then;do;
	  reset printadv=0;
      print "       This might be caused by the use of variables names longer than eight characters.";
	  reset printadv=1;
    end;
  end;
  if (errcode[i,1]=3) then;do;
    print "ERROR: This model accepts only one variable for W, Y, X, Z, or Cluster.";
  end;
  if (errcode[i,1]=4) then;do;
    print "ERROR: A variable specified as multicategorical has more than nine categories.";
  end;
  if (errcode[i,1]=5) then;do;
    print "ERROR: One of the categories contains only a single case.";
  end;
  if (errcode[i,1]=6) then;do;
    print "ERROR: Invalid model number in this version of PROCESS.";
  end;
  if (errcode[i,1]=7) then;do;
    print "ERROR: Invalid model number.";
  end;
  if (errcode[i,1]=8) then;do;
    print "ERROR: You must specify an M variable for this model.";
  end;
  if (errcode[i,1]=9) then;do;
    print "ERROR: You have specified an M variable in a model that does not use it.";
  end;
  if (errcode[i,1]=10) then;do;
    print "ERROR: You have specified a W variable in a model that does not use it.";
  end;
  if (errcode[i,1]=11) then;do;
    print "ERROR: You have not specified a W variable in a model that requires it.";
  end;
  if (errcode[i,1]=12) then;do;
    print "ERROR: You have specified a Z variable in a model that does not use it.";
  end;
  if (errcode[i,1]=13) then;do;
    print "ERROR: You have not specified a Z variable in a model that requires it.";
  end;
  if (errcode[i,1]=14) then;do;
    print "ERROR: V and Q are not proper specifications in this release of PROCESS.";
	reset printadv=0;
    print "       Moderators must be specified as W and/or Z.";
	reset printadv=1;
  end;
  if (errcode[i,1]=15) then;do;
    print "ERROR: One of your model variables exhibits no variation (it is a constant).";
  end;
  if (errcode[i,1]=16) then;do;
    print "ERROR: BMATRIX is not the correct length or is otherwise invalid.";
  end;
  if (errcode[i,1]=17) then;do;
    print "ERROR: WMATRIX is not the correct length or is otherwise invalid.";
  end;
  if (errcode[i,1]=18) then;do;
    print "ERROR: ZMATRIX is not the correct length or is otherwise invalid.";
  end;
  if (errcode[i,1]=19) then;do;
    print "ERROR: WZMATRIX is not the correct length or is otherwise invalid.";
  end;
  if (errcode[i,1]=20) then;do;
    print "ERROR: A path fixed at zero cannot be moderated.";
  end;
  if (errcode[i,1]=21) then;do;
    print "ERROR: If only one moderator is specified, it must be specified as W.";
  end;
  if (errcode[i,1]=22) then;do;
    print "ERROR: In BMATRIX, X must be specified to affect at least one variable.";
  end;
  if (errcode[i,1]=23) then;do;
    print "ERROR: In BMATRIX, at least one variable must be specified to affect Y.";
  end;
  if (errcode[i,1]=24) then;do;
    print "ERROR: You must specify a model number or a custom BMATRIX specification.";
  end;
  if (errcode[i,1]=25) then;do;
    print "ERROR: BMATRIX cannot be used in conjunction with a model number.";
  end;
  if (errcode[i,1]=26) then;do;
    print "ERROR: Your model has a dangling mediator (all Ms must affect and be affected).";
  end;
  if (errcode[i,1]=27) then;do;
    print "ERROR: CLUSTER is not available on this release of PROCESS.";
  end;
  if (errcode[i,1]=29) then;do;
    print "ERROR: CMATRIX is not the correct length or is otherwise invalid.";
  end;
  if (errcode[i,1]=30) then;do;
    print "ERROR: In CMATRIX, all covariates must be assigned to an M or a Y.";
  end;
  if (errcode[i,1]=31) then;do;
    print "ERROR: A linear or near linear dependency (singularity) exists in the data.";
  end;
  if (errcode[i,1]=32) then;do;
    print "ERROR: Models 80 and 81 require between 3 and 6 mediators.";
  end;
  if (errcode[i,1]=33) then;do;
    print "ERROR: Model 82 requires 4 mediators.";
  end;
  if (errcode[i,1]=34) then;do;
    print "ERROR: This model number requires between 2 and 6 mediators.";
  end;
  if (errcode[i,1]=35) then;do;
    print "ERROR: In a model with only one moderator, that moderator must be W.";
  end;
  if (errcode[i,1]=36) then;do;
    print "ERROR: A serial mediation model cannot have more than 6 mediators.";
  end;
  if (errcode[i,1]=37) then;do;
    print "ERROR: No more than 10 mediators are allowed in a PROCESS command.";
  end;
  if (errcode[i,1]=38) then;do;
    print "ERROR: XCATCODE is not provided, not the correct length, or is otherwise invalid.";
  end;
  if ((errcode[i,1]=48) & (v2tag=0)) then;do;
    print "ERROR: You are using outdated syntax. The current version of PROCESS";
	reset printadv=0;
	print "       is documented in Appendices A and B of www.guilford.com/p/hayes3";
	reset printadv=1;
	v2tag=1;
  end;
  if (errcode[i,1]=39) then;do;
    print "ERROR: WCATCODE is not provided, not the correct length, or is otherwise invalid.";
  end;
  if (errcode[i,1]=40) then;do;
    print "ERROR: ZCATCODE is not provided, not the correct length, or is otherwise invalid.";
  end;
  if (errcode[i,1]=41) then;do;
    print "ERROR: Models 1, 2, and 3 cannot be customized.";
  end;
  if (errcode[i,1]=42) then;do;
    print "ERROR: WS option available only in PROCESS v2. Or use the MEMORE macro instead.";
	reset printadv=0;
    print "       MEMORE can be downloaded from www.akmontoya.com.";
	reset printadv=1;
  end;
  if (errcode[i,1]=43) then;do;
    print "ERROR: PROCESS does not allow dichotomous mediators.";
  end;
  if (errcode[i,1]=50) then;do;
    print "ERROR: A multicategorical moderator cannot be specified as a covariate.";
  end;
  if (errcode[i,1]=60) then;do;
	print "PROCESS is now ready for use.";
    reset printadv=0;
	print " ";
	print "Copyright 2013-2025 by Andrew F. Hayes. ALL RIGHTS RESERVED.";
	print "Workshop schedule at haskayne.ucalgary.ca/CCRAM";
	print "More informationa about PROCESS at processmacro.org/faq.html";
	reset printadv=1;
  end;
  if (errcode[i,1]=62) then;do;
      print "ERROR: After listwise deletion of cases with missing data, too few cases remain.";       
  end;
  if (errcode[i,1]=51) then;do;
    print "ERROR: A variable you specified as a covariate is a moderator in all equations.";
  end;
  if ((errcode[i,1]=52) & (mcerpt=0)) then;do;
    mcerpt=1;
    print "ERROR: A variable specified as multicategorical must have at least three categories.";
  end;
  if (errcode[i,1]=47) then;do;
    if (iterrmod=1) then;do;
      print "ERROR: Iteration for Y model did not converge to a solution. Interpret results with caution.";
	  reset printadv=0;
	  print"        Try increasing the number of iterations, though this will slow down computation.";
	  reset printadv=1;
	end;
	if (bootiter=1) then;do;
	  print "ERROR: Nonconvergence during bootstrapping. Interpret bootstrap results with caution.";
	end;
  end;
  if (errcode[i,1]=63) then;do;
    print "ERROR: The XMINT option is available only for model 4.";
  end;
  if (errcode[i,1]=64) then;do;
    print "ERROR: Incorrect number of values specified in CDEVAL option.";
  end;
  if (errcode[i,1]=65) then;do;
    print "ERROR: Only indicator or sequential coding is allowed with the XMINT option.";
  end;
  if (errcode[i,1]=66) then;do;
    print "ERROR: A reference value of X is required for this model.";
  end;
  if (errcode[i,1]=67) then;do;
    print "ERROR: Too many elements provided in XREFVAL option.";
  end;
  if (errcode[i,1]=68) then;do;
    print "ERROR: Covariate assignment is not allowed with XMINT option.";
  end;
  if (errcode[i,1]=69) then;do;
    print "ERROR: Incorrect number of values specified in COVAL option.";
  end;
  if (errcode[i,1]=70) then;do;
    print "ERROR: Incorrect value(s) in XREFVAL for this dichotomous X variable.";
  end;
  if (errcode[i,1]=71) then; do;
    print "ERROR: The CENTER option is not available when using the XMINT option";      
  end;
  if (errcode[i,1]=72) then; do;
    print "ERROR: The XMINT option is not available for models with a dichotomous Y.";      
  end;
  if (errcode[i,1]=73) then; do;
    print "ERROR: The SPLINE option allows no more than 8 joints.";      
  end;
  if (errcode[i,1]=74) then; do;
    print "ERROR: Spline joint locations must be listed in ascending order with no ties.";      
  end;
  if (errcode[i,1]=75) then; do;
    print "ERROR: All spline joint locations must be larger than the minimum observed value.";      
  end;
  if (errcode[i,1]=76) then; do;
    print "ERROR: Each spline segment must contain at least two cases.";      
  end;
  if errcode[i,1]=77 then;do;
    print "ERROR: The SPLINE option is not available for this model.";
  end;  
  if errcode[i,1]=78 then;do;
    print "ERROR: CLUSTER requires use of the ROBUSTSE or CLUSBOOT options.";
  end;  
  if errcode[i,1]=79 then;do;
    print "ERROR: ROBUSTSE and CLUSBOOT options require a clustering variable.";
  end;  
  if errcode[i,1]=80 then;do;
    print "ERROR: A variable in your PROCESS command does not exist in the data.";
  end;  
  if errcode[i,1]=81 then;do;
    print "ERROR: Cluster robust standard errors not available with a dichotomous Y.";
  end;
  if errcode[i,1]=82 then;do;
    print "ERROR: Errors-in-variables estimation not allowed for this model.";
  end;  
  if errcode[i,1]=83 then;do;
    print "ERROR: Incorrect number of reliabilities provided.";
  end;  
  if errcode[i,1]=84 then;do;
    print "ERROR: Reliabilities must be larger than 0 and no larger than 1.";
  end;  
  if errcode[i,1]=85 then;do;
    print "ERROR: One of the assumed reliabilities is too small to estimate the model.";
  end;  
  if errcode[i,1]=86 then;do;
    print "ERROR: Errors-in-variables estimation not available with a dichotomous Y.";
  end;  
  if errcode[i,1]=87 then;do;
    print "ERROR: The ROBUSTSE and HC options are not available with errors-in-variables";
	reset printadv=0;
	print "       estimation. Use the eiv option or let it default to eiv=3.";
	reset printadv=1;
  end;  
  if errcode[i,1]=88 then;do;
    print "ERROR: Invalid argument for EIV option.";
  end;
end;
if ((criterr=0) & (saveest=1)) then;do;
  if (boot > 0) then;do;
    erroutp=badboot||singerc||eiverc;
	%outform3 (outtodo=erroutp,outbig=maxresm);
  end;
  resultm=resultm[2:nrow(resultm),];
  bocaj=(resultm=99999);bocaj=(bocaj[+,]);
  bocaj=1-(bocaj=nrow(resultm));
  j=1;
  do i = 1 to ncol(resultm);
    if (bocaj[1,i]=1) then;do;j=j+1;end;
  end;
  resultm=resultm[,1:(j-1)];
  do i = 1 to ncol(resultm);do j = 1 to nrow(resultm);
    if (resultm[j,i]=99999) then;do;resultm[j,i]=.;end;
  end;end;
  if (saveest=1) then;do; 
    create &outputf from resultm;
    append from resultm;
    close &outputf;
  end;
end;
reset center;
quit;
options pagesize=54;
%mend process;
%process (data=test,activate=1);

